from gurobipy import *
import pandas as pd
from matplotlib import pyplot as plt



#IMPORT DEL DATAFRAME DEI COSTI DETERMINISTICI
df1=pd.read_csv('dataframes/DF_CostiTotaliDet10.csv')

#STILE DEL PLOT
plt.style.use("ggplot")

#PARAMETRI PER GRAFICI (ALPHA,T)
alphas=[0.55,0.6,0.65,0.7,0.75,0.8,0.85,0.9,0.95]
indexes=[(0,0),(0,1),(1,0),(1,1)]

T=[20,30,40,50]
T_star=10

#GRAFICI DI CONFRONTO TRA DIVERSI T ED ALPHA
#FOR SUL NUMERO DI PERIODI SCARTATI 
#(NEL NOSTRO CASO SONO STATI TUTTI CONSIDERATI)
for disc in[0]:
    fig, ax=plt.subplots(nrows=2, ncols=2, sharex=True)
    fig.suptitle('Confronto tra diversi T ed alpha')

    #DATAFRAME TEMPORANEO CON ORIZZONTE TEMPORALE T=10 
    #(PRESO COME METRO DI PARAGONE PER ALTRI T)
    df10=df1[(df1['Discarded periods']==disc) & (df1['T']==T_star)]
    #DATAFRAME TEMPORANEO DIVISO IN GRUPPI IN BASE AL VALORE DI ALPHA
    groups_10=df10.groupby('alpha')
    
    #FOR PER SCANDIRE I 4 GRAFICI DELLA FIGURA
    for i in range(4):
        #INDICE DEL GRAFICO SU CUI PLOTTARE
        index=indexes[i]
        #VALORE DI T DA CONFRONTARE CON T*=10
        T_current=T[i]
        #DATAFRAME TEMPORANEO CON ORIZZONTE TEMPORALE T=T_current 
        df_tempT=df1[(df1['Discarded periods']==disc) & (df1['T']==T_current)]
        
        #DATAFRAME TEMPORANEO DIVISO IN GRUPPI IN BASE AL VALORE DI ALPHA
        groupsT=df_tempT.groupby('alpha')

        #PLOT DI CONFRONTO TRA I COSTI MEDI DIVISI PER ALPHA, 
        #TRA T* E T_current
        ax[index].plot(alphas,groups_10.mean()['Cost'],marker=".",label="T={}".format(T_star))
        ax[index].plot(alphas,groupsT.mean()['Cost'],marker=".",label="T={}".format(T_current))
        ax[index].legend()
        
        if (index[1]==0):
            ax[index].set_ylabel('Costo medio')

        if (index[0]==1):
            ax[index].set_xlabel('alpha')

plt.show()