from gurobipy import *
import pandas as pd
from matplotlib import pyplot as plt

plt.style.use("ggplot")

#DATAFRAME 1: COSTI TOTALI COL MODELLO DETERMINISTICO 
#E SCORTE DI SICUREZZA
df1=pd.read_csv('dataframes/DF_CostiTotaliDet10.csv')

#DATAFRAME 2: COSTI TOTALI COL MODELLO DETERMINISTICO 
#E SCORTE DI SICUREZZA DOPO 2 ISTANTI DI TEMPO
df2=pd.read_csv('dataframes/DF_CostiTotaliDet11_2.csv')

df2.rename(columns={"Seed parameters":"Seed_parameters","Solver type":"Solver_type","Path number":"Path_number","Time Limit":"Time_limit","MIP Gap":"MIP_Gap","Discarded periods":"Discarded_periods"},inplace=True)

alphas=[0.6,0.65,0.7,0.75,0.8]
T=[10,20,30,40,50]

#GRAFICI DI CONFRONTO TRA SOLVER DETERMINISTICO CON SCORTE DI SICUREZZA
#E SUA VARIANTE (SCORTE DAL TERZO ISTANTE TEMPORALE)
#FOR SUL NUMERO DI PERIODI SCARTATI 
#(NEL NOSTRO CASO SONO STATI TUTTI CONSIDERATI)  
for disc in[0]:
    fig, ax=plt.subplots(nrows=1, ncols=5, sharey=True)
        
    #FOR SUI 5 DIVERSI VALORI DI T SPERIMENTATI
    for i in range(5):
        T_current=T[i]
        #DATAFRAME 1 TEMPORANEO CON ORIZZONTE TEMPORALE T 
        #DELL'ITERAZIONE IN CORSO
        df_tempT=df1[(df1['Discarded periods']==disc) & (df1['T']==T_current)]
        #DATAFRAME 2 TEMPORANEO CON ORIZZONTE TEMPORALE T 
        #DELL'ITERAZIONE IN CORSO
        df_tempT2=df2[(df2['Discarded_periods']==disc) & (df2['T']==T_current)]
        
        #DATAFRAME 1 TEMPORANEO DIVISO IN GRUPPI IN BASE AL VALORE DI ALPHA
        groupsT=df_tempT.groupby('alpha')
        #DATAFRAME 2 TEMPORANEO DIVISO IN GRUPPI IN BASE AL VALORE DI ALPHA
        groupsT2=df_tempT2.groupby('alpha')

        y1=groupsT.mean()['Cost'][[0.6,0.65,0.7,0.75,0.8]]

        #PLOT DI CONFRONTO DEI RISULTATI DEI DUE SOLVER DETERMINISTICI
        #DIVISI PER ALPHA
        ax[i].plot(alphas,y1,marker=".",label="Solver Det")
        ax[i].plot(alphas,groupsT2.mean()['Cost'],marker=".",label="Solver Det 2")
        ax[i].legend()

        ax[i].set_title('Orizzonte T={}'.format(T_current))

        
        if (i==0):
            ax[i].set_ylabel('Costo medio')

        ax[i].set_xlabel('alpha')    
            

plt.show()

#GRAFICI SUI COSTI DISAGGREGATI DEI DUE SOLVER DETERMINISTICI
#DATAFRAME 1 DIVISO IN GRUPPI IN BASE AL VALORE DI ALPHA
types1=df1.groupby('alpha')
#DATAFRAME 2 DIVISO IN GRUPPI IN BASE AL VALORE DI ALPHA
types2=df2.groupby('alpha')

y1=[]
y2=[]
y3=[]
y4=[]
y5=[]
y6=[]
y7=[]
y8=[]

fig,ax=plt.subplots(nrows=2,ncols=2)

#FOR SUI 5 VALORI DI ALPHA CONSIDERATI
for i in range(5):
    #COSTO DI MAGAZZINO MEDIO SOLVER DET1
    y1.append(types1.mean()['h_cost'][alphas[i]])
    #COSTO DI MAGAZZINO MEDIO SOLVER DET2
    y2.append(types2.mean()['h_cost'][alphas[i]])
    #COSTO VENDITE PERSE MEDIO SOLVER DET1
    y3.append(types1.mean()['g_cost'][alphas[i]])
    #COSTO VENDITE PERSE MEDIO SOLVER DET2
    y4.append(types2.mean()['g_cost'][alphas[i]])
    #COSTO DI SETUP MEDIO SOLVER DET1
    y5.append(types1.mean()['f_cost'][alphas[i]])
    #COSTO DI SETUP MEDIO SOLVER DET2
    y6.append(types2.mean()['f_cost'][alphas[i]])
    #COSTO TOTALE MEDIO SOLVER DET1
    y7.append(types1.mean()['Cost'][alphas[i]])
    #COSTO TOTALE MEDIO SOLVER DET2
    y8.append(types2.mean()['Cost'][alphas[i]])

#GRAFICO CONFRONTO COSTI DI MAGAZZINO
ax[(0,1)].plot(alphas,y1,marker='.',label='h_cost Det')
ax[(0,1)].plot(alphas,y2,marker='.',label='h_cost Det 2')
#GRAFICO CONFRONTO COSTI VENDITE PERSE
ax[(1,0)].plot(alphas,y3,marker='.',label='g_cost Det')
ax[(1,0)].plot(alphas,y4,marker='.',label='g_cost Det 2')
#GRAFICO CONFRONTO COSTI DI SETUP
ax[(1,1)].plot(alphas,y5,marker='.',label='f_cost Det')
ax[(1,1)].plot(alphas,y6,marker='.',label='f_cost Det 2')
#GRAFICO CONFRONTO COSTI TOTALI
ax[(0,0)].plot(alphas,y7,marker='.',label='Cost Det')
ax[(0,0)].plot(alphas,y8,marker='.',label='Cost Det 2')

ax[(0,0)].legend()
ax[(0,1)].legend()
ax[(1,0)].legend()
ax[(1,1)].legend()

fig.suptitle('Confronto costi disaggregati')

ax[(0,0)].set_ylabel('Costi medi')
ax[(1,0)].set_ylabel('Costi medi')

ax[(1,0)].set_xlabel('alpha')
ax[(1,1)].set_xlabel('alpha')

plt.show()

#GRAFICI DI CONFRONTO MAGAZZINO, VENDITE PERSE E SETUP TRA I 
#DUE SOLVER DETERMINISTICI, DIVISI PER PRODOTTO

#DATAFRAME COSTI SOLVER DETERMINISTICO 1 ISTANTE PER ISTANTE
df1=pd.read_csv('dataframes/DatiSimulazioniRHDet13.csv')
#RIDOTTO IL DATAFRAME AI SOLI VALORI ESAMINATI CON IL SECONDO SOLVER
#PER FARE CONFRONTO
df1=df1[(df1['alpha']==0.6)|(df1['alpha']==0.65)|(df1['alpha']==0.7)|(df1['alpha']==0.75)|(df1['alpha']==0.80)]

#DATAFRAME COSTI SOLVER DETERMINISTICO 2 ISTANTE PER ISTANTE
df2=pd.read_csv('dataframes/DatiSimulazioniRHDet14_2.csv')


fig1,ax1=plt.subplots(nrows=5, ncols=1, sharex=True)
fig2,ax2=plt.subplots(nrows=5, ncols=1, sharex=True)
fig3,ax3=plt.subplots(nrows=5, ncols=1, sharex=True)

#FOR PER SCANDIRE I 5 PRODOTTI
for j in range(5):

    x=[]
    y1=[]
    y2=[]
    y3=[]
    y4=[]
    y5=[]
    y6=[]

    #FOR PER SCANDIRE I 50 ISTANTI DI TEMPO DI OGNI
    #PERCORSO DI DOMANDA OUT OF SAMPLE
    for i in range(50):

        x.append(i)
        #DATAFRAME TEMPORANEO 1, RIDOTTO ALL'ISTANTE DI TEMPO i
        df_1=df1[(df1['Time period']==i)]

        #SOLVER DET1:
        #SETUP MEDIO PER IL PRODOTTO j ALL'ISTANTE i
        S=df_1['S{}'.format(j)].mean()
        #MAGAZZINO MEDIO PER IL PRODOTTO j ALL'ISTANTE i
        I=df_1['I{}'.format(j)].mean()
        #VENDITE PERSE MEDIE PER IL PRODOTTO j ALL'ISTANTE i
        Z=df_1['Z{}'.format(j)].mean()

        y1.append(S)
        y2.append(I)
        y3.append(Z)

        #DATAFRAME TEMPORANEO 2, RIDOTTO ALL'ISTANTE DI TEMPO i
        df_2=df2[df2['Time period']==i]

        #SOLVER DET2:
        #SETUP MEDIO PER IL PRODOTTO j ALL'ISTANTE i
        S2=df_2['S{}'.format(j)].mean()
        #MAGAZZINO MEDIO PER IL PRODOTTO j ALL'ISTANTE i
        I2=df_2['I{}'.format(j)].mean()
        #VENDITE PERSE MEDIE PER IL PRODOTTO j ALL'ISTANTE i
        Z2=df_2['Z{}'.format(j)].mean()

        y4.append(S2)
        y5.append(I2)
        y6.append(Z2)

    #PLOT DI CONFRONTO DEI SETUP MEDI
    fig1.suptitle('SETUP MEDI')
    ax1[j].plot(x,y1,marker='.',label='Solver Det')  
    ax1[j].plot(x,y4,marker='.',label='Solver Det 2')
    ax1[j].set_title('Prodotto {}'.format(j))

    #PLOT DI CONFRONTO DEI MAGAZZINI MEDI
    fig2.suptitle('MAGAZZINO MEDIO')
    ax2[j].plot(x,y2,marker='.',label='Solver Det')  
    ax2[j].plot(x,y5,marker='.',label='Solver Det 2')
    ax2[j].set_title('Prodotto {}'.format(j))

    #PLOT DI CONFRONTO DELLE VENDITE PERSE MEDIE
    fig3.suptitle('VENDITE PERSE MEDIE')
    ax3[j].plot(x,y3,marker='.',label='Solver Det')  
    ax3[j].plot(x,y6,marker='.',label='Solver Det 2')
    ax3[j].set_title('Prodotto {}'.format(j))

    if j==0:
        ax1[j].legend()
        ax2[j].legend()
        ax3[j].legend()

    if j==4:
        ax1[j].set_xlabel('Istante di tempo')
        ax2[j].set_xlabel('Istante di tempo')
        ax3[j].set_xlabel('Istante di tempo')

plt.show()