import pandas as pd
from matplotlib import pyplot as plt

#IMPORT DEL DATAFRAME DEI COSTI TOTALI
df=pd.read_csv('dataframes/DF_CostiTotali7.csv')
#IMPORT DEL DATAFRAME DELLE SIMULAZIONI ROLLING HORIZON
df2=pd.read_csv('dataframes/DatiSimulazioniRH6.csv')

plt.style.use("ggplot")

#VETTORE DEI FATTORI DI RAMIFICAZIONE
branching_factors=[[5,3,2],[6,5,2],[5,3,2,2],[9,5,2,1],[5,3,3,2,1]]


#GRAFICO DI CONFRONTO COSTI E TEMPI

#CICLO FOR PER EVENTUALMENTE SCARTARE NUMERO INIZIALE DI PERIODI
for disc in [0]:
    fig,ax=plt.subplots(nrows=2, ncols=1, sharex=True)
    
    #DATAFRAME COSTI TOTALI RIDOTTO A QUELLI CON disc PERIODI INIZIALI SCARTATI
    df_temp=df[(df["Discarded periods"]==disc)]

    branch_fact=[]
    y0=[]
    y1=[]
    t0=[]
    t1=[]
    
    #CICLO SUI FATTORI DI RAMIFICAZIONE
    for i in range(5):


        branching_factor=branching_factors[i]
        str="".join(["[",",".join([f"{ele}" for ele in branching_factor]),"]"])
        #RIDUZIONE DEL DATAFRAME ALLE SOLE SIMULAZIONI CON IL BRANCHING FACTOR
        #DELL'ITERAZIONE FOR IN CORSO.
                
        df_1=df_temp[(df_temp["Branching factors"]==str)]


        #COSTO MEDIO CON ALBERO STANDARD   
        cost0=df_1[df_1["Tree type"]==0]['Cost'].mean()
        #TEMPO MEDIO CON ALBERO STANDARD
        time0=df_1[df_1["Tree type"]==0]['Time'].mean()
        #COSTO MEDIO CON ALBERO SOBOL
        cost1=df_1[df_1["Tree type"]==1]['Cost'].mean()
        #TEMPO MEDIO CON ALBERO SOBOL
        time1=df_1[df_1["Tree type"]==1]['Time'].mean()

        #SE NECESSARIA, STAMPA DEI COSTI
        #print(cost0, cost1, time0, time1)
        branch_fact.append(str)
        y0.append(cost0)
        y1.append(cost1)
        t0.append(time0)
        t1.append(time1)

    #GRAFICO DI CONFRONTO DEI COSTI                
    ax[0].plot(branch_fact,y0,marker=".",label="Standard Tree")
    ax[0].plot(branch_fact,y1,marker=".",label="Sobol Tree")
    ax[0].legend()
    ax[0].set_title("Costi")
    ax[0].set_ylabel('Costo Totale')
    #GRAFICO DI CONFRONTO DEI TEMPI
    ax[1].plot(branch_fact,t0,marker=".",label="Standard Tree")
    ax[1].plot(branch_fact,t1,marker=".",label="Sobol Tree")
    ax[1].legend()
    ax[1].set_title("Tempi")
    ax[1].set_ylabel('Tempo Totale')


    ax[1].set_xlabel('Branching Factors')


#GRAFICO DEI COSTI DISAGGREGATI PER ALBERO STANDARD 

#FOR SU NUMERO ISTANTI INIZIALI EVENTUALMENTE DA SCARTARE
for disc in [0]:
    fig,ax=plt.subplots(nrows=1, ncols=1, sharex=True)
    
    #DATAFRAME COSTI TOTALI RIDOTTO A QUELLI CON disc PERIODI INIZIALI SCARTATI
    df_temp=df[(df["Discarded periods"]==disc)]

    branch_fact=[]
    y0=[]
    y1=[]
    y2=[]
    y3=[]
    
    #CICLO SUI FATTORI DI RAMIFICAZIONE
    for i in range(5):

        #RIDUZIONE DEL DATAFRAME ALLE SOLE SIMULAZIONI CON IL BRANCHING FACTOR
        #DELL'ITERAZIONE FOR IN CORSO.

        branching_factor=branching_factors[i]
        str="".join(["[",",".join([f"{ele}" for ele in branching_factor]),"]"])

                
        df_1=df_temp[(df_temp["Branching factors"]==str)]


        #COSTO MEDIO CON ALBERO STANDARD    
        cost0=df_1[df_1["Tree type"]==0]['Cost'].mean()
        #COSTO DI MAGAZZINO MEDIO CON ALBERO STANDARD
        h_cost0=df_1[df_1["Tree type"]==0]['h_cost'].mean()
        #COSTO VENDITE PERSE MEDIO CON ALBERO STANDARD
        g_cost0=df_1[df_1["Tree type"]==0]['g_cost'].mean()
        #COSTO SETUP MEDIO CON ALBERO STANDARD
        f_cost0=df_1[df_1["Tree type"]==0]['f_cost'].mean()

        #SE NECESSARIO, STAMPA DEI COSTI
        #print(cost0,h_cost0,g_cost0,f_cost0)

        branch_fact.append(str)
        y0.append(cost0)
        y1.append(h_cost0)
        y2.append(g_cost0)
        y3.append(f_cost0)
        #y1.append(cost1)


    #GRAFICO DEI COSTI DISAGGREGATI PER L'ALBERO STANDARD                
    ax.plot(branch_fact,y0,marker=".",label="Costo totale")
    ax.plot(branch_fact,y1,marker=".",label="Costo magazzino")
    ax.plot(branch_fact,y2,marker=".",label="Costo vendite perse")
    ax.plot(branch_fact,y3,marker=".",label="Costo set up")
    ax.legend(bbox_to_anchor=(1, 0.75))
    ax.set_title('Costi disaggregati albero standard')
    ax.set_ylabel('Costo')
    ax.set_xlabel('Branching factors')

#GRAFICO DI CONFRONTO DEI COSTI DISAGGREGATI PER ALBERO DI TIPO SOBOL


#FOR SU NUMERO ISTANTI INIZIALI EVENTUALMENTE DA SCARTARE
for disc in [0]:
    fig,ax=plt.subplots(nrows=2, ncols=2, sharex=True)
    
    #DATAFRAME COSTI TOTALI RIDOTTO A QUELLI CON disc PERIODI INIZIALI SCARTATI
    df_temp=df[(df["Discarded periods"]==disc)]

    branch_fact=[]
    y0=[]
    y1=[]
    y2=[]
    y3=[]
    y4=[]
    y5=[]
    y6=[]
    y7=[]
    
    #CICLO SUI FATTORI DI RAMIFICAZIONE
    for i in range(5):

        branching_factor=branching_factors[i]

        str="".join(["[",",".join([f"{ele}" for ele in branching_factor]),"]"])
        
        #RIDUZIONE DEL DATAFRAME ALLE SOLE SIMULAZIONI CON IL BRANCHING FACTOR
        #DELL'ITERAZIONE FOR IN CORSO. FATTORE DI SCALAMENTO +/-1 
        #PER COERENZA ORDINE DEI BRANCHING FACTORS

              
        df_1=df_temp[(df_temp["Branching factors"]==str)]


        #COSTO MEDIO CON ALBERO STANDARD    
        cost0=df_1[df_1["Tree type"]==0]['Cost'].mean()
        #COSTO MAGAZZINO MEDIO CON ALBERO STANDARD  
        h_cost0=df_1[df_1["Tree type"]==0]['h_cost'].mean()
        #COSTO VENDITE PERSE MEDIO CON ALBERO STANDARD  
        g_cost0=df_1[df_1["Tree type"]==0]['g_cost'].mean()
        #COSTO SETUP MEDIO CON ALBERO STANDARD  
        f_cost0=df_1[df_1["Tree type"]==0]['f_cost'].mean()
        #COSTO MEDIO CON ALBERO SOBOL  
        cost1=df_1[df_1["Tree type"]==1]['Cost'].mean()
        #COSTO MAGAZZINO MEDIO CON ALBERO SOBOL
        h_cost1=df_1[df_1["Tree type"]==1]['h_cost'].mean()
        #COSTO VENDITE PERSE MEDIO CON ALBERO SOBOL
        g_cost1=df_1[df_1["Tree type"]==1]['g_cost'].mean()
        #COSTO SETUP MEDIO CON ALBERO SOBOL
        f_cost1=df_1[df_1["Tree type"]==1]['f_cost'].mean()

        #SE NECESSARIO, STAMPA DEI COSTI
        #print(cost1,h_cost1,g_cost1,f_cost1)

        branch_fact.append(str)
        y0.append(cost0)
        y1.append(h_cost0)
        y2.append(g_cost0)
        y3.append(f_cost0)
        y4.append(cost1)
        y5.append(h_cost1)
        y6.append(g_cost1)
        y7.append(f_cost1)
        
    #GRAFICO COSTI DISAGGREGATI, ALBERO SOBOL
    ax[(0,0)].set_title('Costi disaggregati Sobol')                
    ax[(0,0)].plot(branch_fact,y4,marker=".",label="Costo totale")
    ax[(0,0)].plot(branch_fact,y5,marker=".",label="Costo magazzino")
    ax[(0,0)].plot(branch_fact,y6,marker=".",label="Costo vendite perse")
    ax[(0,0)].plot(branch_fact,y7,marker=".",label="Costo set up")
    #GRAFICO CONFRONTO COSTI MAGAZZINO COI DUE ALBERI
    ax[(0,1)].set_title('Costi di magazzino')
    ax[(0,1)].plot(branch_fact,y1,marker=".",label="Albero standard")
    ax[(0,1)].plot(branch_fact,y5,marker=".",label="Albero Sobol")
    #GRAFICO CONFRONTO COSTI VENDITE PERSE COI DUE ALBERI
    ax[(1,0)].set_title('Costi vendite perse')
    ax[(1,0)].plot(branch_fact,y2,marker=".",label="Albero standard")
    ax[(1,0)].plot(branch_fact,y6,marker=".",label="Albero Sobol")
    #GRAFICO CONFRONTO COSTI SETUP COI DUE ALBERI
    ax[(1,1)].set_title('Costi di set up')
    ax[(1,1)].plot(branch_fact,y3,marker=".",label="Albero standard")
    ax[(1,1)].plot(branch_fact,y7,marker=".",label="Albero Sobol")

    ax[(0,0)].set_ylabel('Costo')
    ax[(1,0)].set_ylabel('Costo')
    ax[(1,0)].set_xlabel('Branching factors')
    ax[(1,1)].set_xlabel('Branching factors')

    ax[(1,0)].legend()
    ax[(0,0)].legend(bbox_to_anchor=(0.5, 0.85))
    ax[(1,1)].legend()
    ax[(0,1)].legend()



            
plt.show()