from gurobipy import *
import pandas as pd
from matplotlib import pyplot as plt

#IMPORT DEL DATAFRAME DELLE SIMULAZIONI ROLLING HORIZON
#CON ALBERI DI SCENARI STANDARD O SOBOL

df=pd.read_csv('dataframes/DatiSimulazioniRH6.csv')


plt.style.use("ggplot")

#VETTORE DEI BRANCHING FACTORS
branching_factors=[[5,3,2],[6,5,2],[5,3,2,2],[9,5,2,1],[5,3,3,2,1]]

#FOR PER ESAMINARE SEPARATAMENTE I DUE DIVERSI TIPI DI ALBERI
#(STANDARD vs CON SEQUENZE A BASSA DISCREPANZA DI SOBOL)
for T_type in range(2):
    fig,ax=plt.subplots(nrows=5, ncols=1)
    #FOR PER ESAMINARE SEPARATAMENTE I DIVERSI FATTORI
    #DI RAMIFICAZIONE

    for i in range(5):

        branching_factor=branching_factors[i]
        str2=str="".join(["[",",".join([f"{ele}" for ele in branching_factor]),"]"])
        
        if T_type==0:
            str1='Standard'
        elif T_type==1:
            str1='Sobol'
            
        fig.suptitle('Solver: CLSP_F&R\n Tree: {}'.format(str1))
        
        #DATAFRAME RIDOTTO ALLE SIMULAZIONI CON IL TIPO DI ALBERO ED I
        #FATTORI DI RAMIFICAZIONE CORRISPONDENTI ALLE ITERAZIONI IN CORSO
        #DEI CICLI FOR
        df_1=df[(df["Tree_type"]==T_type)&(df["Branching_factors"]==str2)]

        x=[]
        y=[]

        #CICLO PER SCANDIRE GLI ISTANTI DI TEMPO    
        for j in range(50):

            #DATAFRAME RIDOTTO ALL'ISTANTE DI TEMPO 
            #(DELLA SIMULAZIONE ROLLING HORIZON) IN QUESTIONE    
            df_2=df_1[df_1['Time_period']==j]

            #ISTANTE DI TEMPO (DA 0 A 49)
            x.append(j)
            #MEDIA MOBILE (COSTO CUMULATIVO FINO ALL'ISTANTE IN QUESTIONE
            #DIVISO IL NUMERO DI ISTANTI PASSATI)
            y.append(df_2['CumCost'].mean()/(j+1))

        #PLOT SUI 5 GRAFICI DELLA FIGURA (I FATTORI DI SCALAMENTO +/-1
        #SONO SOLO PER ESSERE COERENTE CON L'ORDINE DEI FATTORI NEI 
        #GRAFICI DI CODICI PRECEDENTI)        
        ax[i].plot(x,y,marker=".")
        ax[i].set_ylim(2300,4000)
                
        ax[i].set_ylabel('"Media \n"Mobile" \nCosto')
        ax[i].set_title('Branching factor {}'.format(branching_factor))
        

        if i==4:
            ax[i].set_xlabel('Istante di tempo')
        




plt.show()                