import pandas as pd
import statsmodels.api as sm
from statsmodels.formula.api import ols

df=pd.read_csv('dataframes/DatiConfrontoFR6.csv')

#MULTI-WAY ANOVA PER IL GAP DEL SOLVER STANDARD

model=ols("MIPGap_BC ~ h_fact + g_fact + TBO + h_fact:g_fact + h_fact:TBO + g_fact:TBO + h_fact:g_fact:TBO",data=df).fit()

#STAMPA RISULTATI DELL'ANOVA
print(sm.stats.anova_lm(model, typ=2))
#STAMPA DEI RISULTATI DELLA CORRISPONDENTE REGRESSIONE LINEARE 
#(PER VEDERE I COEFFICIENTI)
print(model.summary())

#MULTI-WAY ANOVA PER IL TEMPO DEL SOLVER STANDARD
model2=ols("Time_BC ~ h_fact + g_fact + TBO + h_fact:g_fact + h_fact:TBO + g_fact:TBO + h_fact:g_fact:TBO",data=df).fit()

#STAMPA RISULTATI DELL'ANOVA
#print(sm.stats.anova_lm(model2, typ=2))

#STAMPA DEI RISULTATI DELLA CORRISPONDENTE REGRESSIONE LINEARE 
#(PER VEDERE I COEFFICIENTI)
#print(model2.summary())
