%inizializzo i dati, carico tutti i dati estratti nei precedenti codici
load("flussi_interpolati.mat")
load("Rfe_T_w_fitta.mat")
load("Perdite_efficiency_map.mat")
load("torque_efficiency_map.mat")
load("indici_dq_perdite_minime.mat")
id=-200:1:0;
iq=200:-1:0;
R_21=0.077;
Temperature=120;
R=R_21*(235+Temperature)/(235+21);
p=4;
omega=2*pi*(1000:1000:13000)/60*p;
speed=zeros(200,13);
meccaniche=zeros(1,13);
perdite_totali=zeros(200,13);


load("MTPS.mat")

x1=MTPS(5):-1:0;



T_analysed=[];
for i=1:200
    speed(i,:)=1000:1000:13000;
end
% for i=1:13
%     T_analysed(:,i)=200:-1:0;
% end

%creo una matrice di coppia analizzata in modo da avere 200 punti di coppia
%ad ogni velocità
T_analysed(:,1)=200:-1:1;
T_analysed(:,2)=200:-1:1;
T_analysed(:,3)=200:-1:1;
T_analysed(:,4)=linspace(MTPS(5),1,200);
T_analysed(:,5)=linspace(MTPS(6),1,200);
T_analysed(:,6)=linspace(MTPS(7),1,200);
T_analysed(:,7)=linspace(MTPS(8),1,200);
T_analysed(:,8)=linspace(MTPS(9),1,200);
T_analysed(:,9)=linspace(MTPS(10),1,200);
T_analysed(:,10)=linspace(MTPS(11),1,200);
T_analysed(:,11)=linspace(MTPS(12),1,200);
T_analysed(:,12)=linspace(MTPS(13),1,200);
T_analysed(:,13)=linspace(MTPS(14),1,200);








efficiency=zeros(201,13);


for s=1:13
    for t=1:201
        %modello circuitale
         Rs_eq=(R*rfe(t,s))/(R+rfe(t,s));
         q=index_q(t,s);
         d=index_d(t,s);
         T=3*p*((flusso_d_interp(q,d)*iq(q)-(flusso_q_interp(q,d)*id(d))))/2;
         is=sqrt(id(d)^2+iq(q)^2);
         Vd_eq=Rs_eq*id(d)-omega(s)*flusso_q_interp(q,d);
         Vq_eq=Rs_eq*iq(q)+omega(s)*flusso_d_interp(q,d);
         Vs_d=((Rs_eq+abs(rfe(t,s)))/abs(rfe(t,s)))*Vd_eq;
         Vs_q=((Rs_eq+abs(rfe(t,s)))/abs(rfe(t,s)))*Vq_eq;
         V=sqrt(Vs_d^2+Vs_q^2);
         Ife_d=-id(d)*Rs_eq/(Rs_eq+rfe(t,s))+Vd_eq/(Rs_eq+rfe(t,s));
         Ife_q=-iq(q)*Rs_eq/(Rs_eq+rfe(t,s))+Vq_eq/(Rs_eq+rfe(t,s));
         ife=sqrt(Ife_d^2+Ife_q^2);
         is_d=id(d)+Ife_d;
         is_q=iq(q)+Ife_q;
         %calcolo tutte le perdite presenti ell'analisi, due casi: uno con perdite per effettto pelle considerate in relazione al prodotto tra corrente e velocità al quadrato, uno non considerando l'effetto pelle 
         perdite_totali(t,s)=(3/2)*R*(is_d^2+is_q^2)+(3/2)*rfe(t,s)*ife^2+(1e-6*(omega(s)/p)^3+0.0006*(omega(s)/p)^2+0.43*(omega(s)/p));
%         perdite_totali(t,s)=0.0000005*(is_d^2+is_q^2)*(omega(s)/(p))^2+(3/2)*R*(is_d^2+is_q^2)+(3/2)*rfe(t,s)*ife^2+(1e-6*(omega(s)/p)^3+0.0006*(omega(s)/p)^2+0.43*(omega(s)/p));
         meccaniche(1,s)=(1e-6*(omega(s)/p)^3+0.0006*(omega(s)/p)^2+0.43*(omega(s)/p));
         
         efficiency(t,s)=(T*omega(s)/p)/((T*omega(s)/p)+perdite_totali(t,s));
        
    end
end




%creo una nuova matrice che contiene l'interpolazione dell'anadamento
%dell'efficienza per ogni velocità in modo da avere 200 punti di coppia per
%ogni valore di velocità
eta=zeros(200,13);
eta(:,1)=efficiency(1:end-1,1);
eta(:,2)=efficiency(1:end-1,2);
eta(:,3)=efficiency(1:end-1,3);
eta(:,4)=interp1(MTPS(5):-1:1,efficiency(201-MTPS(5):end-1,4),T_analysed(:,4),'spline');
eta(:,5)=interp1(MTPS(6):-1:1,efficiency(201-MTPS(6):end-1,5),T_analysed(:,5),'spline');
eta(:,6)=interp1(MTPS(7):-1:1,efficiency(201-MTPS(7):end-1,6),T_analysed(:,6),'spline');
eta(:,7)=interp1(MTPS(8):-1:1,efficiency(201-MTPS(8):end-1,7),T_analysed(:,7),'spline');
eta(:,8)=interp1(MTPS(9):-1:1,efficiency(201-MTPS(9):end-1,8),T_analysed(:,8),'spline');
eta(:,9)=interp1(MTPS(10):-1:1,efficiency(201-MTPS(10):end-1,9),T_analysed(:,9),'spline');
eta(:,10)=interp1(MTPS(11):-1:1,efficiency(201-MTPS(11):end-1,10),T_analysed(:,10),'spline');
eta(:,11)=interp1(MTPS(12):-1:1,efficiency(201-MTPS(12):end-1,11),T_analysed(:,11),'spline');
eta(:,12)=interp1(MTPS(13):-1:1,efficiency(201-MTPS(13):end-1,12),T_analysed(:,12),'spline');
eta(:,13)=interp1(MTPS(14):-1:1,efficiency(201-MTPS(14):end-1,13),T_analysed(:,13),'spline');





figure(1)
contourf(speed,T_analysed,eta,200,'ShowText','off')
% pcolor
caxis([0.75,0.94])
colormap default

% for i=4:13
%     figure(i)
%     plot(T_analysed(:,i),eta(:,i))
%     hold on
%     plot([200:-1:0],efficiency(:,i))
% end

figure(2)
plot(speed,meccaniche)