function [driving_time,energy_consumption]=...
    speed_curve(V_max,V_traffic,edge_length,T)

    if V_max * 0.9 < V_traffic
        V_traffic = V_max * 0.9;
    end

    %BMWi3_MY2017

    g = 9.8;
    veh_f0 = 0.0037;
    veh_f2 = 1.91e-7;
    veh_R = (20/2*25.4e-3+0.55*0.175)*0.98;
    veh_weight = 1320;
    veh_Cd = 0.30;
    veh_Sf = 2.38;
    veh_tau = 4;
    veh_etatransm = 0.99;
    T_interp_low = [178,100];
    T_low = [-7,24];
    T_interp_high = [100,126];
    T_high = [24,35];
    if T>=-7&&T<24
        T_eta = interp1(T_low,T_interp_low,T)/100;
    elseif T>=24&&T<=35
        T_eta = interp1(T_high,T_interp_high,T)/100;
    end
    max_acceleration = 2.5;


    driving_time=edge_length/V_traffic;
    simu_time = floor(driving_time);
    rest_time = driving_time - simu_time;
    simu_time = simu_time + 1;
    if rest_time==0
        rest_time=1;
        simu_time = simu_time - 1;
    end

    rng('default')
    speed = normrnd(V_traffic,(V_max-V_traffic)/V_max,[simu_time,1]);
    while 1
        speed(speed>V_max) = V_max;
        speed(speed<0) = 0;
        speed = speed+(V_traffic-mean(speed));
        acceleration = speed - [speed(1);speed(1:end-1)];
        acceleration(end) = acceleration(end)/rest_time;
        if isempty(find(acceleration>2.5, 1))
            break
        else
            acceleration(acceleration>2.5) = max_acceleration*0.9;
        end
        acceleration(end) = acceleration(end) * rest_time;
        speed = acceleration+[speed(1);speed(1:end-1)];
    end
    
    omega = speed/veh_R;
    F_rr = veh_weight*g*(veh_f0+veh_f2*omega.^2);
    F_aero = 1/2*veh_Sf*veh_Cd*1.225*speed.^2;
    F_acc = veh_weight*acceleration;
    F_acc(F_acc<0) = 0;
    F_tot = F_rr+F_aero+F_acc;
    T_w = F_tot*veh_R;
    T_mot = T_w/veh_tau/veh_etatransm;
    omega_mot = omega*veh_tau;
    P_mot = omega_mot.*T_mot;
    eta_mot = 0.8;

    P_batt = P_mot/eta_mot;
    P_batt = P_batt * T_eta;
    energy_consumption = sum(P_batt(1:end-1))+P_batt(end)*rest_time;
    energy_consumption = energy_consumption / 3600;

end