%with the traffic 
clear
clc

load("edge.mat")
node_name = unique([edge_struct.from;edge_struct.to],"stable");
encode_edge_struct = ones(size([edge_struct.from,edge_struct.to,edge_struct.length]));

edge_from_index = ones(length(unique(edge_struct.from)),1);
edge_time = edge_struct.length./edge_struct.speed;
rng('default');
edge_traf = normrnd(0.85,0.125,[1,length(edge_struct.speed)]);
edge_traf = edge_traf';
edge_traf(edge_traf>1)=1;
edge_traf(edge_traf<0.2)=0.2;
edge_time = edge_time ./ edge_traf;

for i = 1:length(edge_struct.id)
    encode_edge_struct(i,1)=find(node_name==edge_struct.from(i));
    encode_edge_struct(i,2)=find(node_name==edge_struct.to(i));
    encode_edge_struct(i,3)=edge_struct.length(i);
end

encode_edge_struct=sortrows(encode_edge_struct,1);

for i = 1:length(edge_from_index)
    x=find(encode_edge_struct(:,1)==i);
    edge_from_index(i)=x(1);
end

save('Node_Name','node_name')
save('encode_edge',"encode_edge_struct","edge_from_index");