clc
clear

edge_data_file = fopen("nordovest.net.xml.txt");
edge_count=0;

while ~feof(edge_data_file)
    tline = fgetl(edge_data_file);
    if contains(tline,"<edge")&&~contains(tline,"internal")
        edge_count=edge_count+1;
    end
end

frewind(edge_data_file)
edge_id = strings([edge_count,1]);
edge_from = strings([edge_count,1]);
edge_to = strings([edge_count,1]);
edge_speed = zeros(edge_count,1);
edge_length = zeros(edge_count,1);

edge_count=0;

while ~feof(edge_data_file)
    tline = fgetl(edge_data_file);
    if contains(tline,"<edge")&&~contains(tline,"internal")
        edge_count=edge_count+1;
        idstart = strfind(tline,'id=')+4;
        idend = strfind(tline,' from=')-2;
        edge_id(edge_count) = string(tline(idstart:idend));
        fromstart = strfind(tline,'from=')+6;
        fromend = strfind(tline,' to=')-2;
        edge_from(edge_count) = string(tline(fromstart:fromend));
        tostart = strfind(tline,'to=')+4;
        if contains(tline,' name=')
            toend = strfind(tline,' name=')-2;
        else
            toend = strfind(tline,' priority=')-2;
        end
        edge_to(edge_count) = string(tline(tostart:toend));
        tline = fgetl(edge_data_file); 
        speedstart = strfind(tline,'speed=')+7;
        speedend = strfind(tline,' length=')-2;
        edge_speed(edge_count) = str2double(tline(speedstart:speedend));
        
        lengthstart = strfind(tline,'length=')+8;
        if contains(tline,' acceleration=')
            lengthend = strfind(tline,' acceleration=')-2;
        elseif contains(tline,' width=')
            lengthend = strfind(tline,' width=')-2;
        elseif contains(tline,' customShape=')
            lengthend = strfind(tline,' customShape=')-2;
        else
            lengthend = strfind(tline,' shape=')-2;
        end
        edge_length(edge_count) = str2double(tline(lengthstart:lengthend));
    end
end

fclose(edge_data_file);


edge_struct = struct('id',edge_id,'from',edge_from,'to',edge_to,'speed',edge_speed,'length',edge_length);

save("edge.mat","edge_struct")