function [dist,prev] = dijkstra_gpt(adj, start)
% adj - adjacency matrix representation of the graph
% start - starting node
% dist - vector of shortest distances from the start node
% prev - vector of previous nodes in the shortest path

n = size(adj,1); % number of nodes
dist = inf(1,n); % initialize distances to inf
prev = zeros(1,n); % initialize previous node to 0
heap = start; % initialize heap with the starting node

while ~isempty(heap)
    node = heap(1); % extract node with smallest distance
    heap(1) = heap(end);
    heap = heap(1:end-1);
    heap = siftdown(heap, dist, 1);
    
    for neighbor = find(adj(node,:))
        alt = dist(node) + adj(node,neighbor);
        if alt < dist(neighbor)
            dist(neighbor) = alt;
            prev(neighbor) = node;
            heap = siftup(heap, dist, neighbor);
        end
    end
end

end

function heap = siftdown(heap, dist, i)
% siftdown helper function to maintain the heap property

minIndex = i;
left = 2*i;
right = 2*i + 1;

if left <= numel(heap) && dist(heap(left)) < dist(heap(minIndex))
    minIndex = left;
end

if right <= numel(heap) && dist(heap(right)) < dist(heap(minIndex))
    minIndex = right;
end

if minIndex ~= i
    temp = heap(i);
    heap(i) = heap(minIndex);
    heap(minIndex) = temp;
    heap = siftdown(heap, dist, minIndex);
end

end

function heap = siftup(heap, dist, i)
% siftup helper function to maintain the heap property

while i > 1
    parent = floor(i/2);
    if dist(heap(parent)) > dist(heap(i))
        temp = heap(i);
        heap(i) = heap(parent);
        heap(parent) = temp;
        i = parent;
    else
        break;
    end
end

end
