function charging_time=charge_battery(battery_energy)
    P_batt = -chPower*0.95;
    Voc = interp1(SoC_interp*bat_capacity, V_oc_interp, SoC(end)*Cbatt)*bat_series;
    Req = interp1(SoC_interp*bat_capacity, Req_interp, SoC(end)*Cbatt)*bat_series/bat_parallel;
    Ibatt = (Voc-sqrt(Voc^2-4*Req*P_batt))/(2*Req);
    SoC_next = SoC(end)-Ibatt/Cbatt/3600;
    SoC = [SoC; SoC_next];
    speed = [speed;0];
    acc = [acc;0];
    F_vect = [F_vect;0];
    pos = [pos; pos(end,:)];
end