clc
close all
clear
set(0,'defaultAxesFontName', 'Times New Roman',...
    'defaultTextFontName', 'Times New Roman',...
    'defaultAxesFontSize', 12,...
    'defaultTextFontSize', 12,...
    'defaultLineLineWidth',2,...
    'DefaultAxesXGrid','on',...
    'DefaultAxesYGrid','on',... 
    'DefaultTextInterpreter','Tex')

import traci.constants
load('path_ans.mat')
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
scenarioPath = 'D:\Traffic Route Planner\NordOvest_emptyStations.sumocfg';
system(['sumo-gui -c ' '"' scenarioPath '"' ' --remote-port 8873 --start&']);
traci.init(8873);
%traci.close
%return
route=cell(length(path)-1,1);
for i  =1:length(path)-1
    route{i} = char(path(i));
end
traci.route.add('EgoVehicle', route);
traci.vehicle.add('Egomet', 'EgoVehicle');
traci.vehicle.setMaxSpeed('Egomet', 45);
traci.vehicle.setAccel('Egomet', 5);
speed = [];
pos = [];
while traci.simulation.getMinExpectedNumber() > 0 || traci.simulation.getTime < 15
    traci.simulationStep();
    vehicles = traci.vehicle.getIDList;
    if ismember('Egomet', vehicles)
        speed = [speed; traci.vehicle.getSpeed('Egomet')];  %[m/s]
        pos = [pos; traci.vehicle.getPosition('Egomet')];
    end
end
traci.close()
%%%
figure
hold
axis equal
scatter(pos(:,1), pos(:,2), [], speed*3.6); colorbar
load CSFile2.mat
for i = 1:length(chargingStation)
    X(i) = chargingStation(i).X;
    Y(i) = chargingStation(i).Y;
end
scatter(X, Y, [], 'ro')
I = imread('mappa.png');
h = image([0,255519], [160000,0], I);
uistack(h, 'bottom');
set(gcf, 'Position', get(0, 'Screensize'));
saveas(gcf, 'trajectoryspeed_baseline.png')
saveas(gcf, 'trajectoryspeed_baseline.svg')
saveas(gcf, 'trajectoryspeed_baseline.fig')

