classdef LabelSet_5 < handle

    properties
        sets
        distances
        battery_SoC
        energy_consumption
        ratio   % wieght of distance and energy_consumption, default =[1,0];
        travel_time
        n
    end

    methods

        function x=LabelSet_5(ratio)
            x.sets=Labels_3.empty;
            x.distances=[];
            x.battery_SoC=[];
            x.energy_consumption=[];
            x.travel_time=[];
            x.n=0;
            if(~exist('ratio','var'))
                ratio=[1,0];
            end
            x.ratio = ratio;
            x.add_label(Labels_3(inf,0,0,inf))
        end

        function add_label(x,label)
            x.n=x.n+1;
            x.sets(x.n)=label;
            x.distances(x.n)=label.distance;
            x.battery_SoC(x.n)=label.battery_SoC;
            x.energy_consumption(x.n)=label.energy_consumption;
            x.travel_time(x.n)=label.travel_time;
        end

        function key=key_label(x)
            key=min(x.distances*x.ratio(1)+x.energy_consumption*x.ratio(2));
        end

        function y=min_label(x)
            [~,idx] = min(x.distances*x.ratio(1)+x.energy_consumption*x.ratio(2));
            idx=idx(1);
            y=x.sets(idx);
        end

        function y=settle_label(x)
            [~,idx] = min(x.distances*x.ratio(1)+x.energy_consumption*x.ratio(2));
            idx=idx(1);
            y=x.sets(idx);
            x.sets(idx)=[];
            x.distances(idx)=[];
            x.battery_SoC(idx)=[];
            x.energy_consumption(idx)=[];
            x.travel_time(idx)=[];
            x.n=x.n-1;
        end

        function check_label(x)
            while 1
                [~,idx_distances]=max(x.distances);
                [~,idx_ene]=max(x.energy_consumption);
                [~,idx_soc]=min(x.battery_SoC);
                if (idx_distances==idx_ene)&&(x.n~=1)&&(idx_ene==idx_soc)
                    x.sets(idx_distances)=[];
                    x.distances(idx_distances)=[];
                    x.battery_SoC(idx_distances)=[];
                    x.energy_consumption(idx_distances)=[];
                    x.travel_time(idx_distances)=[];
                    x.n=x.n-1;
                else
                    break
                end
            end
        end

        function t=has_unsettled_labels(x)
            if x.n==0
                t=false;
            else
                t=true;
            end
        end

    end
end