classdef LabelSet_2 < handle

    properties
        sets
        distances
        battery_SoC
        energy_consumption
        n
    end

    methods

        function x=LabelSet_2()
            x.sets=Labels_2.empty;
            x.distances=[];
            x.battery_SoC=[];
            x.energy_consumption=[];
            x.n=0;
            x.add_label(Labels_2(inf,0,0,inf))
        end

        function add_label(x,label)
            x.n=x.n+1;
            x.sets(x.n)=label;
            x.distances(x.n)=label.distance;
            x.battery_SoC(x.n)=label.battery_SoC;
            x.energy_consumption(x.n)=label.energy_consumption;
        end

        function key=key_label(x)
            key=min(x.distances);
        end

        function y=min_label(x)
            [~,idx] = min(x.distances);
            idx=idx(1);
            y=x.sets(idx);
        end

        function y=settle_label(x)
            [~,idx] = min(x.distances);
            idx=idx(1);
            y=x.sets(idx);
            x.sets(idx)=[];
            x.distances(idx)=[];
            x.battery_SoC(idx)=[];
            x.energy_consumption(idx)=[];
            x.n=x.n-1;
        end

        function check_label(x)
            while 1
                [~,idx_dis]=max(x.distances);
                [~,idx_ene]=max(x.energy_consumption);
                if (idx_dis==idx_ene)&&(x.n~=1)
                    x.sets(idx_dis)=[];
                    x.distances(idx_dis)=[];
                    x.battery_SoC(idx_dis)=[];
                    x.energy_consumption(idx_dis)=[];
                    x.n=x.n-1;
                else
                    break
                end
            end
        end

        function t=has_unsettled_labels(x)
            if x.n==0
                t=false;
            else
                t=true;
            end
        end

    end
end