classdef LabelSet < handle

    properties
        sets
        distances
        battery_SoC
        travel_time
        n
    end

    methods

        function x=LabelSet()
            x.sets=Labels.empty;
            x.distances=[];
            x.battery_SoC=[];
            x.travel_time=[];
            x.n=0;
            x.add_label(Labels(inf,0,0))
        end

        function add_label(x,label)
            x.n=x.n+1;
            x.sets(x.n)=label;
            x.distances(x.n)=label.distance;
            x.battery_SoC(x.n)=label.battery_SoC;
            x.travel_time(x.n)=label.travel_time;
        end

        function key=key_label(x)
            key=min(x.travel_time);
        end

        function y=min_label(x)
            [~,idx] = min(x.travel_time);
            idx=idx(1);
            y=x.sets(idx);
        end

        function y=settle_label(x)
            [~,idx] = min(x.travel_time);
            idx=idx(1);
            y=x.sets(idx);
            x.sets(idx)=[];
            x.distances(idx)=[];
            x.battery_SoC(idx)=[];
            x.travel_time(idx)=[];
            x.n=x.n-1;
        end

        function check_label(x)
            while 1
                [~,idx_dis]=max(x.distances);
                [~,idx_ene]=min(x.battery_SoC);
                if (idx_dis==idx_ene)&&(x.n~=1)
                    x.sets(idx_dis)=[];
                    x.distances(idx_dis)=[];
                    x.battery_SoC(idx_dis)=[];
                    x.travel_time(idx_dis)=[];
                    x.n=x.n-1;
                else
                    break
                end
            end
        end

        function t=has_unsettled_labels(x)
            if x.n==0
                t=false;
            else
                t=true;
            end
        end
    end
end