classdef FibonacciHeapNode < handle
    properties
        p       %   pointer to parent
        child   %   pointer to children
        left    %   pointer to left siblings
        right   %   pointer to right sliblings
        degree  %   number of children
        mark    %   indicates whether node x has lost a child since the 
                %   last time x was made the child of another node
        key     %   key of node
        value   %   value of the key
        nil
    end

    methods
        %Create Node
        function x=FibonacciHeapNode(key,value)
            if(~exist('key','var'))
                key=0;
            end
            if(~exist('value','var'))
                value=0;
            end
            x.key=key;
            x.value=value;
            x.left=x;
            x.right=x;
            x.mark=false;
            x.degree=0;
            x.p=[];
            x.child=[];
            x.nil=false;
        end
    end
end