classdef FibonacciHeap < handle

    properties
        min     %pointer to minimum node
        n       %the number of nodes currently in heap
    end

    methods

        %Create the fibonacci heap
        function H = FibonacciHeap()
            H.n = 0;
            H.min = [];
        end

        %Insert new node into heap
        function ninsert(H,x)
            x.right=x;
            x.left=x;
            if H.n == 0
                H.min = x;
            else
                % insert x to the root
                x.left = H.min.left;
                x.right = H.min;
                H.min.left.right = x;
                H.min.left = x;
                if x.key < H.min.key
                    H.min = x;
                end
            end
            H.n = H.n + 1;
        end

        %Make a New node and insert into heap
        function insert(H,key,value)
            if(~exist('value','var'))
                value=0;
            end
            x=FibonacciHeapNode(key,value);
            if H.n == 0
                H.min = x;
            else
                % insert x to the root
                x.left = H.min.left;
                x.right = H.min;
                H.min.left.right = x;
                H.min.left = x;
                if x.key < H.min.key
                    H.min = x;
                end
            end
            H.n = H.n + 1;
        end

        function ele = minimum(H)
            ele=H.min;
        end

        function H = union(H1,H2)
            H = FibonacciHeap();
            H.min = H1.min;
            H.min.left.right = H2.min.right;
            H2.min.right.left = H.min.left;
            H.min.left = H2.min;
            H2.min.right = H.min;
            if isempty(H1.min) || ((~isempty(H2.min))&&H2.min.key<H1.min.key)
                H.min=H2.min;
            end
            H.n = H1.n + H2.n;
        end

        function z = delMin(H)
            z = H.min;
            while ~isempty(z.child)
                x = z.child;
                x.right.left = x.left;
                x.left.right = x.right;
                if x.left ~= x
                    x.p.child = x.left;
                else
                    x.p.child = [];
                end
                x.left = H.min.left;
                x.right = H.min;
                H.min.left.right = x;
                H.min.left = x;
                x.p = [];
            end
            z.right.left = z.left;
            z.left.right = z.right;
            if z == z.right
                H.min = [];
            else
                H.min = z.right;
                H.consolidate();
            end
            H.n = H.n - 1;
        end

        function consolidate(H)
            A=H.D();
            for i=1:length(A)
                A(i).nil = true;
            end
            rawNode=H.min;
            nowNode=rawNode;
            counter = 0;
            while true
                counter=counter+1;
                nowNode=nowNode.right;
                if nowNode==rawNode
                    break
                end
            end
            for i=1:counter
                x=nowNode;
                nowNode=nowNode.right;
                d=x.degree+1; %d should be the degree, but in matlab,
                              %index starts with 1, so d is degree+1 now
                while A(d).nil~=true
                    y=A(d);
                    if x.key>y.key
                        a=x;
                        x=y;
                        y=a;
                    end                
                    H.Hlink(y,x)
                    A(d)=FibonacciHeapNode;
                    A(d).nil=true;
                    d=d+1;
                end
                A(d)=x;                
            end
            H.min=FibonacciHeapNode;
            H.min.nil=true;
            for i=1:length(A)
                if A(i).nil~=true
                    if H.min.nil==true
                        A(i).right=A(i);
                        A(i).left=A(i);
                        H.min = A(i);
                    else
                        %insert A(i) into H's root list
                        A(i).left=H.min.left;
                        A(i).right=H.min;
                        H.min.left.right=A(i);
                        H.min.left=A(i);
                        if A(i).key<H.min.key
                            H.min=A(i);
                        end
                    end
                end
            end
        end

        function a = D(H)
            a=log(H.n)/log((1+5^0.5)/2);
            a=floor(a);
            obj.Array(1,a+1)=FibonacciHeapNode;
            a=obj.Array;
        end

        function Hlink(H,y,x)
            % remove y from the root list of H
            y.right.left=y.left;
            y.left.right=y.right;
            % make y a child of x, incrementing x.degree
            y.p=x;
            if isempty(x.child)
                x.child = y;
                y.left=y;
                y.right=y;
            else
                x.child.left.right = y;
                y.left = x.child.left;
                x.child.left=y;
                y.right=x.child;
            end
            x.degree = x.degree+1;
            % y.mark = false
            y.mark = false;
        end

        function key_decreasing(H,x,k)
            if k>x.key
                print('error, new key is greater than current key')
                return
            end
            x.key=k;
            y=x.p;
            if ~isempty(y) && x.key<y.key
                H.cut(x,y)
                H.cascading_cut(y)
            end
            if x.key<H.min.key
                H.min=x;
            end
        end

        function cut(H,x,y)
            %remove x from the child list of y, decrementing y.degree
            if y.child==x
                if x.right==x
                    y.child=[];
                else
                    y.child=x.right;
                    x.right.left=x.left;
                    x.left.right=x.right;
                end
            else
                x.right.left=x.left;
                x.left.right=x.right;
            end
            %add x to the root list of H
            H.min.left.right=x;
            x.left=H.min.left;
            H.min.left=x;
            x.right=H.min;
            %x.p=NIL
            x.p=[];
            %x.mark=false
            x.mark=false;
        end

        function cascading_cut(H,y)
            z=y.p;
            if ~isempty(z)
                if y.mark == false
                    y.mark = true;
                else
                    H.cut(y,z)
                    H.cascading_cut(z)
                end
            end
        end

        function del_node(H,x)
            H.key_decreasing(x,-inf);
            H.delMin();
        end

    end %end of the methods

end %end of the classdef