function label_set_settled=Dijkstra_sp_004_disdomain(Nodes,Charge,B_range,B_source, ...
    edges,Graph_index,source,target)
    %***********************************************************
    %****Calculate the shortest path with battery constrains****
    %***********************************************************


    %%
    %***********************************************************
    %**First step:
    %****Trans the source and target vertex from str to num*****
    %***********************************************************
    [source,target]=Node_traslate(source,target);

    %%
    %***********************************************************
    %**Second step:
    %************Initail labelset for every vertex**************
    %***********************************************************
    label_set.array(1,length(Nodes))=LabelSet_2;
    label_set_settled.array(1,length(Nodes))=LabelSet_2;
    label_set=label_set.array;
    label_set_settled=label_set_settled.array;

    %%
    %***********************************************************
    %**Third step:
    %*******Set the labelset of source vertex to (0,0,0)*******
    %**Which means from source vertex to source vertex:
    %**Have 0 meter distance, 0 Kw/h energy consumption*********
    %**And the previce vertex to source is nothing**************
    %***********************************************************
    label_set(source).add_label(Labels_2(0,B_source,0,0));
    label_set(source).check_label();

    %%
    %***********************************************************
    %**Fourth step:
    %*****Initail the Fibonacci Heap Node for every vertex******
    %***********************************************************
    Fnodes.Array(length(Nodes),1) = FibonacciHeapNode;
    Fnodes = Fnodes.Array;
    for i=1:length(Nodes)
        Fnodes(i).key = inf;
        Fnodes(i).value = i;
    end
    
    %%
    %***********************************************************
    %**Fifth step:
    %*****And the value from source vertex label set to 
    % Fibonacci Heap********************************************
    %***********************************************************
    Q=FibonacciHeap;
    Fnodes(source).key=label_set(source).key_label();
    Q.ninsert(Fnodes(source));

    %%
    %***********************************************************
    %**Sixth step:
    %************************Main Loop**************************
    %***********************************************************
    while ~isempty(Q.min)
        %%
        %*******************************************************
        %**Seventh step:
        %***From Fibonacci Heap get the present search vertex***
        %*******************************************************
        u=Q.delMin();
        while u.value>length(Graph_index)
            u=Q.delMin();
        end

        %%
        %*******************************************************
        %**Extra step
        %************************Charge*************************
        %*******************************************************
        if find(Charge==u.value)
            for i=1:length(label_set(u.value))
                label_set(u.value).battery_SoC(i)=B_range(2);
                label_set(u.value).sets(i).battery_SoC=B_range(2);
            end
        end

        %%
        %*******************************************************
        %**Eighth step:
        %**When present search vertex equal to target vertex, 
        % stop**************************************************
        %*******************************************************
%         if u==Fnodes(target)
%             the_label = label_set(u.value).settle_label();
%             label_set_settled(u.value).add_label(the_label);
%             label_set_settled(u.value).check_label();
%             break
%         end

        %%
        %*******************************************************
        %**Nineth step:
        %***************Settle the current label****************
        %*******************************************************
        the_label = label_set(u.value).settle_label();
        label_set_settled(u.value).add_label(the_label);
        label_set_settled(u.value).check_label();
        if label_set(u.value).has_unsettled_labels()
            Fnodes(u.value)=FibonacciHeapNode();
            Fnodes(u.value).value=u.value;
            Fnodes(u.value).key=label_set(u.value).key_label();
            Q.ninsert(Fnodes(u.value));
        end

        %%
        %*******************************************************
        %**Tenth step:
        %********Check all edges connected to vertex u**********
        %*******************************************************
        
        i_s = Graph_index(u.value);
        if u.value==length(Graph_index)
            i_e = i_s;
        else
            i_e = Graph_index(u.value+1)-1;
        end
        for i=i_s:i_e
            alt = the_label.distance + edges(i,3);
            junc_to = edges(i,2);
            battery_SoC = the_label.battery_SoC-edges(i,4);
            energy_consumption = the_label.energy_consumption+edges(i,4);
            if battery_SoC>B_range(1)&&label_set(junc_to).has_unsettled_labels()
                new_label = Labels_2(alt,battery_SoC,u.value,energy_consumption);
                mini_label = label_set(junc_to).min_label;
                if ~mini_label.label_le(new_label)
                    label_set(junc_to).add_label(new_label);
                    label_set(junc_to).check_label();
                    if Fnodes(junc_to).key==inf
                        Fnodes(junc_to).key=alt;
                        Q.ninsert(Fnodes(junc_to));
                    elseif Fnodes(junc_to).key>alt
                        Q.key_decreasing(Fnodes(junc_to),alt);
                    end

                end
            end
        end
    end