function [dist,prev,S]=Dijkstra_sp_002(Nodes,edges,Graph_index,source,target)
    [source,target]=Node_traslate(source,target);
    obj.Array(length(Nodes),1) = FibonacciHeapNode;
    Fnodes = obj.Array;
    for i=1:length(Nodes)
        Fnodes(i).key = inf;
        Fnodes(i).value = i;
    end
    dist = ones(length(Nodes),1)*inf;
    prev = zeros(length(Nodes),1);
    dist(source)=0;
    Fnodes(source).key=0;
    Q=FibonacciHeap;
    Q.ninsert(Fnodes(source));

    while ~isempty(Q.min)
        u=Q.delMin();
        if u==Fnodes(target)
            S=[];
            while u~=Fnodes(source)
                S(end+1)=u.value;
                u=Fnodes(prev(u.value));
            end
            S(end+1)=u.value;
            S=fliplr(S);
            S=decode000(S);
            break
        end
        while u.value>length(Graph_index)
            u=Q.delMin();
        end

        i_s = Graph_index(u.value);
        if u.value==length(Graph_index)
            i_e = i_s;
        else
            i_e = Graph_index(u.value+1)-1;
        end
        for i=i_s:i_e
            alt = u.key + edges(i,3);
            junc_to = edges(i,2);
            if alt < dist(junc_to)
                dist(junc_to)=alt;
                prev(junc_to)=u.value;
                if Fnodes(junc_to).key==inf
                    Fnodes(junc_to).key=alt;
                    Q.ninsert(Fnodes(junc_to));
                else
                    Q.key_decreasing(Fnodes(junc_to),alt);
                end
            end
        end
    end

end