import UIKit
import NearbyInteraction

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {
    
    var window: UIWindow?
    
    //Permission for Notification
    private func requestNotificationAuthorization(application: UIApplication){
        
        let center = UNUserNotificationCenter.current()
        let options: UNAuthorizationOptions = [.alert, .badge, .sound]
        
        center.requestAuthorization(options: options) {
            granted, error in
            if let error = error {
                print(error.localizedDescription)
            }
        }
    }
    
    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        requestNotificationAuthorization(application: application)
        // Ensure that the device supports NearbyInteraction and present
        // an error message view controller, if not.
        
       print("State is: \(UIApplication.shared.applicationState)")
        
        if #available(iOS 16.0, *) {
            let capabilities = NISession.deviceCapabilities
            if !capabilities.supportsPreciseDistanceMeasurement || !capabilities.supportsDirectionMeasurement {
                print("Unsupported iPhone device")
                let storyboard = UIStoryboard(name: "Main", bundle: nil)
                window?.rootViewController = storyboard.instantiateViewController(withIdentifier: "unsupportedDeviceMessage")
            }
            
            return true
        } else {
            if !NISession.isSupported {
                print("Unsupported iPhone device")
                let storyboard = UIStoryboard(name: "Main", bundle: nil)
                window?.rootViewController = storyboard.instantiateViewController(withIdentifier: "unsupportedDeviceMessage")
            }
            
            return true
        }
    }
}
