
% Air properties (ISA)

thermophyscialpropertiesair2 = readtable('../../Desktop/Laurea Magistrale/Thesis/Matlab_model/Technical & Architectures/Thermophysicalproperties_air.txt');  %should figure out the format of your file on its own. If not, attach an actual file
thermophyscialpropertiesair2.Properties.VariableNames = {'Temperature', 'Density','Specificheat','Viscosity','Kinematicviscosity','Thermalconductivity','Thermaldiffusivity','Pr'};  %optional: give a good name to the columns, readtable may already have named the columns appropriately
T_air=thermophyscialpropertiesair2.Temperature;
rho_air=thermophyscialpropertiesair2.Density;
cp_air=thermophyscialpropertiesair2.Specificheat;
Mi_air=thermophyscialpropertiesair2.Viscosity;
Pr_air=thermophyscialpropertiesair2.Pr;


thermophyscialpropertiesethywater = readtable('../../Desktop/Laurea Magistrale/Thesis/Matlab_model/Technical & Architectures/EGW60_40properties.xlsx');  %should figure out the format of your file on its own. If not, attach an actual file
thermophyscialpropertiesethywater.Properties.VariableNames = {'Temperature', 'Density','Specificheat','Viscosity','Thermalconductivity'};  %optional: give a good name to the columns, readtable may already have named the columns appropriately
T_ethywat=thermophyscialpropertiesethywater.Temperature;
rho_ethywat=thermophyscialpropertiesethywater.Density;
cp_ethywat=thermophyscialpropertiesethywater.Specificheat;
Mi_ethywat=thermophyscialpropertiesethywater.Viscosity;
k_ethywat=thermophyscialpropertiesethywater.Thermalconductivity;


%System Inputs 

npoints=60;
% T_InEquip=305;
% Q_equip=100; %Heat load [kw]
mdot_liquid=0.045*100; %Liquid mass flow [kg/s]
bypass=0; %By-pass ratio

% %User input
% prompt = input(['Enter 1 for reference case or ' ...
%     '2 for varying the heat load:']); % ask
% 
% choise = prompt;
%     if choise==1
%         Q_equip=100;
%     elseif choise==2
%         Q_equip=[100 150 200 250];  
%     end


%Flight Conditions

R=287; %Universal gas constant (J/kgK)
Mach=[0.2774 0.2798 0.2823 0.3046 0.3074 0.3102 0.3345 0.3376 0.3408 0.3671 0.3707 0.3744 0.3913 0.3936 0.396 0.4613 0.4613 0.4613 0.4119 0.4053 0.3991 0.3512 0.3492 0.3472 0.3156 0.3088 0.3024]; %Flight Mach variation
Mach3=[0.2752116 0.2751966 0.2752167 0.2969572 0.2970076 0.2969846 0.3202493 0.3202204 0.3202018 0.3449122 0.3449408 0.3449632 0.3605345 0.3604798 0.3604775 0.4199199 0.4199199 0.4199199 0.3749512 0.3749202 0.3749781 0.3299732 0.3299743 0.3299433 0.2999139 0.2999774 0.3000144];
flight_altitute_points=27;
t_flight=5400;
n=t_flight/(flight_altitute_points-1);
Time=0:n:5400;
decol=120:60:900;
cruise=(900+1000/3):(1000/3):1900;
land=(1900+1700/9):(1700/9):3601;
Time2=[0 decol cruise land];
gamma=1.4;


H=[0 762 1524 1524 2286 3048 3048 3810 4572 4572 5334 6096 6096 6553 7010 7010 7010 7010 7010 5791 4572 4572 4115 3658 3658 1829 0]; %Flight height variation (m)
H2=[0 762 1524 1525 2286 3048 3049 3810 4572 4573 5334 6096 6097 6553 7010 7010 7010 7010 7010 5791 4572 4571 4115 3658 3657 1829 0]; %Flight height variation (m)
[T_env, a_env, p_env, rho_env] = atmosisa(H); %Standard Atmosphere
fp=length(H); %Number of flight points considerer

%Geometric parameters

L_duct_liquid=20; %Liquid Duct Length [m]
t_duct_liquid = 0.0025; %Duct thickness [m]



%Pressure losses 

DELTAP_RHX=5;
DELTAP_equip = 5; %Pressure loss of heat load [kPa]
N_90dgBend = 4; %Pressure loss on bends
K_90dgBend = 0.83;
N_expansion = 0;
K_expansion = 0.3;
N_contraction = 0;
K_contraction = 0.03;
N_branch_converg = 0; 
K_branch_converg = 0.05;
N_branch_diverg = 0;
K_branch_diverg = 0.05;


%Efficiencies	
eta_pump = 0.5;	%Pump efficiency
eta_fan = 0.4;	%Fan efficiency

