
%Table data inputs
% Air properties (ISA)

thermophyscialpropertiesair2 = readtable('../../Desktop/Laurea Magistrale/Thesis/Matlab_model/Technical & Architectures/Thermophysicalproperties_air.txt');  %should figure out the format of your file on its own. If not, attach an actual file
thermophyscialpropertiesair2.Properties.VariableNames = {'Temperature', 'Density','Specificheat','Viscosity','Kinematicviscosity','Thermalconductivity','Thermaldiffusivity','Pr'};  %optional: give a good name to the columns, readtable may already have named the columns appropriately
T_air=thermophyscialpropertiesair2.Temperature;
rho_air=thermophyscialpropertiesair2.Density;
cp_air=thermophyscialpropertiesair2.Specificheat;
Mi_air=thermophyscialpropertiesair2.Viscosity;
Pr_air=thermophyscialpropertiesair2.Pr;



% Thermal liquid properties (ehylene-glycol)

thermophyscialpropertiesethywater = readtable('../../Desktop/Laurea Magistrale/Thesis/Matlab_model/Technical & Architectures/EGW60_40properties.xlsx');  %should figure out the format of your file on its own. If not, attach an actual file
thermophyscialpropertiesethywater.Properties.VariableNames = {'Temperature', 'Density','Specificheat','Viscosity','Thermalconductivity'};  %optional: give a good name to the columns, readtable may already have named the columns appropriately
T_ethywat=thermophyscialpropertiesethywater.Temperature;
rho_ethywat=thermophyscialpropertiesethywater.Density;
cp_ethywat=thermophyscialpropertiesethywater.Specificheat;
Mi_ethywat=thermophyscialpropertiesethywater.Viscosity;
k_ethywat=thermophyscialpropertiesethywater.Thermalconductivity;


%Satured R314 properties 
thermopropertiesR314a = readtable('../../Desktop/Laurea Magistrale/Thesis/Matlab_model/Technical & Architectures/R314_Temperaturetable.xlsx');  %should figure out the format of your file on its own. If not, attach an actual file
thermopropertiesR314a.Properties.VariableNames = {'Temperature', 'Pressure','Specificvolumef','Specificvolumeg','InternalEnergyf','InternalEnergyg','Enthalpyf','Enthalpygf','Enthalpyg','Entropyf','Entropyg','Temp2'};  %optional: give a good name to the columns, readtable may already have named the columns appropriately
T_R314a=thermopropertiesR314a.Temperature;
p_R314a=thermopropertiesR314a.Pressure;
vf_R314a=thermopropertiesR314a.Specificvolumef;
vg_R314a=thermopropertiesR314a.Specificvolumeg;
uf_R314a=thermopropertiesR314a.InternalEnergyf;
ug_R314a=thermopropertiesR314a.InternalEnergyg;
hf_R314a=thermopropertiesR314a.Enthalpyf;
hgf_R314a=thermopropertiesR314a.Enthalpygf;
hg_R314a=thermopropertiesR314a.Enthalpyg;
sf_R314a=thermopropertiesR314a.Entropyf;
sg_R314a=thermopropertiesR314a.Entropyg;



%Superheated R314 properties p=12bar

thermopropertiesR314ah_12 = readtable('../../Desktop/Laurea Magistrale/Thesis/Matlab_model/Technical & Architectures/SuperheateadR314a_12.xlsx');  %should figure out the format of your file on its own. If not, attach an actual file
thermopropertiesR314ah_12.Properties.VariableNames = {'Temperature', 'Specificvolume','InternalEnergy','Enthalpy','Entropy'};  %optional: give a good name to the columns, readtable may already have named the columns appropriately
T_R314ah_12=thermopropertiesR314ah_12.Temperature;
v_R314ah_12=thermopropertiesR314ah_12.Specificvolume;
u_R314ah_12=thermopropertiesR314ah_12.InternalEnergy;
h_R314ah_12=thermopropertiesR314ah_12.Enthalpy;
s_R314ah_12=thermopropertiesR314ah_12.Entropy;



%Superheated R314 properties p=14bar

thermopropertiesR314ah_14 = readtable('../../Desktop/Laurea Magistrale/Thesis/Matlab_model/Technical & Architectures/SuperheatedR314a_14.xlsx');  %should figure out the format of your file on its own. If not, attach an actual file
thermopropertiesR314ah_14.Properties.VariableNames = {'Temperature', 'Specificvolume','InternalEnergy','Enthalpy','Entropy'};  %optional: give a good name to the columns, readtable may already have named the columns appropriately
T_R314ah_14=thermopropertiesR314ah_14.Temperature;
v_R314ah_14=thermopropertiesR314ah_14.Specificvolume;
u_R314ah_14=thermopropertiesR314ah_14.InternalEnergy;
h_R314ah_14=thermopropertiesR314ah_14.Enthalpy;
s_R314ah_14=thermopropertiesR314ah_14.Entropy;

%Superheated R314 properties p=3.2bar

thermopropertiesR314ah3_2 = readtable('../../Desktop/Laurea Magistrale/Thesis/Matlab_model/Technical & Architectures/SuperheateadR314a_3_2.xlsx');  %should figure out the format of your file on its own. If not, attach an actual file
thermopropertiesR314ah3_2.Properties.VariableNames = {'Temperature', 'Specificvolume','InternalEnergy','Enthalpy','Entropy'};  %optional: give a good name to the columns, readtable may already have named the columns appropriately
T_R314ah3_2=thermopropertiesR314ah3_2.Temperature;
v_R314ah3_2=thermopropertiesR314ah3_2.Specificvolume;
u_R314ah3_2=thermopropertiesR314ah3_2.InternalEnergy;
h_R314ah3_2=thermopropertiesR314ah3_2.Enthalpy;
s_R314ah3_2=thermopropertiesR314ah3_2.Entropy;


%Superheated R314 properties p=4bar

thermopropertiesR314ah_4 = readtable('../../Desktop/Laurea Magistrale/Thesis/Matlab_model/Technical & Architectures/SuperheateadR314a_4.xlsx');  %should figure out the format of your file on its own. If not, attach an actual file
thermopropertiesR314ah_4.Properties.VariableNames = {'Temperature', 'Specificvolume','InternalEnergy','Enthalpy','Entropy'};  %optional: give a good name to the columns, readtable may already have named the columns appropriately
T_R314ah_4=thermopropertiesR314ah_4.Temperature;
v_R314ah_4=thermopropertiesR314ah_4.Specificvolume;
u_R314ah_4=thermopropertiesR314ah_4.InternalEnergy;
h_R314ah_4=thermopropertiesR314ah_4.Enthalpy;
s_R314ah_4=thermopropertiesR314ah_4.Entropy;



%Input

npoints=60;
% T_InEquip=393; %T_equp required [K]
% Q_equip=100; %Heat load [kw]
mdot_liquid=0.045*100; %Liquid mass flow [kg/s]
mdot_ref=0.9; %Refrigerant mass flow [kg/s]
bypass=0; %By-pass ratio
T_evap=278; %Evaporation Temperature (K)
T_cond=325.3; %Condensation Temperature (K)

% %User Input
% 
% prompt = input(['Enter 1 for reference case or ' ...
%     '2 for varying the heat load:']); % ask
% 
% choise = prompt;
%     if choise==1
%         Q_equip=100;
%     elseif choise==2
%         Q_equip=[100 150 200 250];  
%     end


%Flight Conditions


decol=120:60:900;
cruise=(900+1000/3):(1000/3):1900;
land=(1900+1700/9):(1700/9):3601;
Time2=[0 decol cruise land];
R=287; %Universal gas constant (J/kgK)
Mach=[0.2774 0.2798 0.2823 0.3046 0.3074 0.3102 0.3345 0.3376 0.3408 0.3671 0.3707 0.3744 0.3913 0.3936 0.396 0.4613 0.4613 0.4613 0.4119 0.4053 0.3991 0.3512 0.3492 0.3472 0.3156 0.3088 0.3024]; %Flight Mach variation
gamma=1.4;
H=[0 762 1524 1524 2286 3048 3048 3810 4572 4572 5334 6096 6096 6553 7010 7010 7010 7010 7010 5791 4572 4572 4115 3658 3658 1829 0]; %Flight height variation (m)

%Geometric parameters

X = 20; %Distance along the fuselage from nose to SHX [m]
L_duct_liquid=20; %Liquid Duct Length [m]
t_duct_liquid = 0.0025; %Duct thickness [m]
L_duct_vcs = 10; %Duct length [m]
duct_roughness = 0.0025*0.001; %Duct roughness
D_vcs = 0.0254; %VCS duct diameter [m]
t_duct_vcs = 0.00117; %VCS duct thickness [m]
h = 0.01; %Thermal boundary layer thickness [m]
SHX_A=5; % SHX Area [m^2]
A_cond = 2; %Condenser area [m^2]
U_cond = 50; %Condenser heat transfer coeffient [W/m^2K]


%Pressure losses 

DELTAP_evaporator = 5; %Pressure loss of evaporator [kPa]
DELTAP_condenser = 1.013; %Pressure loss of condenser [kPa]
DELTAP_shx = 5; %%Pressure loss of SHX [kPa]
DELTAP_equip = 5; %Pressure loss of heat load [kPa]
N_90dgBend = 4; %Pressure loss on bends
K_90dgBend = 0.83;
N_expansion = 0;
K_expansion = 0.3;
N_contraction = 0;
K_contraction = 0.03;
N_branch_converg = 0; 
K_branch_converg = 0.05;
N_branch_diverg = 0;
K_branch_diverg = 0.05;


%VCS Cycle Parameters	
DELTAT_subcool = 5; %[K]
DELTAT_superheat = 5; %[K]	
 	
%Efficiencies	
eta_isentropic_compression = 0.8;%Value based on results of BE3888 Issue 2 of Secan
eta_compressor = 0.8;	%Compression efficiency
eta_pump = 0.5;	%Pump efficiency
eta_fan = 0.4;	%Fan efficiency
compress_ratio = 4;	%Compressor ratio;




