import { h } from 'preact';
import { useState, useEffect } from 'preact/hooks';
import { idSelected } from '../../shared';
import { useStore } from '@nanostores/preact';
import SuggestedItem from './SuggestedItem';
import react from 'react';

export default function RecommendendProducts(props) {
  const {products} = props;
  const $idSelected = useStore(idSelected);

  const [category, setCategory] = useState('');

  useEffect (() => {
    setCategory(products?.find(prod=> prod.id== $idSelected)?.category);
  }, [$idSelected])


  useEffect(() => {
  }, [])

  return (
    <div> 
      <div class='hint'>
       Products of the same category
      </div>
      {
        products?.
        filter((prod)=> prod?.category ==category && prod?.id != $idSelected)?.
        map((el) => <SuggestedItem product={el}/>)
      }
    </div>
  );
}



