import { h } from 'preact';
import { idSelected, productSelected } from '../../shared';
import { useStore } from '@nanostores/preact';

export default function ProductCard({product}) {
  const $idSelected = useStore(idSelected);
  const $productSelected = useStore(productSelected);

  return (
    <div class='product-card-hp'> 
    <div class='image-container'>
    <img src={`${product?.image}`}></img>
    </div>
    <div class='info-container'>
        <span class='title'>{product?.title}</span>
        <span class='price'>{product?.price} $</span>
        <a class='cta-container' href='/about'>
        <button onClick={()=> {idSelected.set(product?.id)}} class='cta'>DETAILS</button>
        </a>
    </div>
    </div>
  );
}