import React from 'react';
import styles from './styles.scss';
import { useStore } from '@nanostores/react';
import { cartItems } from '../../shared';
import { idSelected } from '../../shared';
import { useEffect, useState } from 'react';

export const Cart = (props) => {
    const [showCart, setShowCart] = useState(false);
    const $cartItems = useStore(cartItems);

    const renderPopup = () => {
        return(
            <div class='popup'>
                <div class='content'>
                    <div class='title'>Your cart</div>
                    <div>
                    {
                        Object.values($cartItems).length/**.get()*/ ? (
                            <ul>
                                {
                                    Object.values($cartItems).map(
                                        cartItem => 
                                        <li class='item'>
                                            {cartItem?.title} x{cartItem.quantity}
                                        </li>
                                    )
                                }
                            </ul>
                        ) : <p class='disclaimer'>Your cart is empty!</p>
                    }
                    </div>     
                </div>
            </div>
        )
    }

    return(
        <div class='cart-icon'>
            <button onClick={()=> setShowCart(prev => !prev)}>
                <img src='../../../cart.svg'/>
            </button>
            {showCart ? renderPopup() : <></>}
        </div>
    );
}