import React from 'react';
import styles from './styles.scss';
import { useStore } from '@nanostores/react';
import { cartItems } from '../../shared';
import { idSelected } from '../../shared';
import { useEffect, useState } from 'react';

export const AddToCart = (props) => {
    const {products} = props;
    const [selectedProduct, setSelectedProduct] = useState({});
    const $idSelected = useStore(idSelected);

    useEffect(() => {
        console.log('cart', cartItems.get());
        setSelectedProduct(products?.find((prod) => prod?.id == $idSelected));
    });

    function addCartItem({ id, title, price, description, category, image, rating}) {
        const existingEntry = cartItems.get()[id];
        if (existingEntry) {
          cartItems.setKey(id, {
            ...existingEntry,
            quantity: existingEntry.quantity + 1,
          })
        } else {
          cartItems.setKey(
            id,
            { id, title, price, description, category, image, rating, quantity: 1 }
          );
        }
      }

    function addToCart(){
        addCartItem(selectedProduct);
        console.log(cartItems.get());
    }

    return(
        <div class='add-to-cart'>
            <button class='add' onClick={() => addToCart()}>
                Add to your cart
            </button>
        </div>
    );
}