clear all
clc


%% TAIL PARAMETERS

%LED values
Led_tail_current = [10, 30];        %mA
Led_tail_voltage = [1.89, 2];       %V
Led_tail_Rs = 5;                  %ohm

%%calcolo parametri Buck Tail light
Vin=12;  %V          tensione in ingresso
Vout_tail=9; %V          tensione in uscita
d_tail=Vout_tail/Vin;          %duty cycle 
Iout_tail=0.240;  %A       corrente che voglio in uscita
Iin_tail=d_tail*Iout_tail; %A       corrente in ingresso
Vripple=0.2; %V      voltage ripple
f=10e3;     %Hz      switching frequency

Rl_tail=Vout_tail/Iout_tail; %Ohm   load resistor 
C_tail=Iout_tail/(2*f*Vripple); %C    capacitor value
L_tail=(Rl_tail*(1-d_tail))/(2*f);  %H     Inductor value


%% BRAKE PARAMETERS %%%
%LED values
Led_brake_current = [20, 90];        %mA
Led_brake_voltage = [2, 2.65];       %V
Led_brake_Rs = 5;                  %ohm
Rpull_down = 12;                   %ohm

%%calcolo parametri Buck Tail light
Vin=12;  %V          tensione in ingresso
Vout_brake=7.8; %V          tensione in uscita
d_brake=Vout_brake/Vin;          %duty cycle 
Iout_brake=0.300;  %A       corrente che voglio in uscita
Iin_brake=d_brake*Iout_brake; %A       corrente in ingresso
Vripple=0.2; %V      voltage ripple
f=10e3;     %Hz      switching frequency

Rl_brake=Vout_brake/Iout_brake; %Ohm   load resistor 
C_brake=Iout_brake/(2*f*Vripple); %C    capacitor value
L_brake=(Rl_brake*(1-d_brake))/(2*f);  %H     Inductor value


%% TURN PARAMETERS %%%
%LED values
Led_turn_current = [20, 90];        %mA
Led_turn_voltage = [2, 2.65];       %V
Led_turn_Rs = 5;                  %ohm

%%calcolo parametri Buck Tail light
Vin=12;  %V          tensione in ingresso
Vout_turn=7.8; %V          tensione in uscita
d_turn=Vout_turn/Vin;          %duty cycle 
Iout_turn=0.300;  %A       corrente che voglio in uscita
Iin_turn=d_turn*Iout_turn; %A       corrente in ingresso
Vripple=0.2; %V      voltage ripple
f=10e3;     %Hz      switching frequency

Rl_turn=Vout_turn/Iout_turn; %Ohm   load resistor 
C_turn=Iout_turn/(2*f*Vripple); %C    capacitor value
L_turn=(Rl_turn*(1-d_turn))/(2*f);  %H     Inductor value



