"""
This file defines functions to interact with Cuckoo APIs
"""
import requests
from mysecrets import APIToken

import http

def patch_http_response_read(func):
    def inner(*args):
        try:
            return func(*args)
        except http.client.IncompleteRead as e:
            return e.partial
    return inner

http.client.HTTPResponse.read = patch_http_response_read(http.client.HTTPResponse.read)

API_URL = "http://localhost:8090/"
#API_URL = "http://192.168.0.123:8090/" #to interact with the VM running cuckoo

header = {'Authorization': "Bearer " + APIToken}

#creates a task and returns its ids
def submitSample(path, machineId, timeout="", enforceT="", package="exe"):
    url = "tasks/create/file"
    with open(path, "rb") as sample:
        files = {"file": (path, sample)}
        if timeout != "" and enforceT != "":
            data = {"machine" : str(machineId), "timeout" : str(timeout), "enforce_timeout":str(enforceT), "package":str(package)}
        else:
            data = {"machine" : str(machineId)}
        r = requests.post(API_URL + url, headers=header, files=files, data=data)
    return r.json()["task_id"]

def getTaskState(taskId):
    url = "tasks/view/" + taskId
    res = requests.get(API_URL + url, headers=header)
    return res.json()['task']["status"]

def getCuckooStatus():
    url = "cuckoo/status"
    res = requests.get(API_URL + url, headers=header)
    return res.json()

def retrieveReport(taskId, format="json"):
    url = "tasks/report/" + taskId
    data = {"format":format}
    res = requests.get(API_URL + url, headers=header, data=data)
    return res.json()

def cleanData(taskId):
    url = "tasks/delete/" + taskId
    res = requests.get(API_URL + url, headers=header)
    if res.status_code == 200:
        return 0
    elif res.status_code == 404:
        print("Task " + taskId + " not found")
        return -1
    else:
        print("Unable to delete task " + taskId)
    return -1

def shutdownServer():
    url = "exit/"
    res = requests.get(API_URL + url, headers=header)
    if res.status_code == 200:
        print("Server successfully closed")
    else:
        print("Got problems during shutdown : " + str(res.status_code))
    return 
