import droidlysis3
import os
import json
import shutil
import contextlib
import io
import sys
import conf
from extractFeatures import extractArchive

@contextlib.contextmanager
def nostdout():
    save_stdout = sys.stdout
    sys.stdout = io.BytesIO()
    yield
    sys.stdout = save_stdout

#dataset_dir = os.path.expanduser("~/Desktop/dataset/android/")
dataset_dir = conf.D_SOURCE
families = conf.FAMILIES

#families = ["Anubis"]
static_features = ["permissions", "smali_prop", "activities"]

def saveResults(sample, feats, tag):
    base = "results/"
    for feat in feats:
        if feats[feat] != []:
            f = open(base + feat + "/" + tag + "/" + sample + "." + feat, "w")
            if feat=="smali_prop":
                for fe in feats[feat]:
                    f.write(str(fe) + ":" + str(feats[feat][fe]) + "\n")
            else:
                for fe in feats[feat]:
                    f.write(fe + "\n")
    return

"""
This function parses the JSON and writes features on files.
@res is the dictionary containing analysis' results
@feat is a list of wanted features: [permissions, smali_prop, activities, services, receivers]
"""
def extractStaticFeatures(res, feat, sample, tag):
    #activitie
    ext = {}
    for f in static_features:
        ext[f] = []
    if "activities" in feat:
        ext["activities"] = [x.split(".")[-1] for x in res['manifest_properties']['activities']]
    if "permissions" in feat:
        ext["permissions"] = res['manifest_properties']['permissions']
    if "smali_prop" in feat:
        ext["smali_prop"] = res['smali_properties']
    saveResults(sample, ext, tag)
    return

"""
This function creates the directories where analysis' results will be stored.
"""
def prepareStatic():
    base = "results/"
    print("Creating folder " + base + "...")
    os.mkdir(base)
    for feat in static_features:
        print("Creating folder " + feat + "...")
        os.mkdir(base + feat)
        for tag in families:
            print("Creating folder " + tag + "...")
            os.mkdir(base + feat + "/" + tag)
    return

"""
This function runs static analysis using droidlysis and then writes features on file.
"""
def analyzeStatic(sample, tag, features):
    droidlysis3.process_file(sample, outdir="tmp/", no_kit_exception=True, enable_procyon=True)
    #sometimes VirusShare names samples hash.extension, droidlysis will create a folder named namesample-hash
    s = sample + "-" + sample.split(".")[0]
    f = open("tmp/" + s + "/report.json") ## FIND FILE NAME
    res = json.load(f)
    print("Extracting features...")
    extractStaticFeatures(res, features, sample.split(".")[0], tag)
    f.close()
    shutil.rmtree("tmp/")
    return


"""
This function extracts all the samples of a family and then starts analysis.
"""
def parseCollection(tag, features):
    path = dataset_dir + tag + "/"
    for file in os.listdir(path):
        sample = extractArchive(path + file)
        print(sample + " has been extracted")
        analyzeStatic(sample, tag, features)
        os.remove(sample)
    return

def runAndroidStatic():
    print("Preparing analysis environment...")
    for tag in families:
        print("Starting static analysis of " + tag)
        parseCollection(tag, static_features)