from pathlib import Path
import pandas as pd
from scipy import sparse

ftr_dir = Path("pre-extract")
data_dir = Path("data")


def integrated_features(features, dataset):
    """
    Integrates several features together
    :param features: Deature to be integrated
    :param dataset: Dataset used
    :return: DataFrame with several features together
    """
    def load_npz(file: str, prefix: str) -> pd.DataFrame:
        df = pd.DataFrame(sparse.load_npz(ftr_dir.joinpath(file)).toarray())
        df["ID"] = lbls.index
        df.set_index("ID", inplace=True)
        df.columns = [f"{prefix}--{str(col)}" for col in df.columns]
        return df
    if dataset == "ST-WinMal-benign" or dataset == "ST-WinMal-malign":
        suffix = dataset.split("-")[-1]
        lbls = pd.read_csv(data_dir.joinpath("ST-WinMal_"+suffix+".csv"))
    else:
        lbls = pd.read_csv(data_dir.joinpath("trainLabels_"+dataset+".csv"))
    lbls.set_index("Id", inplace=True)
    dfs = []

    if dataset == "ST-WinMal-benign" or dataset == "ST-WinMal-malign":
        if "API_check" in features:
            api_check_microsoft = load_npz("API_check_ST-WinMal_"+suffix+".npz", "api_check")
            dfs.append(api_check_microsoft)
        if "entropy" in features:
            entropy_microsoft = load_npz("entropy_ST-WinMal_"+suffix+".npz", "section")
            dfs.append(entropy_microsoft)
        if "3_gram_bytes" in features:
            grams_microsoft = load_npz("3_gram_bytes_ST-WinMal_"+suffix+".npz", "byte")
            dfs.append(grams_microsoft)
    else:
        if "binary_size" in features:
            binary_size = load_npz("binary_size_"+dataset+".npz", "binary-size")
            dfs.append(binary_size)
        if "3_gram_bytes" in features:
            byte_grams = load_npz("3_gram_bytes_"+dataset+".npz", "byte")
            dfs.append(byte_grams)
        if "entropy" in features:
            entropy_benign = load_npz("entropy_"+dataset+".npz", "entropy")
            dfs.append(entropy_benign)

        if dataset == "malign":
            if "4_gram_API" in features:
                api_grams_malign = load_npz("4_gram_API_malign.npz", "api")
                dfs.append(api_grams_malign)
            if "4_gram_opcode" in features:
                opcode_grams_malign = load_npz("4_gram_opcode_malign.npz", "opcode")
                dfs.append(opcode_grams_malign)
            if "opcode_counter" in features:
                opcode_counter_malign = load_npz("opcode_counter_malign.npz", "opcode_count")
                dfs.append(opcode_counter_malign)
            if "API_check" in features:
                api_check_malign = load_npz("API_check_malign.npz", "api_check")
                dfs.append(api_check_malign)

    return pd.concat(dfs, axis="columns")

