from pathlib import Path
import pandas as pd


ftr_dir = Path("pre-extract")
if not ftr_dir.exists():
    ftr_dir.mkdir()


class CSVReader:
    def __init__(self, name_file) -> None:
        """
        create object CSVReader
        :param name_file: Name of file CSV
        """
        self.name_file = name_file

    def save(self, data) -> None:
        """
        Save a DataFrame as CSV file
        :param data: Dataframe to save in file CSV
        """
        data.to_csv(ftr_dir.joinpath(self.name_file))

    def load(self):
        """
        Load into a DataFrame the contents of a CSV
        :return: DataFrame with the contents of a CSV
        """
        path = ftr_dir.joinpath(self.name_file)
        return pd.read_csv(path).set_index("ID") if path.exists() else None
