function plotAndAnimateParkingRRT(p, xRef, xTrackHistory, uTrackHistory, info)


% animate
timeLength = size(xTrackHistory,2);
for ct = 1:timeLength
    helperSLVisualizeParking(xTrackHistory(:,ct)', uTrackHistory(2,ct));
    pause(0.05);
end
%% Tracking Performance

num = p + 1;    % Interpolation Points ---> 100.

figure()
subplot(311), plot(xRef(:,1), 'b', 'LineWidth', 1.5), hold on
plot(xTrackHistory(1, 1:num), 'r:', 'LineWidth', 2), grid on
xlabel('Interpolation Point (Samples)', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('$x$ position [$m$]', 'FontSize', 15, 'Interpreter', 'latex')
legend('Desired Trajectory (RRT*)', 'Output Trajectory (NLMPC)', 'Interpreter', 'latex', 'Location','best')
subplot(312), plot(xRef(:, 2),'b', 'LineWidth', 1.5), hold on
plot(xTrackHistory(2, 1:num), 'r:', 'LineWidth', 2), grid on
xlabel('Interpolation Point (Samples)', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('$y$ position [$m$]', 'FontSize', 15, 'Interpreter', 'latex')
legend('Desired Trajectory (RRT*)', 'Output Trajectory (NLMPC)', 'Interpreter', 'latex', 'Location','best')
subplot(313), plot(xRef(:, 3), 'b', 'LineWidth', 1.5), hold on
plot(xTrackHistory(3, 1:num), 'r:', 'LineWidth', 2), grid on
xlabel('Interpolation Point (Samples)', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('Yaw angle, $\psi$ [$deg$]', 'FontSize', 15, 'Interpreter', 'latex')
legend('Desired Trajectory (RRT*)', 'Output Trajectory (NLMPC)', 'Interpreter', 'latex', 'Location','best')
sgtitle('\bf Tracking Performance of the Ego Vehicle States', 'FontSize', 20, 'Interpreter', 'latex')

figure()
subplot(311), plot(xTrackHistory(1, :), 'LineWidth', 1.5), grid on
xlabel('Time Step', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('$x$ position [$m$]', 'FontSize', 15, 'Interpreter', 'latex')
subplot(312), plot(xTrackHistory(2, :), 'LineWidth', 1.5), grid on
xlabel('Time Step', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('$y$ position [$m$]', 'FontSize', 15, 'Interpreter', 'latex')
subplot(313), plot(xTrackHistory(3, :), 'LineWidth', 1.5), grid on
xlabel('Time Step', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('Yaw angle, $\psi$ [$deg$]', 'FontSize', 15, 'Interpreter', 'latex')
sgtitle('\bf Behaviour of the Ego Vehicle States', 'FontSize', 20, 'Interpreter', 'latex')

%% Control inputs
figure()
subplot(211), stairs(uTrackHistory(1, :), 'LineWidth', 1.5), grid on
xlabel('Time Step', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('Speed, $v$ [$m/s$]', 'FontSize', 15, 'Interpreter', 'latex')
subplot(212), stairs(rad2deg(uTrackHistory(2,:)), 'LineWidth', 1.5), grid on
xlabel('Time Step', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('Steering Angle, $\delta$ [$deg$]', 'FontSize', 15, 'Interpreter', 'latex')
sgtitle('\bf Behaviour of the Ego Vehicle Control Inputs', 'FontSize', 20, 'Interpreter', 'latex')

%% Analysis

fprintf('\nParking Results Analysis:\n')
fprintf('1) Optimization exit flag = %d (Successful when positive)\n', info.ExitFlag);

e1 = norm(xTrackHistory(1, 1:num)-xRef(:,1)',inf);
e2 = norm(xTrackHistory(2, 1:num)-xRef(:,2)',inf);
e3 = rad2deg(norm(xTrackHistory(3,1:num)-xRef(:,3)',inf));
fprintf('2) Tracking Error in Infinity Norm in x [m], y [m] and psi [deg]: %2.4f, %2.4f, %2.4f\n', e1, e2,e3);

e1 = xTrackHistory(1, end) - xRef(end, 1);
e2 = xTrackHistory(2, end) - xRef(end, 2);
e3 = rad2deg(xTrackHistory(3, end) - xRef(end, 3));
fprintf('3) Final States Error in x [m], y [m], and psi [deg]: %2.4f, %2.4f, %2.4f\n', e1, e2, e3);

vFinal = uTrackHistory(1, end);
deltaFinal = rad2deg(uTrackHistory(2, end));
fprintf('4) Final Control Inputs of Speed [m/s] and Steering angle [deg]: %2.4f, %2.4f\n', vFinal, deltaFinal);

