/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * nlmpcmoveCodeGeneration.c
 *
 * Code generation for function 'nlmpcmoveCodeGeneration'
 *
 */

/* Include files */
#include "nlmpcmoveCodeGeneration.h"
#include "fmincon.h"
#include "mtimes.h"
#include "nlmpcmoveCodeGeneration_data.h"
#include "nlmpcmoveCodeGeneration_emxutil.h"
#include "nlmpcmoveCodeGeneration_internal_types.h"
#include "nlmpcmoveCodeGeneration_types.h"
#include "parkingVehicleStateJacobianFcnRRT.h"
#include "rt_nonfinite.h"
#include "znlmpc_confun.h"
#include "blas.h"
#include "mwmathutil.h"
#include <stddef.h>
#include <string.h>

/* Function Definitions */
void c_nlmpcmoveCodeGeneration_anonF(
    const real_T runtimedata_x[3], const real_T runtimedata_OutputMin[30],
    const real_T runtimedata_OutputMax[30], const real_T z[51],
    emxArray_real_T *varargout_1, real_T varargout_2[32],
    emxArray_real_T *varargout_3, real_T varargout_4[1632])
{
  ptrdiff_t k_t;
  ptrdiff_t lda_t;
  ptrdiff_t ldb_t;
  ptrdiff_t ldc_t;
  ptrdiff_t m_t;
  ptrdiff_t n_t;
  emxArray_real_T *Jc;
  emxArray_real_T *c;
  real_T Jx[900];
  real_T Jmv[600];
  real_T y[600];
  real_T b_Jx[60];
  real_T Ju[40];
  real_T b_y[40];
  real_T X[33];
  real_T b_X[33];
  real_T b_z[30];
  real_T U[22];
  real_T Umv[22];
  real_T a[20];
  real_T alpha1;
  real_T beta1;
  real_T cequ_tmp_idx_0;
  real_T cequ_tmp_idx_1;
  real_T d;
  real_T d1;
  real_T du;
  real_T dx;
  real_T *Jc_data;
  real_T *c_data;
  real_T *varargout_1_data;
  int32_T b_i;
  int32_T i;
  int32_T input_sizes_idx_0;
  int32_T k;
  int32_T sizes_idx_1;
  char_T TRANSA1;
  char_T TRANSB1;
  int8_T ic[3];
  emlrtHeapReferenceStackEnterFcnR2012b(emlrtRootTLSGlobal);
  memset(&X[0], 0, 33U * sizeof(real_T));
  memset(&Umv[0], 0, 22U * sizeof(real_T));
  for (i = 0; i < 20; i++) {
    d = 0.0;
    for (k = 0; k < 20; k++) {
      d += (real_T)iv[i + 20 * k] * z[k + 30];
    }
    a[i] = d;
  }
  for (i = 0; i < 2; i++) {
    for (k = 0; k < 10; k++) {
      Umv[k + 11 * i] = a[i + (k << 1)];
    }
  }
  memcpy(&b_z[0], &z[0], 30U * sizeof(real_T));
  for (i = 0; i < 3; i++) {
    for (k = 0; k < 10; k++) {
      X[(k + 11 * i) + 1] = b_z[i + 3 * k];
    }
    X[11 * i] = runtimedata_x[i];
  }
  for (b_i = 0; b_i < 2; b_i++) {
    Umv[11 * b_i + 10] = Umv[11 * b_i + 9];
    memcpy(&U[b_i * 11], &Umv[b_i * 11], 11U * sizeof(real_T));
  }
  memset(&Jx[0], 0, 900U * sizeof(real_T));
  memset(&Jmv[0], 0, 600U * sizeof(real_T));
  memset(&b_z[0], 0, 30U * sizeof(real_T));
  ic[0] = 1;
  ic[1] = 2;
  ic[2] = 3;
  for (i = 0; i < 11; i++) {
    sizes_idx_1 = i << 1;
    Umv[sizes_idx_1] = U[i];
    Umv[sizes_idx_1 + 1] = U[i + 11];
  }
  for (i = 0; i < 11; i++) {
    b_X[3 * i] = X[i];
    b_X[3 * i + 1] = X[i + 11];
    b_X[3 * i + 2] = X[i + 22];
  }
  for (b_i = 0; b_i < 10; b_i++) {
    real_T Ak[9];
    real_T Ak1[9];
    real_T Bk1[6];
    real_T val[6];
    int8_T i1;
    int8_T i2;
    int8_T i3;
    /*  State equations for parking:  */
    /*  state variables x, y and yaw angle theta. */
    /*  control variables v and steering angle delta. */
    /*  Copyright 2019 The MathWorks, Inc. */
    /*  */
    /*  Parameters */
    /*  Variables */
    /*  State equations */
    sizes_idx_1 = b_i << 1;
    alpha1 = b_X[3 * b_i + 2];
    beta1 = Umv[sizes_idx_1];
    dx = beta1 / 2.8 * muDoubleScalarTan(Umv[sizes_idx_1 + 1]);
    c_parkingVehicleStateJacobianFc(&b_X[3 * b_i], &Umv[b_i << 1], Ak, val);
    /*  State equations for parking:  */
    /*  state variables x, y and yaw angle theta. */
    /*  control variables v and steering angle delta. */
    /*  Copyright 2019 The MathWorks, Inc. */
    /*  */
    /*  Parameters */
    /*  Variables */
    /*  State equations */
    sizes_idx_1 = 3 * (b_i + 1);
    du = b_X[sizes_idx_1 + 2];
    c_parkingVehicleStateJacobianFc(&b_X[3 * (b_i + 1)], &Umv[b_i << 1], Ak1,
                                    Bk1);
    b_z[ic[0] - 1] = (b_X[3 * b_i] + 0.05 * (beta1 * muDoubleScalarCos(alpha1) +
                                             beta1 * muDoubleScalarCos(du))) -
                     b_X[sizes_idx_1];
    b_z[ic[1] - 1] =
        (b_X[3 * b_i + 1] + 0.05 * (beta1 * muDoubleScalarSin(alpha1) +
                                    beta1 * muDoubleScalarSin(du))) -
        b_X[sizes_idx_1 + 1];
    b_z[ic[2] - 1] = (alpha1 + 0.05 * (dx + dx)) - du;
    if (b_i + 1 > 1) {
      input_sizes_idx_0 = 90 * (b_i - 1);
      for (k = 0; k < 3; k++) {
        Jx[((ic[0] + 30 * k) + input_sizes_idx_0) - 1] = 0.05 * Ak[3 * k];
        Jx[((ic[1] + 30 * k) + input_sizes_idx_0) - 1] = 0.05 * Ak[3 * k + 1];
        Jx[((ic[2] + 30 * k) + input_sizes_idx_0) - 1] = 0.05 * Ak[3 * k + 2];
        sizes_idx_1 = ((ic[k] + 30 * k) + input_sizes_idx_0) - 1;
        Jx[sizes_idx_1]++;
      }
    }
    for (k = 0; k < 3; k++) {
      Jx[((ic[0] + 30 * k) + 90 * b_i) - 1] = 0.05 * Ak1[3 * k];
      Jx[((ic[1] + 30 * k) + 90 * b_i) - 1] = 0.05 * Ak1[3 * k + 1];
      Jx[((ic[2] + 30 * k) + 90 * b_i) - 1] = 0.05 * Ak1[3 * k + 2];
      input_sizes_idx_0 = ((ic[k] + 30 * k) + 90 * b_i) - 1;
      Jx[input_sizes_idx_0]--;
    }
    for (i = 0; i < 6; i++) {
      val[i] = 0.05 * (val[i] + Bk1[i]);
    }
    i1 = ic[0];
    i2 = ic[1];
    i3 = ic[2];
    for (k = 0; k < 2; k++) {
      Jmv[((i1 + 30 * k) + 60 * b_i) - 1] = val[3 * k];
      Jmv[((i2 + 30 * k) + 60 * b_i) - 1] = val[3 * k + 1];
      Jmv[((i3 + 30 * k) + 60 * b_i) - 1] = val[3 * k + 2];
    }
    ic[0] = (int8_T)(ic[0] + 3);
    ic[1] = (int8_T)(ic[1] + 3);
    ic[2] = (int8_T)(ic[2] + 3);
  }
  TRANSB1 = 'N';
  TRANSA1 = 'N';
  alpha1 = 1.0;
  beta1 = 0.0;
  m_t = (ptrdiff_t)30;
  n_t = (ptrdiff_t)20;
  k_t = (ptrdiff_t)20;
  lda_t = (ptrdiff_t)30;
  ldb_t = (ptrdiff_t)20;
  ldc_t = (ptrdiff_t)30;
  dgemm(&TRANSA1, &TRANSB1, &m_t, &n_t, &k_t, &alpha1, &Jmv[0], &lda_t,
        (real_T *)&dv[0], &ldb_t, &beta1, &y[0], &ldc_t);
  emxInit_real_T(&c, 2);
  emxInit_real_T(&Jc, 2);
  outputBounds(runtimedata_OutputMin, runtimedata_OutputMax, X, z[50], c, Jc);
  Jc_data = Jc->data;
  c_data = c->data;
  /*  Terminal constraints for parking. */
  /*  Copyright 2019 The MathWorks, Inc. */
  cequ_tmp_idx_0 = U[10];
  cequ_tmp_idx_1 = U[21];
  memset(&Ju[0], 0, 40U * sizeof(real_T));
  for (k = 0; k < 33; k++) {
    d = muDoubleScalarAbs(X[k]);
    b_X[k] = d;
    if (d < 1.0) {
      b_X[k] = 1.0;
    }
  }
  d = U[10];
  d1 = U[21];
  for (b_i = 0; b_i < 10; b_i++) {
    for (sizes_idx_1 = 0; sizes_idx_1 < 3; sizes_idx_1++) {
      dx = 1.0E-6 * b_X[sizes_idx_1];
      /*  Terminal constraints for parking. */
      /*  Copyright 2019 The MathWorks, Inc. */
      input_sizes_idx_0 = (sizes_idx_1 << 1) + 6 * b_i;
      b_Jx[input_sizes_idx_0] = (d - d) / dx;
      b_Jx[input_sizes_idx_0 + 1] = (d1 - d1) / dx;
    }
  }
  for (k = 0; k < 22; k++) {
    d = muDoubleScalarAbs(U[k]);
    Umv[k] = d;
    if (d < 1.0) {
      Umv[k] = 1.0;
    }
  }
  d = Umv[0];
  d1 = Umv[1];
  for (b_i = 0; b_i < 9; b_i++) {
    du = 1.0E-6 * d;
    /*  Terminal constraints for parking. */
    /*  Copyright 2019 The MathWorks, Inc. */
    sizes_idx_1 = b_i << 2;
    alpha1 = U[10] - cequ_tmp_idx_0;
    Ju[sizes_idx_1] = alpha1 / du;
    beta1 = U[21] - cequ_tmp_idx_1;
    Ju[sizes_idx_1 + 1] = beta1 / du;
    U[b_i] = (U[b_i] + du) - du;
    du = 1.0E-6 * d1;
    /*  Terminal constraints for parking. */
    /*  Copyright 2019 The MathWorks, Inc. */
    Ju[sizes_idx_1 + 2] = alpha1 / du;
    Ju[sizes_idx_1 + 3] = beta1 / du;
    U[b_i + 11] = (U[b_i + 11] + du) - du;
  }
  du = 1.0E-6 * Umv[0];
  U[10] += du;
  /*  Terminal constraints for parking. */
  /*  Copyright 2019 The MathWorks, Inc. */
  Ju[36] = (U[10] - cequ_tmp_idx_0) / du;
  Ju[37] = (U[21] - cequ_tmp_idx_1) / du;
  U[10] -= du;
  du = 1.0E-6 * Umv[1];
  U[21] += du;
  /*  Terminal constraints for parking. */
  /*  Copyright 2019 The MathWorks, Inc. */
  Ju[38] = (U[10] - cequ_tmp_idx_0) / du;
  Ju[39] = (U[21] - cequ_tmp_idx_1) / du;
  TRANSB1 = 'N';
  TRANSA1 = 'N';
  alpha1 = 1.0;
  beta1 = 0.0;
  m_t = (ptrdiff_t)2;
  n_t = (ptrdiff_t)20;
  k_t = (ptrdiff_t)20;
  lda_t = (ptrdiff_t)2;
  ldb_t = (ptrdiff_t)20;
  ldc_t = (ptrdiff_t)2;
  dgemm(&TRANSA1, &TRANSB1, &m_t, &n_t, &k_t, &alpha1, &Ju[0], &lda_t,
        (real_T *)&dv[0], &ldb_t, &beta1, &b_y[0], &ldc_t);
  if ((c->size[0] != 0) && (c->size[1] != 0)) {
    sizes_idx_1 = c->size[1];
  } else {
    sizes_idx_1 = 0;
  }
  if ((sizes_idx_1 == 0) || ((c->size[0] != 0) && (c->size[1] != 0))) {
    input_sizes_idx_0 = c->size[0];
  } else {
    input_sizes_idx_0 = 0;
  }
  i = varargout_1->size[0] * varargout_1->size[1];
  varargout_1->size[0] = input_sizes_idx_0;
  varargout_1->size[1] = sizes_idx_1;
  emxEnsureCapacity_real_T(varargout_1, i);
  varargout_1_data = varargout_1->data;
  for (i = 0; i < sizes_idx_1; i++) {
    for (k = 0; k < input_sizes_idx_0; k++) {
      varargout_1_data[k + varargout_1->size[0] * i] =
          c_data[k + input_sizes_idx_0 * i];
    }
  }
  emxFree_real_T(&c);
  memcpy(&varargout_2[0], &b_z[0], 30U * sizeof(real_T));
  varargout_2[30] = cequ_tmp_idx_0;
  varargout_2[31] = cequ_tmp_idx_1;
  if ((Jc->size[0] != 0) && (Jc->size[1] != 0)) {
    sizes_idx_1 = Jc->size[0];
  } else {
    sizes_idx_1 = 0;
  }
  if ((sizes_idx_1 == 0) || ((Jc->size[0] != 0) && (Jc->size[1] != 0))) {
    input_sizes_idx_0 = Jc->size[1];
  } else {
    input_sizes_idx_0 = 0;
  }
  i = varargout_3->size[0] * varargout_3->size[1];
  varargout_3->size[0] = sizes_idx_1;
  varargout_3->size[1] = input_sizes_idx_0;
  emxEnsureCapacity_real_T(varargout_3, i);
  c_data = varargout_3->data;
  for (i = 0; i < input_sizes_idx_0; i++) {
    for (k = 0; k < sizes_idx_1; k++) {
      c_data[k + varargout_3->size[0] * i] = Jc_data[k + sizes_idx_1 * i];
    }
  }
  emxFree_real_T(&Jc);
  for (i = 0; i < 30; i++) {
    for (k = 0; k < 30; k++) {
      varargout_4[k + 51 * i] = Jx[i + 30 * k];
    }
    for (k = 0; k < 20; k++) {
      varargout_4[(k + 51 * i) + 30] = y[i + 30 * k];
    }
    varargout_4[51 * i + 50] = 0.0;
  }
  for (i = 0; i < 2; i++) {
    for (k = 0; k < 30; k++) {
      varargout_4[k + 51 * (i + 30)] = b_Jx[i + (k << 1)];
    }
    for (k = 0; k < 20; k++) {
      varargout_4[(k + 51 * (i + 30)) + 30] = b_y[i + (k << 1)];
    }
    varargout_4[51 * (i + 30) + 50] = 0.0;
  }
  emlrtHeapReferenceStackLeaveFcnR2012b(emlrtRootTLSGlobal);
}

void nlmpcmoveCodeGeneration(const real_T x[3], const real_T lastMV[2],
                             struct1_T *onlinedata, real_T mv[2],
                             struct2_T *info)
{
  static const real_T varargin_14[20] = {
      0.1,   0.1,   0.1,   0.1,   0.1,   0.1,   0.1,   0.1,   0.1,   0.1,
      0.005, 0.005, 0.005, 0.005, 0.005, 0.005, 0.005, 0.005, 0.005, 0.005};
  static const real_T varargin_26[20] = {-2.0,
                                         -2.0,
                                         -2.0,
                                         -2.0,
                                         -2.0,
                                         -2.0,
                                         -2.0,
                                         -2.0,
                                         -2.0,
                                         -2.0,
                                         -0.52359877559829882,
                                         -0.52359877559829882,
                                         -0.52359877559829882,
                                         -0.52359877559829882,
                                         -0.52359877559829882,
                                         -0.52359877559829882,
                                         -0.52359877559829882,
                                         -0.52359877559829882,
                                         -0.52359877559829882,
                                         -0.52359877559829882};
  static const real_T varargin_28[20] = {2.0,
                                         2.0,
                                         2.0,
                                         2.0,
                                         2.0,
                                         2.0,
                                         2.0,
                                         2.0,
                                         2.0,
                                         2.0,
                                         0.52359877559829882,
                                         0.52359877559829882,
                                         0.52359877559829882,
                                         0.52359877559829882,
                                         0.52359877559829882,
                                         0.52359877559829882,
                                         0.52359877559829882,
                                         0.52359877559829882,
                                         0.52359877559829882,
                                         0.52359877559829882};
  static const int8_T b_iv[10] = {2, 3, 4, 5, 6, 7, 8, 9, 10, 10};
  emxArray_int8_T *ii;
  emxArray_real_T b_Auf;
  emxArray_real_T *Auf;
  emxArray_real_T *B;
  emxArray_real_T *b_initX;
  emxArray_real_T *initMV;
  emxArray_real_T *initX;
  emxArray_real_T *ref;
  emxArray_real_T *y;
  i_struct_T CostFcn_workspace_runtimedata;
  j_struct_T b_expl_temp;
  j_struct_T expl_temp;
  m_struct_T Out;
  real_T Bu[80];
  real_T b_dv[51];
  real_T c_initX[51];
  real_T dv1[51];
  real_T z[51];
  real_T b_x[30];
  real_T Umv[22];
  real_T b_lastMV[20];
  real_T ic_idx_0;
  real_T ic_idx_1;
  real_T *initMV_data;
  real_T *initX_data;
  real_T *ref_data;
  real_T *y_data;
  int32_T b_ii[2];
  int32_T Au_tmp;
  int32_T i;
  int32_T i1;
  int32_T idx;
  int32_T loop_ub;
  int32_T unnamed_idx_0;
  int8_T Au[1600];
  int8_T *ii_data;
  boolean_T icf[80];
  boolean_T exitg1;
  emlrtHeapReferenceStackEnterFcnR2012b(emlrtRootTLSGlobal);
  emxInit_real_T(&ref, 2);
  ref_data = ref->data;
  if (onlinedata->ref->size[0] == 0) {
    i = ref->size[0] * ref->size[1];
    ref->size[0] = 10;
    ref->size[1] = 3;
    emxEnsureCapacity_real_T(ref, i);
    ref_data = ref->data;
    for (i = 0; i < 30; i++) {
      ref_data[i] = 0.0;
    }
  } else if (onlinedata->ref->size[0] == 0) {
    ref->size[0] = 0;
    ref->size[1] = 0;
  } else if (onlinedata->ref->size[0] < 10) {
    unnamed_idx_0 = 10 - onlinedata->ref->size[0];
    i = ref->size[0] * ref->size[1];
    ref->size[0] = onlinedata->ref->size[0] + unnamed_idx_0;
    ref->size[1] = 3;
    emxEnsureCapacity_real_T(ref, i);
    ref_data = ref->data;
    loop_ub = onlinedata->ref->size[0];
    for (i = 0; i < 3; i++) {
      for (i1 = 0; i1 < loop_ub; i1++) {
        ref_data[i1 + ref->size[0] * i] =
            onlinedata->ref->data[i1 + onlinedata->ref->size[0] * i];
      }
    }
    for (i = 0; i < 3; i++) {
      for (i1 = 0; i1 < unnamed_idx_0; i1++) {
        ref_data[(i1 + onlinedata->ref->size[0]) + ref->size[0] * i] =
            onlinedata->ref->data[(onlinedata->ref->size[0] +
                                   onlinedata->ref->size[0] * i) -
                                  1];
      }
    }
  } else {
    i = ref->size[0] * ref->size[1];
    ref->size[0] = onlinedata->ref->size[0];
    ref->size[1] = 3;
    emxEnsureCapacity_real_T(ref, i);
    ref_data = ref->data;
    loop_ub = onlinedata->ref->size[0] * 3;
    for (i = 0; i < loop_ub; i++) {
      ref_data[i] = onlinedata->ref->data[i];
    }
  }
  emxInitStruct_struct_T3(&expl_temp);
  if (onlinedata->MVTarget->size[0] == 0) {
    i = expl_temp.MVTarget->size[0] * expl_temp.MVTarget->size[1];
    expl_temp.MVTarget->size[0] = 10;
    expl_temp.MVTarget->size[1] = 2;
    emxEnsureCapacity_real_T(expl_temp.MVTarget, i);
    for (i = 0; i < 20; i++) {
      expl_temp.MVTarget->data[i] = 0.0;
    }
  } else if (onlinedata->MVTarget->size[0] == 0) {
    expl_temp.MVTarget->size[0] = 0;
    expl_temp.MVTarget->size[1] = 0;
  } else if (onlinedata->MVTarget->size[0] < 10) {
    unnamed_idx_0 = 10 - onlinedata->MVTarget->size[0];
    i = expl_temp.MVTarget->size[0] * expl_temp.MVTarget->size[1];
    expl_temp.MVTarget->size[0] = onlinedata->MVTarget->size[0] + unnamed_idx_0;
    expl_temp.MVTarget->size[1] = 2;
    emxEnsureCapacity_real_T(expl_temp.MVTarget, i);
    loop_ub = onlinedata->MVTarget->size[0];
    for (i = 0; i < 2; i++) {
      for (i1 = 0; i1 < loop_ub; i1++) {
        expl_temp.MVTarget->data[i1 + expl_temp.MVTarget->size[0] * i] =
            onlinedata->MVTarget->data[i1 + onlinedata->MVTarget->size[0] * i];
      }
    }
    for (i = 0; i < 2; i++) {
      for (i1 = 0; i1 < unnamed_idx_0; i1++) {
        expl_temp.MVTarget->data[(i1 + onlinedata->MVTarget->size[0]) +
                                 expl_temp.MVTarget->size[0] * i] =
            onlinedata->MVTarget->data[(onlinedata->MVTarget->size[0] +
                                        onlinedata->MVTarget->size[0] * i) -
                                       1];
      }
    }
  } else {
    i = expl_temp.MVTarget->size[0] * expl_temp.MVTarget->size[1];
    expl_temp.MVTarget->size[0] = onlinedata->MVTarget->size[0];
    expl_temp.MVTarget->size[1] = 2;
    emxEnsureCapacity_real_T(expl_temp.MVTarget, i);
    loop_ub = onlinedata->MVTarget->size[0] * 2;
    for (i = 0; i < loop_ub; i++) {
      expl_temp.MVTarget->data[i] = onlinedata->MVTarget->data[i];
    }
  }
  emxInit_real_T(&initX, 2);
  initX_data = initX->data;
  if (onlinedata->X0->size[0] != 0) {
    if (onlinedata->X0->size[0] == 0) {
      initX->size[0] = 0;
      initX->size[1] = 0;
    } else if (onlinedata->X0->size[0] < 10) {
      unnamed_idx_0 = 10 - onlinedata->X0->size[0];
      i = initX->size[0] * initX->size[1];
      initX->size[0] = onlinedata->X0->size[0] + unnamed_idx_0;
      initX->size[1] = 3;
      emxEnsureCapacity_real_T(initX, i);
      initX_data = initX->data;
      loop_ub = onlinedata->X0->size[0];
      for (i = 0; i < 3; i++) {
        for (i1 = 0; i1 < loop_ub; i1++) {
          initX_data[i1 + initX->size[0] * i] =
              onlinedata->X0->data[i1 + onlinedata->X0->size[0] * i];
        }
      }
      for (i = 0; i < 3; i++) {
        for (i1 = 0; i1 < unnamed_idx_0; i1++) {
          initX_data[(i1 + onlinedata->X0->size[0]) + initX->size[0] * i] =
              onlinedata->X0->data[(onlinedata->X0->size[0] +
                                    onlinedata->X0->size[0] * i) -
                                   1];
        }
      }
    } else {
      i = initX->size[0] * initX->size[1];
      initX->size[0] = onlinedata->X0->size[0];
      initX->size[1] = 3;
      emxEnsureCapacity_real_T(initX, i);
      initX_data = initX->data;
      loop_ub = onlinedata->X0->size[0] * 3;
      for (i = 0; i < loop_ub; i++) {
        initX_data[i] = onlinedata->X0->data[i];
      }
    }
  } else {
    for (i = 0; i < 3; i++) {
      b_x[10 * i] = x[i];
      for (i1 = 0; i1 < 9; i1++) {
        b_x[(i1 + 10 * i) + 1] = x[i];
      }
    }
    i = initX->size[0] * initX->size[1];
    initX->size[0] = 10;
    initX->size[1] = 3;
    emxEnsureCapacity_real_T(initX, i);
    initX_data = initX->data;
    for (i = 0; i < 30; i++) {
      initX_data[i] = b_x[i];
    }
  }
  emxInit_real_T(&initMV, 2);
  initMV_data = initMV->data;
  if (onlinedata->MV0->size[0] != 0) {
    if (onlinedata->MV0->size[0] == 0) {
      initMV->size[0] = 0;
      initMV->size[1] = 0;
    } else if (onlinedata->MV0->size[0] < 10) {
      unnamed_idx_0 = 10 - onlinedata->MV0->size[0];
      i = initMV->size[0] * initMV->size[1];
      initMV->size[0] = onlinedata->MV0->size[0] + unnamed_idx_0;
      initMV->size[1] = 2;
      emxEnsureCapacity_real_T(initMV, i);
      initMV_data = initMV->data;
      loop_ub = onlinedata->MV0->size[0];
      for (i = 0; i < 2; i++) {
        for (i1 = 0; i1 < loop_ub; i1++) {
          initMV_data[i1 + initMV->size[0] * i] =
              onlinedata->MV0->data[i1 + onlinedata->MV0->size[0] * i];
        }
      }
      for (i = 0; i < 2; i++) {
        for (i1 = 0; i1 < unnamed_idx_0; i1++) {
          initMV_data[(i1 + onlinedata->MV0->size[0]) + initMV->size[0] * i] =
              onlinedata->MV0->data[(onlinedata->MV0->size[0] +
                                     onlinedata->MV0->size[0] * i) -
                                    1];
        }
      }
    } else {
      i = initMV->size[0] * initMV->size[1];
      initMV->size[0] = onlinedata->MV0->size[0];
      initMV->size[1] = 2;
      emxEnsureCapacity_real_T(initMV, i);
      initMV_data = initMV->data;
      loop_ub = onlinedata->MV0->size[0] * 2;
      for (i = 0; i < loop_ub; i++) {
        initMV_data[i] = onlinedata->MV0->data[i];
      }
    }
  } else {
    for (i = 0; i < 2; i++) {
      b_lastMV[10 * i] = lastMV[i];
      for (i1 = 0; i1 < 9; i1++) {
        b_lastMV[(i1 + 10 * i) + 1] = lastMV[i];
      }
    }
    i = initMV->size[0] * initMV->size[1];
    initMV->size[0] = 10;
    initMV->size[1] = 2;
    emxEnsureCapacity_real_T(initMV, i);
    initMV_data = initMV->data;
    for (i = 0; i < 20; i++) {
      initMV_data[i] = b_lastMV[i];
    }
  }
  i = expl_temp.References->size[0] * expl_temp.References->size[1];
  expl_temp.References->size[0] = ref->size[0];
  expl_temp.References->size[1] = ref->size[1];
  emxEnsureCapacity_real_T(expl_temp.References, i);
  loop_ub = ref->size[0] * ref->size[1];
  for (i = 0; i < loop_ub; i++) {
    expl_temp.References->data[i] = ref_data[i];
  }
  emxInitStruct_struct_T2(&CostFcn_workspace_runtimedata);
  CostFcn_workspace_runtimedata.x[0] = x[0];
  CostFcn_workspace_runtimedata.x[1] = x[1];
  CostFcn_workspace_runtimedata.x[2] = x[2];
  CostFcn_workspace_runtimedata.lastMV[0] = lastMV[0];
  CostFcn_workspace_runtimedata.lastMV[1] = lastMV[1];
  i = CostFcn_workspace_runtimedata.ref->size[0] *
      CostFcn_workspace_runtimedata.ref->size[1];
  CostFcn_workspace_runtimedata.ref->size[0] = ref->size[0];
  CostFcn_workspace_runtimedata.ref->size[1] = ref->size[1];
  emxEnsureCapacity_real_T(CostFcn_workspace_runtimedata.ref, i);
  loop_ub = ref->size[0] * ref->size[1];
  for (i = 0; i < loop_ub; i++) {
    CostFcn_workspace_runtimedata.ref->data[i] = ref_data[i];
  }
  for (i = 0; i < 30; i++) {
    CostFcn_workspace_runtimedata.OutputWeights[i] = 3.0;
  }
  for (i = 0; i < 20; i++) {
    CostFcn_workspace_runtimedata.MVWeights[i] = 0.0;
    CostFcn_workspace_runtimedata.MVRateWeights[i] = varargin_14[i];
  }
  CostFcn_workspace_runtimedata.ECRWeight = 100000.0;
  for (i = 0; i < 30; i++) {
    CostFcn_workspace_runtimedata.OutputMin[i] = rtMinusInf;
    CostFcn_workspace_runtimedata.OutputMax[i] = rtInf;
    CostFcn_workspace_runtimedata.StateMin[i] = rtMinusInf;
    CostFcn_workspace_runtimedata.StateMax[i] = rtInf;
  }
  for (i = 0; i < 20; i++) {
    CostFcn_workspace_runtimedata.MVMin[i] = varargin_26[i];
    CostFcn_workspace_runtimedata.MVMax[i] = varargin_28[i];
    CostFcn_workspace_runtimedata.MVRateMin[i] = rtMinusInf;
    CostFcn_workspace_runtimedata.MVRateMax[i] = rtInf;
  }
  i = CostFcn_workspace_runtimedata.MVScaledTarget->size[0] *
      CostFcn_workspace_runtimedata.MVScaledTarget->size[1];
  CostFcn_workspace_runtimedata.MVScaledTarget->size[0] =
      expl_temp.MVTarget->size[0];
  CostFcn_workspace_runtimedata.MVScaledTarget->size[1] =
      expl_temp.MVTarget->size[1];
  emxEnsureCapacity_real_T(CostFcn_workspace_runtimedata.MVScaledTarget, i);
  loop_ub = expl_temp.MVTarget->size[0] * expl_temp.MVTarget->size[1];
  for (i = 0; i < loop_ub; i++) {
    CostFcn_workspace_runtimedata.MVScaledTarget->data[i] =
        expl_temp.MVTarget->data[i];
  }
  memset(&Au[0], 0, 1600U * sizeof(int8_T));
  memset(&Bu[0], 0, 80U * sizeof(real_T));
  memset(&icf[0], 0, 80U * sizeof(boolean_T));
  ic_idx_0 = 1.0;
  ic_idx_1 = 2.0;
  for (loop_ub = 0; loop_ub < 10; loop_ub++) {
    icf[(int32_T)ic_idx_0 - 1] = false;
    icf[(int32_T)ic_idx_1 - 1] = false;
    icf[(int32_T)(ic_idx_0 + 2.0) - 1] = false;
    icf[(int32_T)(ic_idx_1 + 2.0) - 1] = false;
    icf[(int32_T)(ic_idx_0 + 4.0) - 1] = true;
    icf[(int32_T)(ic_idx_1 + 4.0) - 1] = true;
    icf[(int32_T)(ic_idx_0 + 6.0) - 1] = true;
    idx = (int32_T)ic_idx_0 + 160 * loop_ub;
    Au[idx - 1] = -1;
    unnamed_idx_0 = (int32_T)ic_idx_1 + 160 * loop_ub;
    Au[unnamed_idx_0 - 1] = 0;
    icf[(int32_T)(ic_idx_1 + 6.0) - 1] = true;
    Au[idx + 79] = 0;
    Au[unnamed_idx_0 + 79] = -1;
    idx = (int32_T)(ic_idx_0 + 2.0) + 160 * loop_ub;
    Au[idx - 1] = 1;
    unnamed_idx_0 = (int32_T)(ic_idx_1 + 2.0) + 160 * loop_ub;
    Au[unnamed_idx_0 - 1] = 0;
    Au[idx + 79] = 0;
    Au[unnamed_idx_0 + 79] = 1;
    idx = (int32_T)(ic_idx_0 + 4.0) + 160 * loop_ub;
    Au[idx - 1] = -1;
    unnamed_idx_0 = (int32_T)(ic_idx_1 + 4.0) + 160 * loop_ub;
    Au[unnamed_idx_0 - 1] = 0;
    Au[idx + 79] = 0;
    Au[unnamed_idx_0 + 79] = -1;
    idx = (int32_T)(ic_idx_0 + 6.0) + 160 * loop_ub;
    Au[idx - 1] = 1;
    unnamed_idx_0 = (int32_T)(ic_idx_1 + 6.0) + 160 * loop_ub;
    Au[unnamed_idx_0 - 1] = 0;
    Au[idx + 79] = 0;
    Au[unnamed_idx_0 + 79] = 1;
    Bu[(int32_T)ic_idx_0 - 1] = rtInf;
    Bu[(int32_T)ic_idx_1 - 1] = rtInf;
    Bu[(int32_T)(ic_idx_0 + 2.0) - 1] = rtInf;
    Bu[(int32_T)(ic_idx_1 + 2.0) - 1] = rtInf;
    Bu[(int32_T)(ic_idx_0 + 4.0) - 1] = -varargin_26[loop_ub];
    Bu[(int32_T)(ic_idx_1 + 4.0) - 1] = -varargin_26[loop_ub + 10];
    Bu[(int32_T)(ic_idx_0 + 6.0) - 1] = varargin_28[loop_ub];
    Bu[(int32_T)(ic_idx_1 + 6.0) - 1] = varargin_28[loop_ub + 10];
    if (loop_ub + 1 == 1) {
      real_T Bu_idx_1;
      Bu_idx_1 = Bu[(int32_T)ic_idx_1 - 1] - lastMV[1];
      Bu[(int32_T)ic_idx_0 - 1] -= lastMV[0];
      Bu[(int32_T)ic_idx_1 - 1] = Bu_idx_1;
      Bu_idx_1 = Bu[(int32_T)(ic_idx_1 + 2.0) - 1] + lastMV[1];
      Bu[(int32_T)(ic_idx_0 + 2.0) - 1] += lastMV[0];
      Bu[(int32_T)(ic_idx_1 + 2.0) - 1] = Bu_idx_1;
    } else {
      idx = 160 * (loop_ub - 1);
      unnamed_idx_0 = (int32_T)ic_idx_0 + idx;
      Au[unnamed_idx_0 - 1] = 1;
      Au_tmp = (int32_T)ic_idx_1 + idx;
      Au[Au_tmp - 1] = 0;
      Au[unnamed_idx_0 + 79] = 0;
      Au[Au_tmp + 79] = 1;
      unnamed_idx_0 = (int32_T)(ic_idx_0 + 2.0) + idx;
      Au[unnamed_idx_0 - 1] = -1;
      idx += (int32_T)(ic_idx_1 + 2.0);
      Au[idx - 1] = 0;
      Au[unnamed_idx_0 + 79] = 0;
      Au[idx + 79] = -1;
    }
    ic_idx_0 += 8.0;
    ic_idx_1 += 8.0;
  }
  idx = 0;
  emxInit_int8_T(&ii, 1);
  i = ii->size[0];
  ii->size[0] = 80;
  emxEnsureCapacity_int8_T(ii, i);
  ii_data = ii->data;
  unnamed_idx_0 = 0;
  exitg1 = false;
  while ((!exitg1) && (unnamed_idx_0 < 80)) {
    if (icf[unnamed_idx_0]) {
      idx++;
      ii_data[idx - 1] = (int8_T)(unnamed_idx_0 + 1);
      if (idx >= 80) {
        exitg1 = true;
      } else {
        unnamed_idx_0++;
      }
    } else {
      unnamed_idx_0++;
    }
  }
  i = ii->size[0];
  if (idx < 1) {
    ii->size[0] = 0;
  } else {
    ii->size[0] = idx;
  }
  emxEnsureCapacity_int8_T(ii, i);
  ii_data = ii->data;
  emxInit_real_T(&B, 1);
  if (ii->size[0] > 0) {
    int8_T input_sizes_idx_1;
    i = B->size[0];
    B->size[0] = ii->size[0];
    emxEnsureCapacity_real_T(B, i);
    ref_data = B->data;
    loop_ub = ii->size[0];
    for (i = 0; i < loop_ub; i++) {
      ref_data[i] = Bu[ii_data[i] - 1];
    }
    emxInit_real_T(&Auf, 3);
    i = Auf->size[0] * Auf->size[1] * Auf->size[2];
    Auf->size[0] = ii->size[0];
    Auf->size[1] = 2;
    Auf->size[2] = 10;
    emxEnsureCapacity_real_T(Auf, i);
    ref_data = Auf->data;
    i = ii->size[0];
    for (idx = 0; idx < 2; idx++) {
      for (unnamed_idx_0 = 0; unnamed_idx_0 < 10; unnamed_idx_0++) {
        for (loop_ub = 0; loop_ub < i; loop_ub++) {
          ref_data[(loop_ub + Auf->size[0] * idx) +
                   Auf->size[0] * 2 * unnamed_idx_0] =
              Au[((ii_data[loop_ub] + 80 * idx) + 160 * unnamed_idx_0) - 1];
        }
      }
    }
    idx = ii->size[0];
    b_Auf = *Auf;
    b_ii[0] = idx;
    b_ii[1] = 20;
    b_Auf.size = &b_ii[0];
    b_Auf.numDimensions = 2;
    emxInit_real_T(&y, 2);
    mtimes(&b_Auf, y);
    y_data = y->data;
    emxFree_real_T(&Auf);
    if (y->size[0] != 0) {
      input_sizes_idx_1 = 20;
    } else {
      input_sizes_idx_1 = 0;
    }
    idx = ii->size[0];
    if (y->size[0] != 0) {
      unnamed_idx_0 = 20;
    } else {
      unnamed_idx_0 = 0;
    }
    Au_tmp = ii->size[0];
    i = ref->size[0] * ref->size[1];
    ref->size[0] = ii->size[0];
    ref->size[1] = input_sizes_idx_1 + 31;
    emxEnsureCapacity_real_T(ref, i);
    ref_data = ref->data;
    for (i = 0; i < 30; i++) {
      loop_ub = ii->size[0];
      for (i1 = 0; i1 < loop_ub; i1++) {
        ref_data[i1 + ref->size[0] * i] = 0.0;
      }
    }
    loop_ub = input_sizes_idx_1;
    for (i = 0; i < loop_ub; i++) {
      for (i1 = 0; i1 < idx; i1++) {
        ref_data[i1 + ref->size[0] * (i + 30)] = y_data[i1 + idx * i];
      }
    }
    emxFree_real_T(&y);
    for (i = 0; i < Au_tmp; i++) {
      ref_data[i + ref->size[0] * (unnamed_idx_0 + 30)] = 0.0;
    }
  } else {
    B->size[0] = 0;
    ref->size[0] = 0;
    ref->size[1] = 51;
  }
  emxFree_int8_T(&ii);
  expl_temp.MVIndex[0] = 1.0;
  expl_temp.LastMV[0] = lastMV[0];
  expl_temp.MVIndex[1] = 2.0;
  expl_temp.LastMV[1] = lastMV[1];
  expl_temp.CurrentStates[0] = x[0];
  expl_temp.CurrentStates[1] = x[1];
  expl_temp.CurrentStates[2] = x[2];
  emxInitStruct_struct_T3(&b_expl_temp);
  b_expl_temp.MVIndex[0] = 1.0;
  b_expl_temp.MVIndex[1] = 2.0;
  i = b_expl_temp.MVTarget->size[0] * b_expl_temp.MVTarget->size[1];
  b_expl_temp.MVTarget->size[0] = expl_temp.MVTarget->size[0];
  b_expl_temp.MVTarget->size[1] = expl_temp.MVTarget->size[1];
  emxEnsureCapacity_real_T(b_expl_temp.MVTarget, i);
  loop_ub = expl_temp.MVTarget->size[0] * expl_temp.MVTarget->size[1];
  for (i = 0; i < loop_ub; i++) {
    b_expl_temp.MVTarget->data[i] = expl_temp.MVTarget->data[i];
  }
  i = b_expl_temp.References->size[0] * b_expl_temp.References->size[1];
  b_expl_temp.References->size[0] = expl_temp.References->size[0];
  b_expl_temp.References->size[1] = expl_temp.References->size[1];
  emxEnsureCapacity_real_T(b_expl_temp.References, i);
  loop_ub = expl_temp.References->size[0] * expl_temp.References->size[1];
  for (i = 0; i < loop_ub; i++) {
    b_expl_temp.References->data[i] = expl_temp.References->data[i];
  }
  b_expl_temp.LastMV[0] = lastMV[0];
  b_expl_temp.LastMV[1] = lastMV[1];
  b_expl_temp.CurrentStates[0] = x[0];
  b_expl_temp.CurrentStates[1] = x[1];
  b_expl_temp.CurrentStates[2] = x[2];
  emxInit_real_T(&b_initX, 2);
  i = b_initX->size[0] * b_initX->size[1];
  b_initX->size[0] = initX->size[1];
  b_initX->size[1] = initX->size[0];
  emxEnsureCapacity_real_T(b_initX, i);
  ref_data = b_initX->data;
  loop_ub = initX->size[0];
  for (i = 0; i < loop_ub; i++) {
    idx = initX->size[1];
    for (i1 = 0; i1 < idx; i1++) {
      ref_data[i1 + b_initX->size[0] * i] = initX_data[i + initX->size[0] * i1];
    }
  }
  i = initX->size[0] * initX->size[1];
  initX->size[0] = initMV->size[1];
  initX->size[1] = initMV->size[0];
  emxEnsureCapacity_real_T(initX, i);
  initX_data = initX->data;
  loop_ub = initMV->size[0];
  for (i = 0; i < loop_ub; i++) {
    idx = initMV->size[1];
    for (i1 = 0; i1 < idx; i1++) {
      initX_data[i1 + initX->size[0] * i] =
          initMV_data[i + initMV->size[0] * i1];
    }
  }
  emxFree_real_T(&initMV);
  for (i = 0; i < 20; i++) {
    ic_idx_0 = 0.0;
    for (i1 = 0; i1 < 20; i1++) {
      ic_idx_0 += (real_T)iv[i + 20 * i1] * initX_data[i1];
    }
    b_lastMV[i] = ic_idx_0;
  }
  emxFree_real_T(&initX);
  for (i = 0; i < 30; i++) {
    c_initX[i] = ref_data[i];
  }
  emxFree_real_T(&b_initX);
  memcpy(&c_initX[30], &b_lastMV[0], 20U * sizeof(real_T));
  c_initX[50] = onlinedata->Slack0;
  for (i = 0; i < 30; i++) {
    b_dv[i] = rtMinusInf;
  }
  for (i = 0; i < 20; i++) {
    b_dv[i + 30] = rtMinusInf;
  }
  b_dv[50] = 0.0;
  for (i = 0; i < 30; i++) {
    dv1[i] = rtInf;
  }
  for (i = 0; i < 20; i++) {
    dv1[i + 30] = rtInf;
  }
  dv1[50] = rtInf;
  fmincon(&CostFcn_workspace_runtimedata, &expl_temp, c_initX, ref, B, b_dv,
          dv1, &CostFcn_workspace_runtimedata, &b_expl_temp, z, &info->Cost,
          &ic_idx_1, &Out);
  emxFreeStruct_struct_T3(&b_expl_temp);
  emxFreeStruct_struct_T3(&expl_temp);
  emxFree_real_T(&ref);
  emxFreeStruct_struct_T1(&CostFcn_workspace_runtimedata);
  emxFree_real_T(&B);
  if ((ic_idx_1 == 0.0) && (Out.constrviolation > 1.0E-6)) {
    ic_idx_1 = -2.0;
  }
  memset(&info->Xopt[0], 0, 33U * sizeof(real_T));
  memset(&Umv[0], 0, 22U * sizeof(real_T));
  for (i = 0; i < 20; i++) {
    ic_idx_0 = 0.0;
    for (i1 = 0; i1 < 20; i1++) {
      ic_idx_0 += (real_T)iv[i + 20 * i1] * z[i1 + 30];
    }
    b_lastMV[i] = ic_idx_0;
  }
  for (i = 0; i < 2; i++) {
    for (i1 = 0; i1 < 10; i1++) {
      Umv[i1 + 11 * i] = b_lastMV[i + (i1 << 1)];
    }
  }
  memcpy(&b_x[0], &z[0], 30U * sizeof(real_T));
  for (i = 0; i < 3; i++) {
    for (i1 = 0; i1 < 10; i1++) {
      info->Xopt[(i1 + 11 * i) + 1] = b_x[i + 3 * i1];
    }
    info->Xopt[11 * i] = x[i];
  }
  for (loop_ub = 0; loop_ub < 2; loop_ub++) {
    Umv[11 * loop_ub + 10] = Umv[11 * loop_ub + 9];
    memcpy(&info->MVopt[loop_ub * 11], &Umv[loop_ub * 11],
           11U * sizeof(real_T));
  }
  if (ic_idx_1 > 0.0) {
    mv[0] = info->MVopt[0];
    mv[1] = info->MVopt[11];
  } else {
    mv[0] = lastMV[0];
    mv[1] = lastMV[1];
  }
  info->ExitFlag = ic_idx_1;
  info->Iterations = Out.iterations;
  onlinedata->Slack0 = muDoubleScalarMax(0.0, z[50]);
  memcpy(&info->Yopt[0], &info->Xopt[0], 33U * sizeof(real_T));
  for (i = 0; i < 11; i++) {
    info->Topt[i] = 0.1 * (real_T)i;
  }
  info->Slack = z[50];
  i = onlinedata->X0->size[0] * onlinedata->X0->size[1];
  onlinedata->X0->size[0] = 10;
  onlinedata->X0->size[1] = 3;
  emxEnsureCapacity_real_T(onlinedata->X0, i);
  for (i = 0; i < 3; i++) {
    for (i1 = 0; i1 < 10; i1++) {
      onlinedata->X0->data[i1 + onlinedata->X0->size[0] * i] =
          info->Xopt[b_iv[i1] + 11 * i];
    }
  }
  i = onlinedata->MV0->size[0] * onlinedata->MV0->size[1];
  onlinedata->MV0->size[0] = 10;
  onlinedata->MV0->size[1] = 2;
  emxEnsureCapacity_real_T(onlinedata->MV0, i);
  for (i = 0; i < 2; i++) {
    for (i1 = 0; i1 < 10; i1++) {
      onlinedata->MV0->data[i1 + onlinedata->MV0->size[0] * i] =
          info->MVopt[(i1 + 11 * i) + 1];
    }
  }
  emlrtHeapReferenceStackLeaveFcnR2012b(emlrtRootTLSGlobal);
}

/* End of code generation (nlmpcmoveCodeGeneration.c) */
