%% Animate and Plot the Results for the Parking Manoeuvre

function plotAndAnimateParking(xHistory, uHistory)

xLength = size(xHistory, 1);
uLength = size(uHistory, 1);

if xLength ~= uLength
    xHistory = xHistory';
    uHistory = uHistory';
end

%% Animation of the Parking Manoeuvre

timeLength = size(xHistory, 1);

for ct = 1:timeLength
    helperSLVisualizeParking(xHistory(ct, :), uHistory(ct, 2));
    pause(0.05);
end

%% Plot of the Closed-Loop Response

% Plot of the Vehicle States:
figure()
subplot(311), plot(xHistory(:, 1), 'linewidth', 1.5), grid on
xlabel('Time, $t$ [$s$]', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('$x$ position [$m$]', 'FontSize', 15, 'Interpreter', 'latex')
subplot(312), plot(xHistory(:, 2), 'linewidth', 1.5), grid on
xlabel('Time, $t$ [$s$]', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('$y$ position [$m$]', 'FontSize', 15, 'Interpreter', 'latex')
subplot(313), plot(rad2deg(xHistory(:, 3)), 'linewidth', 1.5), grid on
xlabel('Time, $t$ [$s$]', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('Yaw angle, $\psi$ [$deg$]', 'FontSize', 15, 'Interpreter', 'latex')
sgtitle('\bf Behaviour of the Ego Vehicle States', 'FontSize', 20, 'Interpreter', 'latex')

% Plot of the Vehicle Control Inputs:
figure()
subplot(211), stairs(uHistory(:, 1), 'linewidth', 1.5), grid on
xlabel('Time, $t$ [$s$]', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('Speed, $v$ [$m/s$]', 'FontSize', 15, 'Interpreter', 'latex')
subplot(212), stairs(rad2deg(uHistory(:, 2)), 'linewidth', 1.5), grid on
xlabel('Time, $t$ [$s$]', 'FontSize', 15, 'Interpreter', 'latex')
ylabel('Steering Angle, $\delta$ [$deg$]', 'FontSize', 15, 'Interpreter', 'latex')
sgtitle('\bf Behaviour of the Ego Vehicle Control Inputs', 'FontSize', 20, 'Interpreter', 'latex')
