function [G,Gmv,Ge] = parkingIneqConFcnJacobian(X,U,e,data,ref,Qp,Rp,Qt,Rt,distToCenter,safetyDistance)
%#codegen
% Jacobian of inequality constraints for parking.

% Approximate Jacobian based on http://rll.berkeley.edu/~sachin/papers/Schulman-IJRR2014.pdf

% Copyright 2019 The MathWorks, Inc.

%% Ego and obstacles
persistent obstacles ego

if isempty(obstacles)
    %% Ego car
    vdims = vehicleDimensions;
    egoLength = vdims.Length;
    egoWidth = vdims.Width;
    ego = collisionBox(egoLength,egoWidth,0);
    
    % Obstacles: 2 occupied parking lots, road curbside and yellow line
    obsLength = 6.2;

    % Parked Car 1:
    obs1 = collisionBox(egoWidth, egoLength, 0);
    T1 = trvec2tform([-9.3, -1.75, 0]);
    obs1.Pose = T1;

    % Parked Car 2:
    obs2 = collisionBox(egoWidth, egoLength, 0);
    T2 = trvec2tform([-6.2, -1.75, 0]);
    obs2.Pose = T2;

    % Right Bottom Line:
    obs3 = collisionBox(4*obsLength, 0.5, 0);
    T3 = trvec2tform([11.35, 1.35, 0]);
    obs3.Pose = T3;

    % Parking Vertical Rightmost Line:
    obs4 = collisionBox(0.5, obsLength+1, 0);
    T4 = trvec2tform([-1.3, -2, 0]);
    obs4.Pose = T4;

    % Parking Bottom Line:
    obs5 = collisionBox(10.3, 0.5, 0);
    T5 = trvec2tform([-6.2, -5.35, 0]);
    obs5.Pose = T5;

    % Parking Vertical Leftmost Line:
    obs6 = collisionBox(0.5, obsLength+1, 0);
    T6 = trvec2tform([-11.1, -2, 0]);
    obs6.Pose = T6;

    % Left Bottom Line:
    obs7 = collisionBox(2*obsLength, 0.5, 0);
    T7 = trvec2tform([-17.55, 1.35, 0]);
    obs7.Pose = T7;

    % Other Line:
    obs8 = collisionBox(47.5, 0.5, 0);
    % T8 = trvec2tform([0, 5.35, 0]);
    T8 = trvec2tform([0, 6, 0]);
    obs8.Pose = T8;

    obstacles = {obs1, obs2, obs3, obs4, obs5, obs6, obs7, obs8};
end


%% constraints
hp = data.PredictionHorizon;
numObstacles = numel(obstacles);
Nc = numObstacles * hp;
Nmv = length(data.MVIndex);
Gmv = zeros(hp,Nmv,Nc);
Ge = zeros(Nc,1);
G = zeros(hp,data.NumOfStates,Nc);

iter = 1;
for i =1:hp
    for ct = 1:numObstacles
        % Update ego pose
        x = X(i,1) + distToCenter*cos(X(i,3));
        y = X(i,2) + distToCenter*sin(X(i,3));
        T = trvec2tform([x,y,0]);
        H = axang2tform([0 0 1 X(i,3)]);
        ego.Pose = T*H;
        % Calculate distances from ego to obstacls
        [~, dist, points] = checkCollision(ego,obstacles{ct});
        normal = [0;0];
        if ~isnan(dist)
            if any((points(1:2,1)-points(1:2,2))~=0)% calculate normal vector
                normal = (points(1:2,1)-points(1:2,2))/norm(points(1:2,1)-points(1:2,2));
            end
        end
        %  Approximate Jacobian using ego center point
        kinemJacob = [1 0 -distToCenter*sin(X(i,3));
            0 1 distToCenter*cos(X(i,3))];
        G(i,:,iter) = -normal'*kinemJacob;
        iter = iter+1;
    end
end

end