%% Jacobian of Cost Function for Parking

function [G, Gmv, Ge] = parkingCostJacobian(X, U, e, data, ref, Qp, Rp, ...
    Qt, Rt, distToCenter, safetyDistance)

hp = data.PredictionHorizon;
G = zeros(hp, data.NumOfStates);
Gmv = zeros(hp, length(data.MVIndex));
Ge = 0;

for i = 1:hp
    
    % Running cost Jacobian:
    G(i,:) = 2 * (X(i+1,:) -  ref) * Qp;
    Gmv(i,:) = 2 * U(i,:) * Rp;
end

G(hp,:) = G(hp,:) + 2 * (X(hp+1,:) - ref) * Qt;
Gmv(hp,:) = Gmv(hp,:) + 2 * U(hp,:) * Rt;

end

