%% Cost Function for Parking

function cost = parkingCostFcn(X, U, e, data, ref, Qp, Rp, Qt, Rt, distToCenter, safetyDistance)
   
hp = data.PredictionHorizon;

% Process Cost:
cost = 0;
for idx = 1:hp
    runningCost = (X(idx+1,:) - ref) * Qp * (X(idx+1,:) - ref)' + U(idx,:) * Rp * U(idx,:)';
    cost = cost + runningCost;
end

% Terminal Cost:
terminal_cost = (X(hp+1,:) - ref) * Qt * (X(hp+1,:) - ref)' + U(hp,:) * Rt * U(hp,:)';

% Total Cost
cost = cost + terminal_cost;

end