/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * rotm2quat.c
 *
 * Code generation for function 'rotm2quat'
 *
 */

/* Include files */
#include "rotm2quat.h"
#include "rt_nonfinite.h"
#include "mwmathutil.h"
#include <string.h>

/* Function Definitions */
void rotm2quat(const real_T R[9], real_T q[4])
{
  real_T w;
  real_T x;
  real_T y;
  real_T z;
  w = 0.5 * muDoubleScalarSqrt(muDoubleScalarAbs(((R[0] + R[4]) + R[8]) + 1.0));
  if (w > 1.4901161193847656E-8) {
    real_T m;
    m = 1.0 / (4.0 * w);
    x = m * (R[5] - R[7]);
    y = m * (R[6] - R[2]);
    z = m * (R[1] - R[3]);
  } else {
    x = 0.5 *
        muDoubleScalarSqrt(muDoubleScalarAbs(((R[0] + 1.0) - R[4]) - R[8]));
    if (x > 1.4901161193847656E-8) {
      real_T m;
      m = 1.0 / (4.0 * x);
      y = m * (R[1] + R[3]);
      z = m * (R[2] + R[6]);
      w = m * (R[5] - R[7]);
    } else {
      y = 0.5 *
          muDoubleScalarSqrt(muDoubleScalarAbs(((1.0 - R[0]) + R[4]) - R[8]));
      if (y > 1.4901161193847656E-8) {
        real_T m;
        m = 1.0 / (4.0 * y);
        x = m * (R[1] + R[3]);
        z = m * (R[5] + R[7]);
        w = m * (R[6] - R[2]);
      } else {
        real_T m;
        z = 0.5 *
            muDoubleScalarSqrt(muDoubleScalarAbs(((1.0 - R[0]) - R[4]) + R[8]));
        m = 1.0 / (4.0 * z);
        x = m * (R[2] + R[6]);
        y = m * (R[5] + R[7]);
        w = m * (R[1] - R[3]);
      }
    }
  }
  q[0] = w;
  q[1] = x;
  q[2] = y;
  q[3] = z;
}

/* End of code generation (rotm2quat.c) */
