/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * parkingVehicleStateJacobianFcn.c
 *
 * Code generation for function 'parkingVehicleStateJacobianFcn'
 *
 */

/* Include files */
#include "parkingVehicleStateJacobianFcn.h"
#include "rt_nonfinite.h"
#include "mwmathutil.h"
#include <string.h>

/* Function Definitions */
void parkingVehicleStateJacobianFcn(const real_T x[3], const real_T u[2],
                                    real_T A[9], real_T B[6])
{
  int32_T i;
  /*  Jacobian of model equations for parking. */
  /*  state variables x, y and yaw angle theta. */
  /*  control variables v and steering angle delta. */
  /*  Copyright 2019 The MathWorks, Inc. */
  /*  */
  /*  Parameters */
  /*  Variables */
  /*  Linearize the state equations at the current condition */
  memset(&A[0], 0, 9U * sizeof(real_T));
  for (i = 0; i < 6; i++) {
    B[i] = 0.0;
  }
  real_T A_tmp;
  real_T B_tmp;
  A_tmp = muDoubleScalarSin(x[2]);
  A[6] = -u[0] * A_tmp;
  B_tmp = muDoubleScalarCos(x[2]);
  B[0] = B_tmp;
  A[7] = u[0] * B_tmp;
  B[1] = A_tmp;
  B_tmp = muDoubleScalarTan(u[1]);
  B[2] = 0.35714285714285715 * B_tmp;
  B[5] = 0.35714285714285715 * (u[0] * (B_tmp * B_tmp + 1.0));
}

/* End of code generation (parkingVehicleStateJacobianFcn.c) */
