/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * parkingIneqConFcnJacobian.c
 *
 * Code generation for function 'parkingIneqConFcnJacobian'
 *
 */

/* Include files */
#include "parkingIneqConFcnJacobian.h"
#include "axang2tform.h"
#include "nlmpcmoveCodeGeneration_data.h"
#include "nlmpcmoveCodeGeneration_emxutil.h"
#include "nlmpcmoveCodeGeneration_types.h"
#include "rotm2quat.h"
#include "rt_nonfinite.h"
#include "collisioncodegen_api.hpp"
#include "mwmathutil.h"
#include <string.h>

/* Variable Definitions */
static boolean_T b_obstacles_not_empty;

static collisionBox b_ego;

/* Function Definitions */
void parkingIneqConFcnJacobian(const real_T X[108],
                               real_T data_PredictionHorizon,
                               real_T data_NumOfStates, real_T distToCenter,
                               emxArray_real_T *G, emxArray_real_T *Gmv,
                               emxArray_real_T *Ge)
{
  static collisionBox *obstacles[8];
  void *geometryInternal;
  collisionBox *b_obj;
  collisionBox *c_obj;
  collisionBox *d_obj;
  collisionBox *e_obj;
  collisionBox *f_obj;
  collisionBox *g_obj;
  collisionBox *h_obj;
  collisionBox *obj;
  emxArray_boolean_T *x;
  real_T b_I[16];
  real_T b_dv[6];
  real_T quat_tmp[4];
  real_T *Gmv_data;
  int32_T b_i;
  int32_T ct;
  int32_T i;
  int32_T i1;
  int32_T loop_ub;
  int32_T loop_ub_tmp;
  uint32_T iter;
  boolean_T *x_data;
  emlrtHeapReferenceStackEnterFcnR2012b(emlrtRootTLSGlobal);
  /*  Jacobian of inequality constraints for parking. */
  /*  Approximate Jacobian based on
   * http://rll.berkeley.edu/~sachin/papers/Schulman-IJRR2014.pdf */
  /*  Copyright 2019 The MathWorks, Inc. */
  /*  Ego and obstacles */
  if (!b_obstacles_not_empty) {
    /*     %% Ego car */
    rotm2quat(dv1, quat_tmp);
    b_ego.Position[0] = 0.0;
    b_ego.Position[1] = 0.0;
    b_ego.Position[2] = 0.0;
    b_ego.Quaternion[0] = quat_tmp[0];
    b_ego.Quaternion[1] = quat_tmp[1];
    b_ego.Quaternion[2] = quat_tmp[2];
    b_ego.Quaternion[3] = quat_tmp[3];
    b_ego.GeometryInternal = collisioncodegen_makeBox(4.7, 1.8, 0.0);
    b_ego.matlabCodegenIsDeleted = false;
    /*  Obstacles: 2 occupied parking lots, road curbside and yellow line */
    /*  Parked Car 1: */
    obj = &gobj_2[8];
    obj->Position[0] = 0.0;
    obj->Position[1] = 0.0;
    obj->Position[2] = 0.0;
    obj->Quaternion[0] = quat_tmp[0];
    obj->Quaternion[1] = quat_tmp[1];
    obj->Quaternion[2] = quat_tmp[2];
    obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(1.8, 4.7, 0.0);
    obj->GeometryInternal = geometryInternal;
    obj->matlabCodegenIsDeleted = false;
    obj->Position[0] = -9.3;
    obj->Position[1] = -1.75;
    obj->Position[2] = 0.0;
    obj->Quaternion[0] = quat_tmp[0];
    obj->Quaternion[1] = quat_tmp[1];
    obj->Quaternion[2] = quat_tmp[2];
    obj->Quaternion[3] = quat_tmp[3];
    /*  Parked Car 2: */
    b_obj = &gobj_2[9];
    b_obj->Position[0] = 0.0;
    b_obj->Position[1] = 0.0;
    b_obj->Position[2] = 0.0;
    b_obj->Quaternion[0] = quat_tmp[0];
    b_obj->Quaternion[1] = quat_tmp[1];
    b_obj->Quaternion[2] = quat_tmp[2];
    b_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(1.8, 4.7, 0.0);
    b_obj->GeometryInternal = geometryInternal;
    b_obj->matlabCodegenIsDeleted = false;
    b_obj->Position[0] = -6.2;
    b_obj->Position[1] = -1.75;
    b_obj->Position[2] = 0.0;
    b_obj->Quaternion[0] = quat_tmp[0];
    b_obj->Quaternion[1] = quat_tmp[1];
    b_obj->Quaternion[2] = quat_tmp[2];
    b_obj->Quaternion[3] = quat_tmp[3];
    /*  Right Bottom Line: */
    c_obj = &gobj_2[10];
    c_obj->Position[0] = 0.0;
    c_obj->Position[1] = 0.0;
    c_obj->Position[2] = 0.0;
    c_obj->Quaternion[0] = quat_tmp[0];
    c_obj->Quaternion[1] = quat_tmp[1];
    c_obj->Quaternion[2] = quat_tmp[2];
    c_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(24.8, 0.5, 0.0);
    c_obj->GeometryInternal = geometryInternal;
    c_obj->matlabCodegenIsDeleted = false;
    c_obj->Position[0] = 11.35;
    c_obj->Position[1] = 1.35;
    c_obj->Position[2] = 0.0;
    c_obj->Quaternion[0] = quat_tmp[0];
    c_obj->Quaternion[1] = quat_tmp[1];
    c_obj->Quaternion[2] = quat_tmp[2];
    c_obj->Quaternion[3] = quat_tmp[3];
    /*  Parking Vertical Rightmost Line: */
    d_obj = &gobj_2[11];
    d_obj->Position[0] = 0.0;
    d_obj->Position[1] = 0.0;
    d_obj->Position[2] = 0.0;
    d_obj->Quaternion[0] = quat_tmp[0];
    d_obj->Quaternion[1] = quat_tmp[1];
    d_obj->Quaternion[2] = quat_tmp[2];
    d_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(0.5, 7.2, 0.0);
    d_obj->GeometryInternal = geometryInternal;
    d_obj->matlabCodegenIsDeleted = false;
    d_obj->Position[0] = -1.3;
    d_obj->Position[1] = -2.0;
    d_obj->Position[2] = 0.0;
    d_obj->Quaternion[0] = quat_tmp[0];
    d_obj->Quaternion[1] = quat_tmp[1];
    d_obj->Quaternion[2] = quat_tmp[2];
    d_obj->Quaternion[3] = quat_tmp[3];
    /*  Parking Bottom Line: */
    e_obj = &gobj_2[12];
    e_obj->Position[0] = 0.0;
    e_obj->Position[1] = 0.0;
    e_obj->Position[2] = 0.0;
    e_obj->Quaternion[0] = quat_tmp[0];
    e_obj->Quaternion[1] = quat_tmp[1];
    e_obj->Quaternion[2] = quat_tmp[2];
    e_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(10.3, 0.5, 0.0);
    e_obj->GeometryInternal = geometryInternal;
    e_obj->matlabCodegenIsDeleted = false;
    e_obj->Position[0] = -6.2;
    e_obj->Position[1] = -5.35;
    e_obj->Position[2] = 0.0;
    e_obj->Quaternion[0] = quat_tmp[0];
    e_obj->Quaternion[1] = quat_tmp[1];
    e_obj->Quaternion[2] = quat_tmp[2];
    e_obj->Quaternion[3] = quat_tmp[3];
    /*  Parking Vertical Leftmost Line: */
    f_obj = &gobj_2[13];
    f_obj->Position[0] = 0.0;
    f_obj->Position[1] = 0.0;
    f_obj->Position[2] = 0.0;
    f_obj->Quaternion[0] = quat_tmp[0];
    f_obj->Quaternion[1] = quat_tmp[1];
    f_obj->Quaternion[2] = quat_tmp[2];
    f_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(0.5, 7.2, 0.0);
    f_obj->GeometryInternal = geometryInternal;
    f_obj->matlabCodegenIsDeleted = false;
    f_obj->Position[0] = -11.1;
    f_obj->Position[1] = -2.0;
    f_obj->Position[2] = 0.0;
    f_obj->Quaternion[0] = quat_tmp[0];
    f_obj->Quaternion[1] = quat_tmp[1];
    f_obj->Quaternion[2] = quat_tmp[2];
    f_obj->Quaternion[3] = quat_tmp[3];
    /*  Left Bottom Line: */
    g_obj = &gobj_2[14];
    g_obj->Position[0] = 0.0;
    g_obj->Position[1] = 0.0;
    g_obj->Position[2] = 0.0;
    g_obj->Quaternion[0] = quat_tmp[0];
    g_obj->Quaternion[1] = quat_tmp[1];
    g_obj->Quaternion[2] = quat_tmp[2];
    g_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(12.4, 0.5, 0.0);
    g_obj->GeometryInternal = geometryInternal;
    g_obj->matlabCodegenIsDeleted = false;
    g_obj->Position[0] = -17.55;
    g_obj->Position[1] = 1.35;
    g_obj->Position[2] = 0.0;
    g_obj->Quaternion[0] = quat_tmp[0];
    g_obj->Quaternion[1] = quat_tmp[1];
    g_obj->Quaternion[2] = quat_tmp[2];
    g_obj->Quaternion[3] = quat_tmp[3];
    /*  Other Line: */
    h_obj = &gobj_2[15];
    h_obj->Position[0] = 0.0;
    h_obj->Position[1] = 0.0;
    h_obj->Position[2] = 0.0;
    h_obj->Quaternion[0] = quat_tmp[0];
    h_obj->Quaternion[1] = quat_tmp[1];
    h_obj->Quaternion[2] = quat_tmp[2];
    h_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(47.5, 0.5, 0.0);
    h_obj->GeometryInternal = geometryInternal;
    h_obj->matlabCodegenIsDeleted = false;
    /*  T8 = trvec2tform([0, 5.35, 0]); */
    h_obj->Position[0] = 0.0;
    h_obj->Position[1] = 6.0;
    h_obj->Position[2] = 0.0;
    h_obj->Quaternion[0] = quat_tmp[0];
    h_obj->Quaternion[1] = quat_tmp[1];
    h_obj->Quaternion[2] = quat_tmp[2];
    h_obj->Quaternion[3] = quat_tmp[3];
    obstacles[0] = obj;
    obstacles[1] = b_obj;
    obstacles[2] = c_obj;
    obstacles[3] = d_obj;
    obstacles[4] = e_obj;
    obstacles[5] = f_obj;
    obstacles[6] = g_obj;
    obstacles[7] = h_obj;
    b_obstacles_not_empty = true;
  }
  /*  constraints */
  i = (int32_T)data_PredictionHorizon;
  i1 = Gmv->size[0] * Gmv->size[1] * Gmv->size[2];
  Gmv->size[0] = (int32_T)data_PredictionHorizon;
  Gmv->size[1] = 2;
  loop_ub_tmp = (int32_T)(8.0 * data_PredictionHorizon);
  Gmv->size[2] = loop_ub_tmp;
  emxEnsureCapacity_real_T(Gmv, i1);
  Gmv_data = Gmv->data;
  loop_ub = ((int32_T)data_PredictionHorizon << 1) * loop_ub_tmp;
  for (i1 = 0; i1 < loop_ub; i1++) {
    Gmv_data[i1] = 0.0;
  }
  i1 = Ge->size[0];
  Ge->size[0] = loop_ub_tmp;
  emxEnsureCapacity_real_T(Ge, i1);
  Gmv_data = Ge->data;
  for (i1 = 0; i1 < loop_ub_tmp; i1++) {
    Gmv_data[i1] = 0.0;
  }
  i1 = G->size[0] * G->size[1] * G->size[2];
  G->size[0] = (int32_T)data_PredictionHorizon;
  G->size[1] = (int32_T)data_NumOfStates;
  G->size[2] = loop_ub_tmp;
  emxEnsureCapacity_real_T(G, i1);
  Gmv_data = G->data;
  loop_ub =
      (int32_T)data_PredictionHorizon * (int32_T)data_NumOfStates * loop_ub_tmp;
  for (i1 = 0; i1 < loop_ub; i1++) {
    Gmv_data[i1] = 0.0;
  }
  iter = 1U;
  if ((int32_T)data_PredictionHorizon - 1 >= 0) {
    b_dv[0] = 1.0;
    b_dv[2] = 0.0;
    b_dv[1] = 0.0;
    b_dv[3] = 1.0;
  }
  emxInit_boolean_T(&x);
  for (b_i = 0; b_i < i; b_i++) {
    real_T d;
    real_T y_tmp;
    real_T y_tmp_tmp;
    y_tmp_tmp = X[b_i + 72];
    y_tmp = muDoubleScalarSin(y_tmp_tmp);
    b_dv[4] = -distToCenter * y_tmp;
    d = distToCenter * muDoubleScalarCos(y_tmp_tmp);
    b_dv[5] = d;
    for (ct = 0; ct < 8; ct++) {
      real_T H[16];
      real_T tform[16];
      real_T b_tform[9];
      real_T witnessPts[6];
      real_T position1[3];
      real_T absxk;
      real_T normal_idx_0;
      real_T normal_idx_1;
      real_T scale;
      /*  Update ego pose */
      memset(&b_I[0], 0, 16U * sizeof(real_T));
      b_I[0] = 1.0;
      b_I[5] = 1.0;
      b_I[10] = 1.0;
      b_I[15] = 1.0;
      for (loop_ub = 0; loop_ub < 4; loop_ub++) {
        loop_ub_tmp = loop_ub << 2;
        H[loop_ub_tmp] = b_I[loop_ub_tmp];
        H[loop_ub_tmp + 1] = b_I[loop_ub_tmp + 1];
        H[loop_ub_tmp + 2] = b_I[loop_ub_tmp + 2];
        H[loop_ub_tmp + 3] = b_I[loop_ub_tmp + 3];
      }
      H[12] = X[b_i] + d;
      H[13] = X[b_i + 36] + distToCenter * y_tmp;
      H[14] = 0.0;
      quat_tmp[0] = 0.0;
      quat_tmp[1] = 0.0;
      quat_tmp[2] = 1.0;
      quat_tmp[3] = y_tmp_tmp;
      axang2tform(quat_tmp, b_I);
      for (i1 = 0; i1 < 4; i1++) {
        normal_idx_1 = H[i1];
        absxk = H[i1 + 4];
        normal_idx_0 = H[i1 + 8];
        scale = H[i1 + 12];
        for (loop_ub = 0; loop_ub < 4; loop_ub++) {
          loop_ub_tmp = loop_ub << 2;
          tform[i1 + loop_ub_tmp] = ((normal_idx_1 * b_I[loop_ub_tmp] +
                                      absxk * b_I[loop_ub_tmp + 1]) +
                                     normal_idx_0 * b_I[loop_ub_tmp + 2]) +
                                    scale * b_I[loop_ub_tmp + 3];
        }
      }
      /*  Calculate distances from ego to obstacls */
      for (i1 = 0; i1 < 3; i1++) {
        normal_idx_1 = tform[i1 + 12] / tform[15];
        b_ego.Position[i1] = normal_idx_1;
        loop_ub_tmp = i1 << 2;
        b_tform[3 * i1] = tform[loop_ub_tmp];
        b_tform[3 * i1 + 1] = tform[loop_ub_tmp + 1];
        b_tform[3 * i1 + 2] = tform[loop_ub_tmp + 2];
        position1[i1] = normal_idx_1;
      }
      real_T quaternion2[4];
      real_T p1Vec[3];
      real_T p2Vec[3];
      real_T position2[3];
      rotm2quat(b_tform, b_ego.Quaternion);
      quat_tmp[0] = b_ego.Quaternion[0];
      quat_tmp[1] = b_ego.Quaternion[1];
      quat_tmp[2] = b_ego.Quaternion[2];
      quat_tmp[3] = b_ego.Quaternion[3];
      geometryInternal = obstacles[ct]->GeometryInternal;
      position2[0] = obstacles[ct]->Position[0];
      position2[1] = obstacles[ct]->Position[1];
      position2[2] = obstacles[ct]->Position[2];
      quaternion2[0] = obstacles[ct]->Quaternion[0];
      quaternion2[1] = obstacles[ct]->Quaternion[1];
      quaternion2[2] = obstacles[ct]->Quaternion[2];
      quaternion2[3] = obstacles[ct]->Quaternion[3];
      absxk = 0.0;
      p1Vec[0] = 0.0;
      p2Vec[0] = 0.0;
      p1Vec[1] = 0.0;
      p2Vec[1] = 0.0;
      p1Vec[2] = 0.0;
      p2Vec[2] = 0.0;
      normal_idx_1 = collisioncodegen_intersect(
          b_ego.GeometryInternal, &position1[0], &quat_tmp[0], geometryInternal,
          &position2[0], &quaternion2[0], 1.0, &p1Vec[0], &p2Vec[0], &absxk);
      witnessPts[0] = p1Vec[0];
      witnessPts[3] = p2Vec[0];
      witnessPts[1] = p1Vec[1];
      witnessPts[4] = p2Vec[1];
      if (normal_idx_1 != 0.0) {
        absxk = rtNaN;
        for (i1 = 0; i1 < 6; i1++) {
          witnessPts[i1] = rtNaN;
        }
      }
      normal_idx_0 = 0.0;
      normal_idx_1 = 0.0;
      if (!muDoubleScalarIsNaN(absxk)) {
        real_T x_tmp_idx_0;
        real_T x_tmp_idx_1;
        boolean_T exitg1;
        boolean_T y;
        i1 = x->size[0];
        x->size[0] = 2;
        emxEnsureCapacity_boolean_T(x, i1);
        x_data = x->data;
        x_tmp_idx_1 = witnessPts[0] - witnessPts[3];
        x_tmp_idx_0 = x_tmp_idx_1;
        x_data[0] = (x_tmp_idx_1 != 0.0);
        x_tmp_idx_1 = witnessPts[1] - witnessPts[4];
        x_data[1] = (x_tmp_idx_1 != 0.0);
        y = false;
        loop_ub_tmp = 0;
        exitg1 = false;
        while ((!exitg1) && (loop_ub_tmp <= 1)) {
          if (x_data[loop_ub_tmp]) {
            y = true;
            exitg1 = true;
          } else {
            loop_ub_tmp++;
          }
        }
        if (y) {
          real_T b_y;
          /*  calculate normal vector */
          scale = 3.3121686421112381E-170;
          absxk = muDoubleScalarAbs(x_tmp_idx_0);
          if (absxk > 3.3121686421112381E-170) {
            b_y = 1.0;
            scale = absxk;
          } else {
            normal_idx_1 = absxk / 3.3121686421112381E-170;
            b_y = normal_idx_1 * normal_idx_1;
          }
          absxk = muDoubleScalarAbs(x_tmp_idx_1);
          if (absxk > scale) {
            normal_idx_1 = scale / absxk;
            b_y = b_y * normal_idx_1 * normal_idx_1 + 1.0;
            scale = absxk;
          } else {
            normal_idx_1 = absxk / scale;
            b_y += normal_idx_1 * normal_idx_1;
          }
          b_y = scale * muDoubleScalarSqrt(b_y);
          normal_idx_0 = x_tmp_idx_0 / b_y;
          normal_idx_1 = x_tmp_idx_1 / b_y;
        }
      }
      /*   Approximate Jacobian using ego center point */
      for (i1 = 0; i1 < 3; i1++) {
        loop_ub = i1 << 1;
        position1[i1] =
            -normal_idx_0 * b_dv[loop_ub] + -normal_idx_1 * b_dv[loop_ub + 1];
      }
      loop_ub = G->size[1];
      for (i1 = 0; i1 < loop_ub; i1++) {
        Gmv_data[(b_i + G->size[0] * i1) +
                 G->size[0] * G->size[1] * ((int32_T)iter - 1)] = position1[i1];
      }
      iter++;
    }
  }
  emxFree_boolean_T(&x);
  emlrtHeapReferenceStackLeaveFcnR2012b(emlrtRootTLSGlobal);
}

void parkingIneqConFcnJacobian_free(void)
{
  collisionBox *obj;
  int32_T i;
  if (!b_ego.matlabCodegenIsDeleted) {
    b_ego.matlabCodegenIsDeleted = true;
    collisioncodegen_destructGeometry(&b_ego.GeometryInternal);
  }
  for (i = 0; i < 16; i++) {
    obj = &gobj_2[i];
    if (!obj->matlabCodegenIsDeleted) {
      void *geometryInternal;
      obj->matlabCodegenIsDeleted = true;
      geometryInternal = obj->GeometryInternal;
      collisioncodegen_destructGeometry(&geometryInternal);
    }
  }
}

void parkingIneqConFcnJacobian_init(void)
{
  int32_T i;
  b_obstacles_not_empty = false;
  for (i = 0; i < 16; i++) {
    gobj_2[i].matlabCodegenIsDeleted = true;
  }
  b_ego.matlabCodegenIsDeleted = true;
}

/* End of code generation (parkingIneqConFcnJacobian.c) */
