/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * parkingIneqConFcn.c
 *
 * Code generation for function 'parkingIneqConFcn'
 *
 */

/* Include files */
#include "parkingIneqConFcn.h"
#include "axang2tform.h"
#include "nlmpcmoveCodeGeneration_data.h"
#include "nlmpcmoveCodeGeneration_emxutil.h"
#include "nlmpcmoveCodeGeneration_types.h"
#include "rotm2quat.h"
#include "rt_nonfinite.h"
#include "collisioncodegen_api.hpp"
#include "mwmathutil.h"
#include <string.h>

/* Variable Definitions */
static boolean_T obstacles_not_empty;

static collisionBox ego;

/* Function Definitions */
void parkingIneqConFcn(const real_T X[108], real_T data_PredictionHorizon,
                       real_T distToCenter, real_T safetyDistance,
                       emxArray_real_T *cineq)
{
  static collisionBox *obstacles[8];
  void *geometryInternal;
  collisionBox *b_obj;
  collisionBox *c_obj;
  collisionBox *d_obj;
  collisionBox *e_obj;
  collisionBox *f_obj;
  collisionBox *g_obj;
  collisionBox *h_obj;
  collisionBox *obj;
  real_T b_I[16];
  real_T distances[8];
  real_T quat_tmp[4];
  real_T *cineq_data;
  int32_T b_i;
  int32_T i;
  int32_T i1;
  int32_T i2;
  int32_T jcol;
  int32_T loop_ub;
  /*  Inequality Constraints for Parking */
  /*  Ego and Obstacles: */
  if (!obstacles_not_empty) {
    /*  Ego: */
    rotm2quat(dv1, quat_tmp);
    ego.Position[0] = 0.0;
    ego.Position[1] = 0.0;
    ego.Position[2] = 0.0;
    ego.Quaternion[0] = quat_tmp[0];
    ego.Quaternion[1] = quat_tmp[1];
    ego.Quaternion[2] = quat_tmp[2];
    ego.Quaternion[3] = quat_tmp[3];
    ego.GeometryInternal = collisioncodegen_makeBox(4.7, 1.8, 0.0);
    ego.matlabCodegenIsDeleted = false;
    /*  Obstacles: */
    /*  Parked Car 1: */
    obj = &gobj_2[0];
    obj->Position[0] = 0.0;
    obj->Position[1] = 0.0;
    obj->Position[2] = 0.0;
    obj->Quaternion[0] = quat_tmp[0];
    obj->Quaternion[1] = quat_tmp[1];
    obj->Quaternion[2] = quat_tmp[2];
    obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(1.8, 4.7, 0.0);
    obj->GeometryInternal = geometryInternal;
    obj->matlabCodegenIsDeleted = false;
    obj->Position[0] = -9.3;
    obj->Position[1] = -1.75;
    obj->Position[2] = 0.0;
    obj->Quaternion[0] = quat_tmp[0];
    obj->Quaternion[1] = quat_tmp[1];
    obj->Quaternion[2] = quat_tmp[2];
    obj->Quaternion[3] = quat_tmp[3];
    /*  Parked Car 2: */
    b_obj = &gobj_2[1];
    b_obj->Position[0] = 0.0;
    b_obj->Position[1] = 0.0;
    b_obj->Position[2] = 0.0;
    b_obj->Quaternion[0] = quat_tmp[0];
    b_obj->Quaternion[1] = quat_tmp[1];
    b_obj->Quaternion[2] = quat_tmp[2];
    b_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(1.8, 4.7, 0.0);
    b_obj->GeometryInternal = geometryInternal;
    b_obj->matlabCodegenIsDeleted = false;
    b_obj->Position[0] = -6.2;
    b_obj->Position[1] = -1.75;
    b_obj->Position[2] = 0.0;
    b_obj->Quaternion[0] = quat_tmp[0];
    b_obj->Quaternion[1] = quat_tmp[1];
    b_obj->Quaternion[2] = quat_tmp[2];
    b_obj->Quaternion[3] = quat_tmp[3];
    /*  Right Bottom Line: */
    c_obj = &gobj_2[2];
    c_obj->Position[0] = 0.0;
    c_obj->Position[1] = 0.0;
    c_obj->Position[2] = 0.0;
    c_obj->Quaternion[0] = quat_tmp[0];
    c_obj->Quaternion[1] = quat_tmp[1];
    c_obj->Quaternion[2] = quat_tmp[2];
    c_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(24.8, 0.5, 0.0);
    c_obj->GeometryInternal = geometryInternal;
    c_obj->matlabCodegenIsDeleted = false;
    c_obj->Position[0] = 11.35;
    c_obj->Position[1] = 1.35;
    c_obj->Position[2] = 0.0;
    c_obj->Quaternion[0] = quat_tmp[0];
    c_obj->Quaternion[1] = quat_tmp[1];
    c_obj->Quaternion[2] = quat_tmp[2];
    c_obj->Quaternion[3] = quat_tmp[3];
    /*  Parking Vertical Rightmost Line: */
    d_obj = &gobj_2[3];
    d_obj->Position[0] = 0.0;
    d_obj->Position[1] = 0.0;
    d_obj->Position[2] = 0.0;
    d_obj->Quaternion[0] = quat_tmp[0];
    d_obj->Quaternion[1] = quat_tmp[1];
    d_obj->Quaternion[2] = quat_tmp[2];
    d_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(0.5, 7.2, 0.0);
    d_obj->GeometryInternal = geometryInternal;
    d_obj->matlabCodegenIsDeleted = false;
    d_obj->Position[0] = -1.3;
    d_obj->Position[1] = -2.0;
    d_obj->Position[2] = 0.0;
    d_obj->Quaternion[0] = quat_tmp[0];
    d_obj->Quaternion[1] = quat_tmp[1];
    d_obj->Quaternion[2] = quat_tmp[2];
    d_obj->Quaternion[3] = quat_tmp[3];
    /*  Parking Bottom Line: */
    e_obj = &gobj_2[4];
    e_obj->Position[0] = 0.0;
    e_obj->Position[1] = 0.0;
    e_obj->Position[2] = 0.0;
    e_obj->Quaternion[0] = quat_tmp[0];
    e_obj->Quaternion[1] = quat_tmp[1];
    e_obj->Quaternion[2] = quat_tmp[2];
    e_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(10.3, 0.5, 0.0);
    e_obj->GeometryInternal = geometryInternal;
    e_obj->matlabCodegenIsDeleted = false;
    e_obj->Position[0] = -6.2;
    e_obj->Position[1] = -5.35;
    e_obj->Position[2] = 0.0;
    e_obj->Quaternion[0] = quat_tmp[0];
    e_obj->Quaternion[1] = quat_tmp[1];
    e_obj->Quaternion[2] = quat_tmp[2];
    e_obj->Quaternion[3] = quat_tmp[3];
    /*  Parking Vertical Leftmost Line: */
    f_obj = &gobj_2[5];
    f_obj->Position[0] = 0.0;
    f_obj->Position[1] = 0.0;
    f_obj->Position[2] = 0.0;
    f_obj->Quaternion[0] = quat_tmp[0];
    f_obj->Quaternion[1] = quat_tmp[1];
    f_obj->Quaternion[2] = quat_tmp[2];
    f_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(0.5, 7.2, 0.0);
    f_obj->GeometryInternal = geometryInternal;
    f_obj->matlabCodegenIsDeleted = false;
    f_obj->Position[0] = -11.1;
    f_obj->Position[1] = -2.0;
    f_obj->Position[2] = 0.0;
    f_obj->Quaternion[0] = quat_tmp[0];
    f_obj->Quaternion[1] = quat_tmp[1];
    f_obj->Quaternion[2] = quat_tmp[2];
    f_obj->Quaternion[3] = quat_tmp[3];
    /*  Left Bottom Line: */
    g_obj = &gobj_2[6];
    g_obj->Position[0] = 0.0;
    g_obj->Position[1] = 0.0;
    g_obj->Position[2] = 0.0;
    g_obj->Quaternion[0] = quat_tmp[0];
    g_obj->Quaternion[1] = quat_tmp[1];
    g_obj->Quaternion[2] = quat_tmp[2];
    g_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(12.4, 0.5, 0.0);
    g_obj->GeometryInternal = geometryInternal;
    g_obj->matlabCodegenIsDeleted = false;
    g_obj->Position[0] = -17.55;
    g_obj->Position[1] = 1.35;
    g_obj->Position[2] = 0.0;
    g_obj->Quaternion[0] = quat_tmp[0];
    g_obj->Quaternion[1] = quat_tmp[1];
    g_obj->Quaternion[2] = quat_tmp[2];
    g_obj->Quaternion[3] = quat_tmp[3];
    /*  Other Line: */
    h_obj = &gobj_2[7];
    h_obj->Position[0] = 0.0;
    h_obj->Position[1] = 0.0;
    h_obj->Position[2] = 0.0;
    h_obj->Quaternion[0] = quat_tmp[0];
    h_obj->Quaternion[1] = quat_tmp[1];
    h_obj->Quaternion[2] = quat_tmp[2];
    h_obj->Quaternion[3] = quat_tmp[3];
    geometryInternal = collisioncodegen_makeBox(47.5, 0.5, 0.0);
    h_obj->GeometryInternal = geometryInternal;
    h_obj->matlabCodegenIsDeleted = false;
    /*  T8 = trvec2tform([0, 5.35, 0]); */
    h_obj->Position[0] = 0.0;
    h_obj->Position[1] = 6.0;
    h_obj->Position[2] = 0.0;
    h_obj->Quaternion[0] = quat_tmp[0];
    h_obj->Quaternion[1] = quat_tmp[1];
    h_obj->Quaternion[2] = quat_tmp[2];
    h_obj->Quaternion[3] = quat_tmp[3];
    obstacles[0] = obj;
    obstacles[1] = b_obj;
    obstacles[2] = c_obj;
    obstacles[3] = d_obj;
    obstacles[4] = e_obj;
    obstacles[5] = f_obj;
    obstacles[6] = g_obj;
    obstacles[7] = h_obj;
    obstacles_not_empty = true;
  }
  /*  Constraints: */
  loop_ub = (int32_T)(data_PredictionHorizon * 8.0);
  i = cineq->size[0];
  cineq->size[0] = loop_ub;
  emxEnsureCapacity_real_T(cineq, i);
  cineq_data = cineq->data;
  for (i = 0; i < loop_ub; i++) {
    cineq_data[i] = 0.0;
  }
  i = (int32_T)data_PredictionHorizon;
  for (b_i = 0; b_i < i; b_i++) {
    real_T H[16];
    real_T tform[16];
    real_T b_tform[9];
    real_T H_tmp;
    real_T collisionStatus;
    /*  Update Ego Position: */
    memset(&b_I[0], 0, 16U * sizeof(real_T));
    b_I[0] = 1.0;
    b_I[5] = 1.0;
    b_I[10] = 1.0;
    b_I[15] = 1.0;
    for (jcol = 0; jcol < 4; jcol++) {
      loop_ub = jcol << 2;
      H[loop_ub] = b_I[loop_ub];
      H[loop_ub + 1] = b_I[loop_ub + 1];
      H[loop_ub + 2] = b_I[loop_ub + 2];
      H[loop_ub + 3] = b_I[loop_ub + 3];
    }
    H_tmp = X[b_i + 72];
    H[12] = X[b_i] + distToCenter * muDoubleScalarCos(H_tmp);
    H[13] = X[b_i + 36] + distToCenter * muDoubleScalarSin(H_tmp);
    H[14] = 0.0;
    quat_tmp[0] = 0.0;
    quat_tmp[1] = 0.0;
    quat_tmp[2] = 1.0;
    quat_tmp[3] = H_tmp;
    axang2tform(quat_tmp, b_I);
    for (i1 = 0; i1 < 4; i1++) {
      real_T d;
      real_T d1;
      H_tmp = H[i1];
      collisionStatus = H[i1 + 4];
      d = H[i1 + 8];
      d1 = H[i1 + 12];
      for (i2 = 0; i2 < 4; i2++) {
        loop_ub = i2 << 2;
        tform[i1 + loop_ub] =
            ((H_tmp * b_I[loop_ub] + collisionStatus * b_I[loop_ub + 1]) +
             d * b_I[loop_ub + 2]) +
            d1 * b_I[loop_ub + 3];
      }
    }
    for (i1 = 0; i1 < 3; i1++) {
      ego.Position[i1] = tform[i1 + 12] / tform[15];
      loop_ub = i1 << 2;
      b_tform[3 * i1] = tform[loop_ub];
      b_tform[3 * i1 + 1] = tform[loop_ub + 1];
      b_tform[3 * i1 + 2] = tform[loop_ub + 2];
    }
    rotm2quat(b_tform, ego.Quaternion);
    /*  Calculate distances from ego to obstacles */
    memset(&distances[0], 0, 8U * sizeof(real_T));
    H_tmp = (((real_T)b_i + 1.0) - 1.0) * 8.0 + 1.0;
    collisionStatus = 8.0 * ((real_T)b_i + 1.0);
    if (H_tmp > collisionStatus) {
      i1 = 0;
      i2 = 0;
    } else {
      i1 = (int32_T)H_tmp - 1;
      i2 = (int32_T)collisionStatus;
    }
    loop_ub = i2 - i1;
    for (jcol = 0; jcol < 8; jcol++) {
      real_T quaternion2[4];
      real_T p1Vec[3];
      real_T p2Vec[3];
      real_T position1[3];
      real_T position2[3];
      position1[0] = ego.Position[0];
      position1[1] = ego.Position[1];
      position1[2] = ego.Position[2];
      quat_tmp[0] = ego.Quaternion[0];
      quat_tmp[1] = ego.Quaternion[1];
      quat_tmp[2] = ego.Quaternion[2];
      quat_tmp[3] = ego.Quaternion[3];
      geometryInternal = obstacles[jcol]->GeometryInternal;
      position2[0] = obstacles[jcol]->Position[0];
      position2[1] = obstacles[jcol]->Position[1];
      position2[2] = obstacles[jcol]->Position[2];
      quaternion2[0] = obstacles[jcol]->Quaternion[0];
      quaternion2[1] = obstacles[jcol]->Quaternion[1];
      quaternion2[2] = obstacles[jcol]->Quaternion[2];
      quaternion2[3] = obstacles[jcol]->Quaternion[3];
      H_tmp = 0.0;
      p1Vec[0] = 0.0;
      p2Vec[0] = 0.0;
      p1Vec[1] = 0.0;
      p2Vec[1] = 0.0;
      p1Vec[2] = 0.0;
      p2Vec[2] = 0.0;
      collisionStatus = collisioncodegen_intersect(
          ego.GeometryInternal, &position1[0], &quat_tmp[0], geometryInternal,
          &position2[0], &quaternion2[0], 1.0, &p1Vec[0], &p2Vec[0], &H_tmp);
      if (collisionStatus != 0.0) {
        H_tmp = rtNaN;
      }
      distances[jcol] = muDoubleScalarMax(H_tmp, -10.0);
      /*  dist is nan when collided. */
      for (i2 = 0; i2 < loop_ub; i2++) {
        cineq_data[i1 + i2] = distances[i2];
      }
    }
  }
  loop_ub = cineq->size[0];
  for (i = 0; i < loop_ub; i++) {
    cineq_data[i] = -cineq_data[i] + safetyDistance;
  }
}

void parkingIneqConFcn_free(void)
{
  if (!ego.matlabCodegenIsDeleted) {
    ego.matlabCodegenIsDeleted = true;
    collisioncodegen_destructGeometry(&ego.GeometryInternal);
  }
}

void parkingIneqConFcn_init(void)
{
  obstacles_not_empty = false;
  ego.matlabCodegenIsDeleted = true;
}

/* End of code generation (parkingIneqConFcn.c) */
