/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * nlmpcmoveCodeGeneration.c
 *
 * Code generation for function 'nlmpcmoveCodeGeneration'
 *
 */

/* Include files */
#include "nlmpcmoveCodeGeneration.h"
#include "fmincon.h"
#include "mtimes.h"
#include "nlmpcmoveCodeGeneration_data.h"
#include "nlmpcmoveCodeGeneration_emxutil.h"
#include "nlmpcmoveCodeGeneration_internal_types.h"
#include "nlmpcmoveCodeGeneration_types.h"
#include "parkingIneqConFcn.h"
#include "parkingIneqConFcnJacobian.h"
#include "parkingVehicleStateJacobianFcn.h"
#include "rt_nonfinite.h"
#include "znlmpc_confun.h"
#include "znlmpc_getXUe.h"
#include "blas.h"
#include "mwmathutil.h"
#include <stddef.h>
#include <string.h>

/* Function Definitions */
void c_nlmpcmoveCodeGeneration_anonF(
    c_nlmpcmoveCodeGenerationStackD *SD, const real_T runtimedata_x[3],
    const real_T runtimedata_OutputMin[105],
    const real_T runtimedata_OutputMax[105], real_T runtimedata_Parameters_f6,
    real_T runtimedata_Parameters_f7, real_T userdata_PredictionHorizon,
    real_T userdata_NumOfStates, const real_T z[176],
    emxArray_real_T *varargout_1, real_T varargout_2[105],
    emxArray_real_T *varargout_3, real_T varargout_4[18480])
{
  ptrdiff_t k_t;
  ptrdiff_t lda_t;
  ptrdiff_t ldb_t;
  ptrdiff_t ldc_t;
  ptrdiff_t m_t;
  ptrdiff_t n_t;
  emxArray_real_T *Jc;
  emxArray_real_T *Jcu;
  emxArray_real_T *Je;
  emxArray_real_T *Ju;
  emxArray_real_T *Jx;
  emxArray_real_T *a;
  emxArray_real_T *b;
  emxArray_real_T *b_Je;
  emxArray_real_T *b_b;
  emxArray_real_T *b_varargin_2;
  emxArray_real_T *b_y;
  emxArray_real_T *c;
  emxArray_real_T *cu;
  real_T y[7350];
  real_T X[108];
  real_T b_X[108];
  real_T U[72];
  real_T b_U[72];
  real_T alpha1;
  real_T beta1;
  real_T e;
  real_T *Jc_data;
  real_T *Jcu_data;
  real_T *Je_data;
  real_T *Ju_data;
  real_T *Jx_data;
  real_T *a_data;
  real_T *b_data;
  real_T *c_data;
  real_T *cu_data;
  int32_T b_i;
  int32_T i;
  int32_T i4;
  int32_T input_sizes_idx_0;
  int32_T k;
  int32_T plast;
  int32_T subsa_idx_1;
  int32_T subsa_idx_2;
  char_T TRANSA1;
  char_T TRANSB1;
  int8_T ic[3];
  boolean_T empty_non_axis_sizes;
  emlrtHeapReferenceStackEnterFcnR2012b(emlrtRootTLSGlobal);
  znlmpc_getXUe(z, runtimedata_x, X, U, &e);
  memset(&SD->f0.Jx[0], 0, 11025U * sizeof(real_T));
  memset(&SD->f0.Jmv[0], 0, 7350U * sizeof(real_T));
  memset(&varargout_2[0], 0, 105U * sizeof(real_T));
  ic[0] = 1;
  ic[1] = 2;
  ic[2] = 3;
  for (i = 0; i < 36; i++) {
    plast = i << 1;
    b_U[plast] = U[i];
    b_U[plast + 1] = U[i + 36];
    b_X[3 * i] = X[i];
    b_X[3 * i + 1] = X[i + 36];
    b_X[3 * i + 2] = X[i + 72];
  }
  for (b_i = 0; b_i < 35; b_i++) {
    real_T Ak[9];
    real_T Ak1[9];
    real_T Bk1[6];
    real_T val[6];
    real_T fk1_idx_0_tmp;
    real_T fk_idx_2_tmp;
    int8_T i1;
    int8_T i2;
    int8_T i3;
    /*  State equations for parking:  */
    /*  state variables x, y and yaw angle theta. */
    /*  control variables v and steering angle delta. */
    /*  Copyright 2019 The MathWorks, Inc. */
    /*  */
    /*  Parameters */
    /*  Variables */
    /*  State equations */
    plast = b_i << 1;
    alpha1 = b_X[3 * b_i + 2];
    beta1 = b_U[plast];
    fk_idx_2_tmp = beta1 / 2.8 * muDoubleScalarTan(b_U[plast + 1]);
    parkingVehicleStateJacobianFcn(&b_X[3 * b_i], &b_U[b_i << 1], Ak, val);
    /*  State equations for parking:  */
    /*  state variables x, y and yaw angle theta. */
    /*  control variables v and steering angle delta. */
    /*  Copyright 2019 The MathWorks, Inc. */
    /*  */
    /*  Parameters */
    /*  Variables */
    /*  State equations */
    plast = 3 * (b_i + 1);
    fk1_idx_0_tmp = b_X[plast + 2];
    parkingVehicleStateJacobianFcn(&b_X[3 * (b_i + 1)], &b_U[b_i << 1], Ak1,
                                   Bk1);
    varargout_2[ic[0] - 1] =
        (b_X[3 * b_i] + 0.125 * (beta1 * muDoubleScalarCos(alpha1) +
                                 beta1 * muDoubleScalarCos(fk1_idx_0_tmp))) -
        b_X[plast];
    varargout_2[ic[1] - 1] =
        (b_X[3 * b_i + 1] +
         0.125 * (beta1 * muDoubleScalarSin(alpha1) +
                  beta1 * muDoubleScalarSin(fk1_idx_0_tmp))) -
        b_X[plast + 1];
    varargout_2[ic[2] - 1] =
        (alpha1 + 0.125 * (fk_idx_2_tmp + fk_idx_2_tmp)) - fk1_idx_0_tmp;
    if (b_i + 1 > 1) {
      plast = 315 * (b_i - 1);
      for (k = 0; k < 3; k++) {
        SD->f0.Jx[((ic[0] + 105 * k) + plast) - 1] = 0.125 * Ak[3 * k];
        SD->f0.Jx[((ic[1] + 105 * k) + plast) - 1] = 0.125 * Ak[3 * k + 1];
        SD->f0.Jx[((ic[2] + 105 * k) + plast) - 1] = 0.125 * Ak[3 * k + 2];
        input_sizes_idx_0 = ((ic[k] + 105 * k) + plast) - 1;
        SD->f0.Jx[input_sizes_idx_0]++;
      }
    }
    for (k = 0; k < 3; k++) {
      SD->f0.Jx[((ic[0] + 105 * k) + 315 * b_i) - 1] = 0.125 * Ak1[3 * k];
      SD->f0.Jx[((ic[1] + 105 * k) + 315 * b_i) - 1] = 0.125 * Ak1[3 * k + 1];
      SD->f0.Jx[((ic[2] + 105 * k) + 315 * b_i) - 1] = 0.125 * Ak1[3 * k + 2];
      plast = ((ic[k] + 105 * k) + 315 * b_i) - 1;
      SD->f0.Jx[plast]--;
    }
    for (i = 0; i < 6; i++) {
      val[i] = 0.125 * (val[i] + Bk1[i]);
    }
    i1 = ic[0];
    i2 = ic[1];
    i3 = ic[2];
    for (k = 0; k < 2; k++) {
      SD->f0.Jmv[((i1 + 105 * k) + 210 * b_i) - 1] = val[3 * k];
      SD->f0.Jmv[((i2 + 105 * k) + 210 * b_i) - 1] = val[3 * k + 1];
      SD->f0.Jmv[((i3 + 105 * k) + 210 * b_i) - 1] = val[3 * k + 2];
    }
    ic[0] = (int8_T)(ic[0] + 3);
    ic[1] = (int8_T)(ic[1] + 3);
    ic[2] = (int8_T)(ic[2] + 3);
  }
  TRANSB1 = 'N';
  TRANSA1 = 'N';
  alpha1 = 1.0;
  beta1 = 0.0;
  m_t = (ptrdiff_t)105;
  n_t = (ptrdiff_t)70;
  k_t = (ptrdiff_t)70;
  lda_t = (ptrdiff_t)105;
  ldb_t = (ptrdiff_t)70;
  ldc_t = (ptrdiff_t)105;
  dgemm(&TRANSA1, &TRANSB1, &m_t, &n_t, &k_t, &alpha1, &SD->f0.Jmv[0], &lda_t,
        (real_T *)&dv[0], &ldb_t, &beta1, &y[0], &ldc_t);
  emxInit_real_T(&c, 2);
  emxInit_real_T(&Jc, 2);
  outputBounds(runtimedata_OutputMin, runtimedata_OutputMax, X, e, c, Jc);
  Jc_data = Jc->data;
  c_data = c->data;
  emxInit_real_T(&cu, 1);
  parkingIneqConFcn(X, userdata_PredictionHorizon, runtimedata_Parameters_f6,
                    runtimedata_Parameters_f7, cu);
  cu_data = cu->data;
  emxInit_real_T(&Jcu, 2);
  Jcu_data = Jcu->data;
  if (cu->size[0] == 0) {
    Jcu->size[0] = 0;
    Jcu->size[1] = 0;
  } else {
    boolean_T exitg1;
    emxInit_real_T(&Jx, 3);
    emxInit_real_T(&Ju, 3);
    emxInit_real_T(&Je, 1);
    parkingIneqConFcnJacobian(X, userdata_PredictionHorizon,
                              userdata_NumOfStates, runtimedata_Parameters_f6,
                              Jx, Ju, Je);
    Je_data = Je->data;
    Ju_data = Ju->data;
    Jx_data = Jx->data;
    emxInit_real_T(&b, 3);
    empty_non_axis_sizes = true;
    if ((Jx->size[0] != 0) && (Jx->size[1] != 0) && (Jx->size[2] != 0)) {
      plast = 0;
      k = 0;
      exitg1 = false;
      while ((!exitg1) && (k < 3)) {
        if (Jx->size[2 - k] != 1) {
          if (plast > 3 - k) {
            empty_non_axis_sizes = false;
            exitg1 = true;
          } else {
            plast = 3 - k;
            k++;
          }
        } else {
          k++;
        }
      }
    }
    if (empty_non_axis_sizes) {
      i = b->size[0] * b->size[1] * b->size[2];
      b->size[0] = Jx->size[2];
      b->size[1] = Jx->size[1];
      b->size[2] = Jx->size[0];
      emxEnsureCapacity_real_T(b, i);
      b_data = b->data;
      b_i = Jx->size[1] * Jx->size[2] * Jx->size[0];
      for (i = 0; i < b_i; i++) {
        b_data[i] = Jx_data[i];
      }
    } else {
      i = b->size[0] * b->size[1] * b->size[2];
      b->size[0] = Jx->size[2];
      b->size[1] = Jx->size[1];
      b->size[2] = Jx->size[0];
      emxEnsureCapacity_real_T(b, i);
      b_data = b->data;
      i = Jx->size[2];
      for (k = 0; k < i; k++) {
        i4 = Jx->size[1];
        for (input_sizes_idx_0 = 0; input_sizes_idx_0 < i4;
             input_sizes_idx_0++) {
          plast = Jx->size[0];
          if (Jx->size[0] - 1 >= 0) {
            subsa_idx_1 = input_sizes_idx_0 + 1;
            subsa_idx_2 = k + 1;
          }
          for (b_i = 0; b_i < plast; b_i++) {
            b_data[((subsa_idx_2 + b->size[0] * (subsa_idx_1 - 1)) +
                    b->size[0] * b->size[1] * b_i) -
                   1] = Jx_data[(b_i + Jx->size[0] * (subsa_idx_1 - 1)) +
                                Jx->size[0] * Jx->size[1] * (subsa_idx_2 - 1)];
          }
        }
      }
    }
    emxFree_real_T(&Jx);
    emxInit_real_T(&b_b, 3);
    empty_non_axis_sizes = true;
    if ((Ju->size[0] != 0) && (Ju->size[2] != 0)) {
      plast = 0;
      k = 0;
      exitg1 = false;
      while ((!exitg1) && (k < 3)) {
        if (Ju->size[2 - k] != 1) {
          if (plast > 3 - k) {
            empty_non_axis_sizes = false;
            exitg1 = true;
          } else {
            plast = 3 - k;
            k++;
          }
        } else {
          k++;
        }
      }
    }
    if (empty_non_axis_sizes) {
      i = b_b->size[0] * b_b->size[1] * b_b->size[2];
      b_b->size[0] = Ju->size[2];
      b_b->size[1] = 2;
      b_b->size[2] = Ju->size[0];
      emxEnsureCapacity_real_T(b_b, i);
      Jx_data = b_b->data;
      b_i = (Ju->size[2] << 1) * Ju->size[0];
      for (i = 0; i < b_i; i++) {
        Jx_data[i] = Ju_data[i];
      }
    } else {
      i = b_b->size[0] * b_b->size[1] * b_b->size[2];
      b_b->size[0] = Ju->size[2];
      b_b->size[1] = 2;
      b_b->size[2] = Ju->size[0];
      emxEnsureCapacity_real_T(b_b, i);
      Jx_data = b_b->data;
      i = Ju->size[2];
      for (k = 0; k < i; k++) {
        i4 = Ju->size[0];
        for (input_sizes_idx_0 = 0; input_sizes_idx_0 < 2;
             input_sizes_idx_0++) {
          if (i4 - 1 >= 0) {
            subsa_idx_1 = input_sizes_idx_0 + 1;
            subsa_idx_2 = k + 1;
          }
          for (b_i = 0; b_i < i4; b_i++) {
            Jx_data[((subsa_idx_2 + b_b->size[0] * (subsa_idx_1 - 1)) +
                     b_b->size[0] * 2 * b_i) -
                    1] = Ju_data[(b_i + Ju->size[0] * (subsa_idx_1 - 1)) +
                                 Ju->size[0] * 2 * (subsa_idx_2 - 1)];
          }
        }
      }
    }
    emxFree_real_T(&Ju);
    if ((b->size[0] == 0) || (b->size[1] == 0) || (b->size[2] == 0)) {
      Jcu->size[0] = 0;
      Jcu->size[1] = 0;
    } else {
      uint32_T varargin_2;
      varargin_2 = (uint32_T)b->size[2] << 1;
      emxInit_real_T(&b_y, 2);
      emxInit_real_T(&a, 2);
      i = a->size[0] * a->size[1];
      a->size[0] = b->size[0];
      a->size[1] = (int32_T)varargin_2;
      emxEnsureCapacity_real_T(a, i);
      a_data = a->data;
      b_i = b->size[0] * (int32_T)varargin_2;
      for (i = 0; i < b_i; i++) {
        a_data[i] = Jx_data[i];
      }
      if ((int32_T)varargin_2 == 0) {
        i = b_y->size[0] * b_y->size[1];
        b_y->size[0] = b->size[0];
        b_y->size[1] = 70;
        emxEnsureCapacity_real_T(b_y, i);
        Jx_data = b_y->data;
        b_i = b->size[0] * 70;
        for (i = 0; i < b_i; i++) {
          Jx_data[i] = 0.0;
        }
      } else {
        TRANSB1 = 'N';
        TRANSA1 = 'N';
        alpha1 = 1.0;
        beta1 = 0.0;
        m_t = (ptrdiff_t)b->size[0];
        n_t = (ptrdiff_t)70;
        k_t = (ptrdiff_t)70;
        lda_t = (ptrdiff_t)b->size[0];
        ldb_t = (ptrdiff_t)70;
        ldc_t = (ptrdiff_t)b->size[0];
        i = b_y->size[0] * b_y->size[1];
        b_y->size[0] = b->size[0];
        b_y->size[1] = 70;
        emxEnsureCapacity_real_T(b_y, i);
        Jx_data = b_y->data;
        dgemm(&TRANSA1, &TRANSB1, &m_t, &n_t, &k_t, &alpha1, &a_data[0], &lda_t,
              (real_T *)&dv[0], &ldb_t, &beta1, &Jx_data[0], &ldc_t);
      }
      plast = b->size[0];
      input_sizes_idx_0 = (int32_T)((real_T)b->size[2] * (real_T)b->size[1]);
      i = a->size[0] * a->size[1];
      a->size[0] = input_sizes_idx_0;
      a->size[1] = b->size[0];
      emxEnsureCapacity_real_T(a, i);
      a_data = a->data;
      b_i = b->size[0];
      for (i = 0; i < b_i; i++) {
        for (i4 = 0; i4 < input_sizes_idx_0; i4++) {
          a_data[i4 + a->size[0] * i] = b_data[i + plast * i4];
        }
      }
      emxInit_real_T(&b_varargin_2, 2);
      i = b_varargin_2->size[0] * b_varargin_2->size[1];
      b_varargin_2->size[0] = 70;
      b_varargin_2->size[1] = b_y->size[0];
      emxEnsureCapacity_real_T(b_varargin_2, i);
      Ju_data = b_varargin_2->data;
      b_i = b_y->size[0];
      for (i = 0; i < b_i; i++) {
        for (i4 = 0; i4 < 70; i4++) {
          Ju_data[i4 + 70 * i] = Jx_data[i + b_y->size[0] * i4];
        }
      }
      emxFree_real_T(&b_y);
      if (a->size[0] != 0) {
        plast = a->size[1];
      } else {
        plast = b_varargin_2->size[1];
      }
      if (a->size[0] != 0) {
        subsa_idx_1 = a->size[0];
      } else {
        subsa_idx_1 = 0;
      }
      emxInit_real_T(&b_Je, 2);
      i = b_Je->size[0] * b_Je->size[1];
      b_Je->size[0] = 1;
      b_Je->size[1] = Je->size[0];
      emxEnsureCapacity_real_T(b_Je, i);
      Jx_data = b_Je->data;
      b_i = Je->size[0];
      for (i = 0; i < b_i; i++) {
        Jx_data[i] = Je_data[i];
      }
      b_i = (Je->size[0] != 0);
      i = Jcu->size[0] * Jcu->size[1];
      Jcu->size[0] = (subsa_idx_1 + (Je->size[0] != 0)) + 70;
      Jcu->size[1] = plast;
      emxEnsureCapacity_real_T(Jcu, i);
      Jcu_data = Jcu->data;
      for (i = 0; i < plast; i++) {
        for (i4 = 0; i4 < subsa_idx_1; i4++) {
          Jcu_data[i4 + Jcu->size[0] * i] = a_data[i4 + subsa_idx_1 * i];
        }
      }
      emxFree_real_T(&a);
      for (i = 0; i < plast; i++) {
        for (i4 = 0; i4 < 70; i4++) {
          Jcu_data[(i4 + subsa_idx_1) + Jcu->size[0] * i] =
              Ju_data[i4 + 70 * i];
        }
      }
      emxFree_real_T(&b_varargin_2);
      for (i = 0; i < plast; i++) {
        for (i4 = 0; i4 < b_i; i4++) {
          Jcu_data[(subsa_idx_1 + Jcu->size[0] * i) + 70] = Jx_data[b_i * i];
        }
      }
      emxFree_real_T(&b_Je);
    }
    emxFree_real_T(&b_b);
    emxFree_real_T(&b);
    emxFree_real_T(&Je);
  }
  if ((c->size[0] != 0) && (c->size[1] != 0)) {
    plast = c->size[1];
  } else if (cu->size[0] != 0) {
    plast = 1;
  } else {
    plast = 1;
  }
  if ((c->size[0] != 0) && (c->size[1] != 0)) {
    input_sizes_idx_0 = c->size[0];
  } else {
    input_sizes_idx_0 = 0;
  }
  if (cu->size[0] != 0) {
    subsa_idx_1 = cu->size[0];
  } else {
    subsa_idx_1 = 0;
  }
  i = varargout_1->size[0] * varargout_1->size[1];
  if ((c->size[0] != 0) && (c->size[1] != 0)) {
    i4 = c->size[0];
  } else {
    i4 = 0;
  }
  if (cu->size[0] != 0) {
    subsa_idx_2 = cu->size[0];
  } else {
    subsa_idx_2 = 0;
  }
  varargout_1->size[0] = i4 + subsa_idx_2;
  varargout_1->size[1] = plast;
  emxEnsureCapacity_real_T(varargout_1, i);
  Jx_data = varargout_1->data;
  for (i = 0; i < plast; i++) {
    for (i4 = 0; i4 < input_sizes_idx_0; i4++) {
      Jx_data[i4 + varargout_1->size[0] * i] =
          c_data[i4 + input_sizes_idx_0 * i];
    }
  }
  emxFree_real_T(&c);
  for (i = 0; i < plast; i++) {
    for (i4 = 0; i4 < subsa_idx_1; i4++) {
      Jx_data[(i4 + input_sizes_idx_0) + varargout_1->size[0] * i] =
          cu_data[i4 + subsa_idx_1 * i];
    }
  }
  emxFree_real_T(&cu);
  if ((Jc->size[0] != 0) && (Jc->size[1] != 0)) {
    b_i = Jc->size[0];
  } else if ((Jcu->size[0] != 0) && (Jcu->size[1] != 0)) {
    b_i = Jcu->size[0];
  } else {
    b_i = 0;
  }
  empty_non_axis_sizes = (b_i == 0);
  if (empty_non_axis_sizes || ((Jc->size[0] != 0) && (Jc->size[1] != 0))) {
    plast = Jc->size[1];
  } else {
    plast = 0;
  }
  if (empty_non_axis_sizes || ((Jcu->size[0] != 0) && (Jcu->size[1] != 0))) {
    input_sizes_idx_0 = Jcu->size[1];
  } else {
    input_sizes_idx_0 = 0;
  }
  i = varargout_3->size[0] * varargout_3->size[1];
  varargout_3->size[0] = b_i;
  varargout_3->size[1] = plast + input_sizes_idx_0;
  emxEnsureCapacity_real_T(varargout_3, i);
  Jx_data = varargout_3->data;
  for (i = 0; i < plast; i++) {
    for (i4 = 0; i4 < b_i; i4++) {
      Jx_data[i4 + varargout_3->size[0] * i] = Jc_data[i4 + b_i * i];
    }
  }
  emxFree_real_T(&Jc);
  for (i = 0; i < input_sizes_idx_0; i++) {
    for (i4 = 0; i4 < b_i; i4++) {
      Jx_data[i4 + varargout_3->size[0] * (i + plast)] = Jcu_data[i4 + b_i * i];
    }
  }
  emxFree_real_T(&Jcu);
  for (i = 0; i < 105; i++) {
    for (i4 = 0; i4 < 105; i4++) {
      varargout_4[i4 + 176 * i] = SD->f0.Jx[i + 105 * i4];
    }
    for (i4 = 0; i4 < 70; i4++) {
      varargout_4[(i4 + 176 * i) + 105] = y[i + 105 * i4];
    }
    varargout_4[176 * i + 175] = 0.0;
  }
  emlrtHeapReferenceStackLeaveFcnR2012b(emlrtRootTLSGlobal);
}

void nlmpcmoveCodeGeneration(c_nlmpcmoveCodeGenerationStackD *SD,
                             const real_T x[3], const real_T lastMV[2],
                             struct1_T *onlinedata, real_T mv[2],
                             struct2_T *info)
{
  static const real_T t1_f1[70] = {-2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -2.0,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828,
                                   -0.78539816339744828};
  static const real_T t2_f1[70] = {2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   2.0,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828,
                                   0.78539816339744828};
  static const int8_T c_CostFcn_workspace_runtimedata[105] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
  static const int8_T iv[35] = {2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13,
                                14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
                                26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 35};
  ptrdiff_t k_t;
  ptrdiff_t lda_t;
  ptrdiff_t ldb_t;
  ptrdiff_t ldc_t;
  ptrdiff_t m_t;
  ptrdiff_t n_t;
  emxArray_int16_T *ii;
  emxArray_real_T b_Auf;
  emxArray_real_T *Auf;
  emxArray_real_T *B;
  emxArray_real_T *b_initMV;
  emxArray_real_T *initMV;
  emxArray_real_T *initX;
  emxArray_real_T *ref;
  emxArray_real_T *y;
  i_struct_T c_expl_temp;
  i_struct_T d_expl_temp;
  j_struct_T b_expl_temp;
  j_struct_T expl_temp;
  m_struct_T Out;
  real_T Bu[280];
  real_T b_dv1[176];
  real_T z[176];
  real_T z0[176];
  real_T zUB[176];
  real_T b_lastMV[70];
  real_T uz[70];
  real_T b_dv[3];
  real_T Bu_idx_1;
  real_T alpha1;
  real_T beta1;
  real_T d;
  real_T d1;
  real_T f1_tmp;
  real_T f2;
  real_T *b_initMV_data;
  real_T *initMV_data;
  real_T *initX_data;
  real_T *ref_data;
  int32_T b_ii[2];
  int32_T Au_tmp;
  int32_T i;
  int32_T i1;
  int32_T idx;
  int32_T loop_ub;
  int32_T unnamed_idx_0;
  int16_T *ii_data;
  char_T TRANSA1;
  char_T TRANSB1;
  int8_T Au[19600];
  boolean_T icf[280];
  boolean_T exitg1;
  emlrtHeapReferenceStackEnterFcnR2012b(emlrtRootTLSGlobal);
  emxInit_real_T(&ref, 2);
  ref_data = ref->data;
  if (onlinedata->ref->size[0] == 0) {
    i = ref->size[0] * ref->size[1];
    ref->size[0] = 35;
    ref->size[1] = 3;
    emxEnsureCapacity_real_T(ref, i);
    ref_data = ref->data;
    for (i = 0; i < 105; i++) {
      ref_data[i] = 0.0;
    }
  } else if (onlinedata->ref->size[0] == 0) {
    ref->size[0] = 0;
    ref->size[1] = 0;
  } else if (onlinedata->ref->size[0] < 35) {
    unnamed_idx_0 = 35 - onlinedata->ref->size[0];
    i = ref->size[0] * ref->size[1];
    ref->size[0] = onlinedata->ref->size[0] + unnamed_idx_0;
    ref->size[1] = 3;
    emxEnsureCapacity_real_T(ref, i);
    ref_data = ref->data;
    loop_ub = onlinedata->ref->size[0];
    for (i = 0; i < 3; i++) {
      for (i1 = 0; i1 < loop_ub; i1++) {
        ref_data[i1 + ref->size[0] * i] =
            onlinedata->ref->data[i1 + onlinedata->ref->size[0] * i];
      }
    }
    for (i = 0; i < 3; i++) {
      for (i1 = 0; i1 < unnamed_idx_0; i1++) {
        ref_data[(i1 + onlinedata->ref->size[0]) + ref->size[0] * i] =
            onlinedata->ref->data[(onlinedata->ref->size[0] +
                                   onlinedata->ref->size[0] * i) -
                                  1];
      }
    }
  } else {
    i = ref->size[0] * ref->size[1];
    ref->size[0] = onlinedata->ref->size[0];
    ref->size[1] = 3;
    emxEnsureCapacity_real_T(ref, i);
    ref_data = ref->data;
    loop_ub = onlinedata->ref->size[0] * 3;
    for (i = 0; i < loop_ub; i++) {
      ref_data[i] = onlinedata->ref->data[i];
    }
  }
  emxInitStruct_struct_T3(&expl_temp);
  if (onlinedata->MVTarget->size[0] == 0) {
    i = expl_temp.MVTarget->size[0] * expl_temp.MVTarget->size[1];
    expl_temp.MVTarget->size[0] = 35;
    expl_temp.MVTarget->size[1] = 2;
    emxEnsureCapacity_real_T(expl_temp.MVTarget, i);
    for (i = 0; i < 70; i++) {
      expl_temp.MVTarget->data[i] = 0.0;
    }
  } else if (onlinedata->MVTarget->size[0] == 0) {
    expl_temp.MVTarget->size[0] = 0;
    expl_temp.MVTarget->size[1] = 0;
  } else if (onlinedata->MVTarget->size[0] < 35) {
    unnamed_idx_0 = 35 - onlinedata->MVTarget->size[0];
    i = expl_temp.MVTarget->size[0] * expl_temp.MVTarget->size[1];
    expl_temp.MVTarget->size[0] = onlinedata->MVTarget->size[0] + unnamed_idx_0;
    expl_temp.MVTarget->size[1] = 2;
    emxEnsureCapacity_real_T(expl_temp.MVTarget, i);
    loop_ub = onlinedata->MVTarget->size[0];
    for (i = 0; i < 2; i++) {
      for (i1 = 0; i1 < loop_ub; i1++) {
        expl_temp.MVTarget->data[i1 + expl_temp.MVTarget->size[0] * i] =
            onlinedata->MVTarget->data[i1 + onlinedata->MVTarget->size[0] * i];
      }
    }
    for (i = 0; i < 2; i++) {
      for (i1 = 0; i1 < unnamed_idx_0; i1++) {
        expl_temp.MVTarget->data[(i1 + onlinedata->MVTarget->size[0]) +
                                 expl_temp.MVTarget->size[0] * i] =
            onlinedata->MVTarget->data[(onlinedata->MVTarget->size[0] +
                                        onlinedata->MVTarget->size[0] * i) -
                                       1];
      }
    }
  } else {
    i = expl_temp.MVTarget->size[0] * expl_temp.MVTarget->size[1];
    expl_temp.MVTarget->size[0] = onlinedata->MVTarget->size[0];
    expl_temp.MVTarget->size[1] = 2;
    emxEnsureCapacity_real_T(expl_temp.MVTarget, i);
    loop_ub = onlinedata->MVTarget->size[0] * 2;
    for (i = 0; i < loop_ub; i++) {
      expl_temp.MVTarget->data[i] = onlinedata->MVTarget->data[i];
    }
  }
  emxInit_real_T(&initX, 2);
  initX_data = initX->data;
  if (onlinedata->X0->size[0] != 0) {
    if (onlinedata->X0->size[0] == 0) {
      initX->size[0] = 0;
      initX->size[1] = 0;
    } else if (onlinedata->X0->size[0] < 35) {
      unnamed_idx_0 = 35 - onlinedata->X0->size[0];
      i = initX->size[0] * initX->size[1];
      initX->size[0] = onlinedata->X0->size[0] + unnamed_idx_0;
      initX->size[1] = 3;
      emxEnsureCapacity_real_T(initX, i);
      initX_data = initX->data;
      loop_ub = onlinedata->X0->size[0];
      for (i = 0; i < 3; i++) {
        for (i1 = 0; i1 < loop_ub; i1++) {
          initX_data[i1 + initX->size[0] * i] =
              onlinedata->X0->data[i1 + onlinedata->X0->size[0] * i];
        }
      }
      for (i = 0; i < 3; i++) {
        for (i1 = 0; i1 < unnamed_idx_0; i1++) {
          initX_data[(i1 + onlinedata->X0->size[0]) + initX->size[0] * i] =
              onlinedata->X0->data[(onlinedata->X0->size[0] +
                                    onlinedata->X0->size[0] * i) -
                                   1];
        }
      }
    } else {
      i = initX->size[0] * initX->size[1];
      initX->size[0] = onlinedata->X0->size[0];
      initX->size[1] = 3;
      emxEnsureCapacity_real_T(initX, i);
      initX_data = initX->data;
      loop_ub = onlinedata->X0->size[0] * 3;
      for (i = 0; i < loop_ub; i++) {
        initX_data[i] = onlinedata->X0->data[i];
      }
    }
  } else {
    real_T b_x[105];
    for (i = 0; i < 3; i++) {
      b_x[35 * i] = x[i];
      for (i1 = 0; i1 < 34; i1++) {
        b_x[(i1 + 35 * i) + 1] = x[i];
      }
    }
    i = initX->size[0] * initX->size[1];
    initX->size[0] = 35;
    initX->size[1] = 3;
    emxEnsureCapacity_real_T(initX, i);
    initX_data = initX->data;
    for (i = 0; i < 105; i++) {
      initX_data[i] = b_x[i];
    }
  }
  emxInit_real_T(&initMV, 2);
  initMV_data = initMV->data;
  if (onlinedata->MV0->size[0] != 0) {
    if (onlinedata->MV0->size[0] == 0) {
      initMV->size[0] = 0;
      initMV->size[1] = 0;
    } else if (onlinedata->MV0->size[0] < 35) {
      unnamed_idx_0 = 35 - onlinedata->MV0->size[0];
      i = initMV->size[0] * initMV->size[1];
      initMV->size[0] = onlinedata->MV0->size[0] + unnamed_idx_0;
      initMV->size[1] = 2;
      emxEnsureCapacity_real_T(initMV, i);
      initMV_data = initMV->data;
      loop_ub = onlinedata->MV0->size[0];
      for (i = 0; i < 2; i++) {
        for (i1 = 0; i1 < loop_ub; i1++) {
          initMV_data[i1 + initMV->size[0] * i] =
              onlinedata->MV0->data[i1 + onlinedata->MV0->size[0] * i];
        }
      }
      for (i = 0; i < 2; i++) {
        for (i1 = 0; i1 < unnamed_idx_0; i1++) {
          initMV_data[(i1 + onlinedata->MV0->size[0]) + initMV->size[0] * i] =
              onlinedata->MV0->data[(onlinedata->MV0->size[0] +
                                     onlinedata->MV0->size[0] * i) -
                                    1];
        }
      }
    } else {
      i = initMV->size[0] * initMV->size[1];
      initMV->size[0] = onlinedata->MV0->size[0];
      initMV->size[1] = 2;
      emxEnsureCapacity_real_T(initMV, i);
      initMV_data = initMV->data;
      loop_ub = onlinedata->MV0->size[0] * 2;
      for (i = 0; i < loop_ub; i++) {
        initMV_data[i] = onlinedata->MV0->data[i];
      }
    }
  } else {
    for (i = 0; i < 2; i++) {
      b_lastMV[35 * i] = lastMV[i];
      for (i1 = 0; i1 < 34; i1++) {
        b_lastMV[(i1 + 35 * i) + 1] = lastMV[i];
      }
    }
    i = initMV->size[0] * initMV->size[1];
    initMV->size[0] = 35;
    initMV->size[1] = 2;
    emxEnsureCapacity_real_T(initMV, i);
    initMV_data = initMV->data;
    for (i = 0; i < 70; i++) {
      initMV_data[i] = b_lastMV[i];
    }
  }
  emxInit_real_T(&b_initMV, 2);
  i = b_initMV->size[0] * b_initMV->size[1];
  b_initMV->size[0] = initMV->size[1];
  b_initMV->size[1] = initMV->size[0];
  emxEnsureCapacity_real_T(b_initMV, i);
  b_initMV_data = b_initMV->data;
  loop_ub = initMV->size[0];
  for (i = 0; i < loop_ub; i++) {
    unnamed_idx_0 = initMV->size[1];
    for (i1 = 0; i1 < unnamed_idx_0; i1++) {
      b_initMV_data[i1 + b_initMV->size[0] * i] =
          initMV_data[i + initMV->size[0] * i1];
    }
  }
  for (i = 0; i < 70; i++) {
    b_lastMV[i] = b_initMV_data[i];
  }
  emxFree_real_T(&b_initMV);
  TRANSB1 = 'N';
  TRANSA1 = 'N';
  alpha1 = 1.0;
  beta1 = 0.0;
  m_t = (ptrdiff_t)70;
  n_t = (ptrdiff_t)1;
  k_t = (ptrdiff_t)70;
  lda_t = (ptrdiff_t)70;
  ldb_t = (ptrdiff_t)70;
  ldc_t = (ptrdiff_t)70;
  dgemm(&TRANSA1, &TRANSB1, &m_t, &n_t, &k_t, &alpha1, (real_T *)&dv[0], &lda_t,
        &b_lastMV[0], &ldb_t, &beta1, &uz[0], &ldc_t);
  i = initMV->size[0] * initMV->size[1];
  initMV->size[0] = initX->size[1];
  initMV->size[1] = initX->size[0];
  emxEnsureCapacity_real_T(initMV, i);
  initMV_data = initMV->data;
  loop_ub = initX->size[0];
  for (i = 0; i < loop_ub; i++) {
    unnamed_idx_0 = initX->size[1];
    for (i1 = 0; i1 < unnamed_idx_0; i1++) {
      initMV_data[i1 + initMV->size[0] * i] =
          initX_data[i + initX->size[0] * i1];
    }
  }
  emxFree_real_T(&initX);
  for (i = 0; i < 105; i++) {
    z0[i] = initMV_data[i];
  }
  emxFree_real_T(&initMV);
  memcpy(&z0[105], &uz[0], 70U * sizeof(real_T));
  z0[175] = onlinedata->Slack0;
  emxInitStruct_struct_T3(&b_expl_temp);
  i = b_expl_temp.References->size[0] * b_expl_temp.References->size[1];
  b_expl_temp.References->size[0] = ref->size[0];
  b_expl_temp.References->size[1] = ref->size[1];
  emxEnsureCapacity_real_T(b_expl_temp.References, i);
  loop_ub = ref->size[0] * ref->size[1];
  for (i = 0; i < loop_ub; i++) {
    b_expl_temp.References->data[i] = ref_data[i];
  }
  emxInitStruct_struct_T2(&c_expl_temp);
  i = c_expl_temp.ref->size[0] * c_expl_temp.ref->size[1];
  c_expl_temp.ref->size[0] = ref->size[0];
  c_expl_temp.ref->size[1] = ref->size[1];
  emxEnsureCapacity_real_T(c_expl_temp.ref, i);
  loop_ub = ref->size[0] * ref->size[1];
  for (i = 0; i < loop_ub; i++) {
    c_expl_temp.ref->data[i] = ref_data[i];
  }
  for (i = 0; i < 70; i++) {
    c_expl_temp.MVRateWeights[i] = 0.1;
  }
  for (i = 0; i < 105; i++) {
    c_expl_temp.OutputMin[i] = rtMinusInf;
    c_expl_temp.OutputMax[i] = rtInf;
    c_expl_temp.StateMin[i] = rtMinusInf;
    c_expl_temp.StateMax[i] = rtInf;
  }
  for (i = 0; i < 70; i++) {
    c_expl_temp.MVRateMin[i] = rtMinusInf;
    c_expl_temp.MVRateMax[i] = rtInf;
  }
  for (i = 0; i < 105; i++) {
    zUB[i] = rtInf;
  }
  for (i = 0; i < 70; i++) {
    zUB[i + 105] = rtInf;
  }
  zUB[175] = rtInf;
  znlmpc_getXUe(z0, x, info->Xopt, info->MVopt, &alpha1);
  /*  Cost Function for Parking */
  /*  Process Cost: */
  alpha1 = 0.0;
  for (idx = 0; idx < 35; idx++) {
    b_dv[0] = info->Xopt[idx + 1] - onlinedata->Parameters.f1[0];
    b_dv[1] = info->Xopt[idx + 37] - onlinedata->Parameters.f1[1];
    b_dv[2] = info->Xopt[idx + 73] - onlinedata->Parameters.f1[2];
    beta1 = 0.0;
    for (i = 0; i < 3; i++) {
      beta1 += ((b_dv[0] * onlinedata->Parameters.f2[3 * i] +
                 b_dv[1] * onlinedata->Parameters.f2[3 * i + 1]) +
                b_dv[2] * onlinedata->Parameters.f2[3 * i + 2]) *
               b_dv[i];
    }
    Bu_idx_1 = info->MVopt[idx + 36];
    alpha1 += beta1 + ((info->MVopt[idx] * onlinedata->Parameters.f3[0] +
                        Bu_idx_1 * onlinedata->Parameters.f3[1]) *
                           info->MVopt[idx] +
                       (info->MVopt[idx] * onlinedata->Parameters.f3[2] +
                        Bu_idx_1 * onlinedata->Parameters.f3[3]) *
                           Bu_idx_1);
  }
  /*  Terminal Cost: */
  beta1 = info->Xopt[35] - onlinedata->Parameters.f1[0];
  b_dv[0] = beta1;
  Bu_idx_1 = info->Xopt[71] - onlinedata->Parameters.f1[1];
  b_dv[1] = Bu_idx_1;
  d = info->Xopt[107] - onlinedata->Parameters.f1[2];
  b_dv[2] = d;
  /*  Total Cost */
  d1 = 0.0;
  for (i = 0; i < 3; i++) {
    d1 += ((beta1 * onlinedata->Parameters.f4[3 * i] +
            Bu_idx_1 * onlinedata->Parameters.f4[3 * i + 1]) +
           d * onlinedata->Parameters.f4[3 * i + 2]) *
          b_dv[i];
  }
  f1_tmp = (onlinedata->Parameters.f5[0] * info->MVopt[34] +
            onlinedata->Parameters.f5[1] * info->MVopt[70]) *
               info->MVopt[34] +
           (onlinedata->Parameters.f5[2] * info->MVopt[34] +
            onlinedata->Parameters.f5[3] * info->MVopt[70]) *
               info->MVopt[70];
  alpha1 += d1 + f1_tmp;
  /*  Cost Function for Parking */
  /*  Process Cost: */
  f2 = 0.0;
  for (idx = 0; idx < 35; idx++) {
    b_dv[0] = info->Xopt[idx + 1] - onlinedata->Parameters.f1[0];
    b_dv[1] = info->Xopt[idx + 37] - onlinedata->Parameters.f1[1];
    b_dv[2] = info->Xopt[idx + 73] - onlinedata->Parameters.f1[2];
    d1 = 0.0;
    for (i = 0; i < 3; i++) {
      d1 += ((b_dv[0] * onlinedata->Parameters.f2[3 * i] +
              b_dv[1] * onlinedata->Parameters.f2[3 * i + 1]) +
             b_dv[2] * onlinedata->Parameters.f2[3 * i + 2]) *
            b_dv[i];
    }
    real_T d2;
    d2 = info->MVopt[idx + 36];
    f2 += d1 + ((info->MVopt[idx] * onlinedata->Parameters.f3[0] +
                 d2 * onlinedata->Parameters.f3[1]) *
                    info->MVopt[idx] +
                (info->MVopt[idx] * onlinedata->Parameters.f3[2] +
                 d2 * onlinedata->Parameters.f3[3]) *
                    d2);
  }
  /*  Terminal Cost: */
  b_dv[0] = beta1;
  b_dv[1] = Bu_idx_1;
  b_dv[2] = d;
  /*  Total Cost */
  d1 = 0.0;
  for (i = 0; i < 3; i++) {
    d1 += ((beta1 * onlinedata->Parameters.f4[3 * i] +
            Bu_idx_1 * onlinedata->Parameters.f4[3 * i + 1]) +
           d * onlinedata->Parameters.f4[3 * i + 2]) *
          b_dv[i];
  }
  f2 += d1 + f1_tmp;
  if (f2 <= alpha1) {
    zUB[175] = 0.0;
  }
  memset(&Au[0], 0, 19600U * sizeof(int8_T));
  memset(&Bu[0], 0, 280U * sizeof(real_T));
  memset(&icf[0], 0, 280U * sizeof(boolean_T));
  alpha1 = 1.0;
  beta1 = 2.0;
  for (loop_ub = 0; loop_ub < 35; loop_ub++) {
    icf[(int32_T)alpha1 - 1] = false;
    icf[(int32_T)beta1 - 1] = false;
    icf[(int32_T)(alpha1 + 2.0) - 1] = false;
    icf[(int32_T)(beta1 + 2.0) - 1] = false;
    icf[(int32_T)(alpha1 + 4.0) - 1] = true;
    icf[(int32_T)(beta1 + 4.0) - 1] = true;
    icf[(int32_T)(alpha1 + 6.0) - 1] = true;
    unnamed_idx_0 = (int32_T)alpha1 + 560 * loop_ub;
    Au[unnamed_idx_0 - 1] = -1;
    idx = (int32_T)beta1 + 560 * loop_ub;
    Au[idx - 1] = 0;
    icf[(int32_T)(beta1 + 6.0) - 1] = true;
    Au[unnamed_idx_0 + 279] = 0;
    Au[idx + 279] = -1;
    unnamed_idx_0 = (int32_T)(alpha1 + 2.0) + 560 * loop_ub;
    Au[unnamed_idx_0 - 1] = 1;
    idx = (int32_T)(beta1 + 2.0) + 560 * loop_ub;
    Au[idx - 1] = 0;
    Au[unnamed_idx_0 + 279] = 0;
    Au[idx + 279] = 1;
    unnamed_idx_0 = (int32_T)(alpha1 + 4.0) + 560 * loop_ub;
    Au[unnamed_idx_0 - 1] = -1;
    idx = (int32_T)(beta1 + 4.0) + 560 * loop_ub;
    Au[idx - 1] = 0;
    Au[unnamed_idx_0 + 279] = 0;
    Au[idx + 279] = -1;
    unnamed_idx_0 = (int32_T)(alpha1 + 6.0) + 560 * loop_ub;
    Au[unnamed_idx_0 - 1] = 1;
    idx = (int32_T)(beta1 + 6.0) + 560 * loop_ub;
    Au[idx - 1] = 0;
    Au[unnamed_idx_0 + 279] = 0;
    Au[idx + 279] = 1;
    Bu[(int32_T)alpha1 - 1] = rtInf;
    Bu[(int32_T)beta1 - 1] = rtInf;
    Bu[(int32_T)(alpha1 + 2.0) - 1] = rtInf;
    Bu[(int32_T)(beta1 + 2.0) - 1] = rtInf;
    Bu[(int32_T)(alpha1 + 4.0) - 1] = -t1_f1[loop_ub];
    Bu[(int32_T)(beta1 + 4.0) - 1] = -t1_f1[loop_ub + 35];
    Bu[(int32_T)(alpha1 + 6.0) - 1] = t2_f1[loop_ub];
    Bu[(int32_T)(beta1 + 6.0) - 1] = t2_f1[loop_ub + 35];
    if (loop_ub + 1 == 1) {
      Bu_idx_1 = Bu[(int32_T)beta1 - 1] - lastMV[1];
      Bu[(int32_T)alpha1 - 1] -= lastMV[0];
      Bu[(int32_T)beta1 - 1] = Bu_idx_1;
      Bu_idx_1 = Bu[(int32_T)(beta1 + 2.0) - 1] + lastMV[1];
      Bu[(int32_T)(alpha1 + 2.0) - 1] += lastMV[0];
      Bu[(int32_T)(beta1 + 2.0) - 1] = Bu_idx_1;
    } else {
      unnamed_idx_0 = 560 * (loop_ub - 1);
      idx = (int32_T)alpha1 + unnamed_idx_0;
      Au[idx - 1] = 1;
      Au_tmp = (int32_T)beta1 + unnamed_idx_0;
      Au[Au_tmp - 1] = 0;
      Au[idx + 279] = 0;
      Au[Au_tmp + 279] = 1;
      idx = (int32_T)(alpha1 + 2.0) + unnamed_idx_0;
      Au[idx - 1] = -1;
      unnamed_idx_0 += (int32_T)(beta1 + 2.0);
      Au[unnamed_idx_0 - 1] = 0;
      Au[idx + 279] = 0;
      Au[unnamed_idx_0 + 279] = -1;
    }
    alpha1 += 8.0;
    beta1 += 8.0;
  }
  idx = 0;
  emxInit_int16_T(&ii);
  i = ii->size[0];
  ii->size[0] = 280;
  emxEnsureCapacity_int16_T(ii, i);
  ii_data = ii->data;
  unnamed_idx_0 = 0;
  exitg1 = false;
  while ((!exitg1) && (unnamed_idx_0 < 280)) {
    if (icf[unnamed_idx_0]) {
      idx++;
      ii_data[idx - 1] = (int16_T)(unnamed_idx_0 + 1);
      if (idx >= 280) {
        exitg1 = true;
      } else {
        unnamed_idx_0++;
      }
    } else {
      unnamed_idx_0++;
    }
  }
  i = ii->size[0];
  if (idx < 1) {
    ii->size[0] = 0;
  } else {
    ii->size[0] = idx;
  }
  emxEnsureCapacity_int16_T(ii, i);
  ii_data = ii->data;
  emxInit_real_T(&B, 1);
  if (ii->size[0] > 0) {
    int8_T input_sizes_idx_1;
    i = B->size[0];
    B->size[0] = ii->size[0];
    emxEnsureCapacity_real_T(B, i);
    initX_data = B->data;
    loop_ub = ii->size[0];
    for (i = 0; i < loop_ub; i++) {
      initX_data[i] = Bu[ii_data[i] - 1];
    }
    emxInit_real_T(&Auf, 3);
    i = Auf->size[0] * Auf->size[1] * Auf->size[2];
    Auf->size[0] = ii->size[0];
    Auf->size[1] = 2;
    Auf->size[2] = 35;
    emxEnsureCapacity_real_T(Auf, i);
    initX_data = Auf->data;
    i = ii->size[0];
    for (unnamed_idx_0 = 0; unnamed_idx_0 < 2; unnamed_idx_0++) {
      for (Au_tmp = 0; Au_tmp < 35; Au_tmp++) {
        for (loop_ub = 0; loop_ub < i; loop_ub++) {
          initX_data[(loop_ub + Auf->size[0] * unnamed_idx_0) +
                     Auf->size[0] * 2 * Au_tmp] =
              Au[((ii_data[loop_ub] + 280 * unnamed_idx_0) + 560 * Au_tmp) - 1];
        }
      }
    }
    unnamed_idx_0 = ii->size[0];
    b_Auf = *Auf;
    b_ii[0] = unnamed_idx_0;
    b_ii[1] = 70;
    b_Auf.size = &b_ii[0];
    b_Auf.numDimensions = 2;
    emxInit_real_T(&y, 2);
    mtimes(&b_Auf, y);
    initX_data = y->data;
    emxFree_real_T(&Auf);
    if (y->size[0] != 0) {
      input_sizes_idx_1 = 70;
    } else {
      input_sizes_idx_1 = 0;
    }
    unnamed_idx_0 = ii->size[0];
    if (y->size[0] != 0) {
      idx = 70;
    } else {
      idx = 0;
    }
    Au_tmp = ii->size[0];
    i = ref->size[0] * ref->size[1];
    ref->size[0] = ii->size[0];
    ref->size[1] = input_sizes_idx_1 + 106;
    emxEnsureCapacity_real_T(ref, i);
    ref_data = ref->data;
    for (i = 0; i < 105; i++) {
      loop_ub = ii->size[0];
      for (i1 = 0; i1 < loop_ub; i1++) {
        ref_data[i1 + ref->size[0] * i] = 0.0;
      }
    }
    loop_ub = input_sizes_idx_1;
    for (i = 0; i < loop_ub; i++) {
      for (i1 = 0; i1 < unnamed_idx_0; i1++) {
        ref_data[i1 + ref->size[0] * (i + 105)] =
            initX_data[i1 + unnamed_idx_0 * i];
      }
    }
    emxFree_real_T(&y);
    for (i = 0; i < Au_tmp; i++) {
      ref_data[i + ref->size[0] * (idx + 105)] = 0.0;
    }
  } else {
    B->size[0] = 0;
    ref->size[0] = 0;
    ref->size[1] = 176;
  }
  emxFree_int16_T(&ii);
  c_expl_temp.Parameters = onlinedata->Parameters;
  i = c_expl_temp.MVScaledTarget->size[0] * c_expl_temp.MVScaledTarget->size[1];
  c_expl_temp.MVScaledTarget->size[0] = expl_temp.MVTarget->size[0];
  c_expl_temp.MVScaledTarget->size[1] = expl_temp.MVTarget->size[1];
  emxEnsureCapacity_real_T(c_expl_temp.MVScaledTarget, i);
  loop_ub = expl_temp.MVTarget->size[0] * expl_temp.MVTarget->size[1];
  for (i = 0; i < loop_ub; i++) {
    c_expl_temp.MVScaledTarget->data[i] = expl_temp.MVTarget->data[i];
  }
  c_expl_temp.ECRWeight = 100000.0;
  for (i = 0; i < 70; i++) {
    c_expl_temp.MVMax[i] = t2_f1[i];
    c_expl_temp.MVMin[i] = t1_f1[i];
    c_expl_temp.MVWeights[i] = 0.0;
  }
  for (i = 0; i < 105; i++) {
    c_expl_temp.OutputWeights[i] = c_CostFcn_workspace_runtimedata[i];
  }
  c_expl_temp.lastMV[0] = lastMV[0];
  c_expl_temp.lastMV[1] = lastMV[1];
  c_expl_temp.x[0] = x[0];
  c_expl_temp.x[1] = x[1];
  c_expl_temp.x[2] = x[2];
  b_expl_temp.MVIndex[0] = 1.0;
  b_expl_temp.MVIndex[1] = 2.0;
  b_expl_temp.NumOfStates = 3.0;
  b_expl_temp.PredictionHorizon = 35.0;
  i = b_expl_temp.MVTarget->size[0] * b_expl_temp.MVTarget->size[1];
  b_expl_temp.MVTarget->size[0] = expl_temp.MVTarget->size[0];
  b_expl_temp.MVTarget->size[1] = expl_temp.MVTarget->size[1];
  emxEnsureCapacity_real_T(b_expl_temp.MVTarget, i);
  loop_ub = expl_temp.MVTarget->size[0] * expl_temp.MVTarget->size[1];
  for (i = 0; i < loop_ub; i++) {
    b_expl_temp.MVTarget->data[i] = expl_temp.MVTarget->data[i];
  }
  b_expl_temp.LastMV[0] = lastMV[0];
  b_expl_temp.LastMV[1] = lastMV[1];
  b_expl_temp.CurrentStates[0] = x[0];
  b_expl_temp.CurrentStates[1] = x[1];
  b_expl_temp.CurrentStates[2] = x[2];
  emxInitStruct_struct_T2(&d_expl_temp);
  d_expl_temp.Parameters = onlinedata->Parameters;
  i = d_expl_temp.MVScaledTarget->size[0] * d_expl_temp.MVScaledTarget->size[1];
  d_expl_temp.MVScaledTarget->size[0] = expl_temp.MVTarget->size[0];
  d_expl_temp.MVScaledTarget->size[1] = expl_temp.MVTarget->size[1];
  emxEnsureCapacity_real_T(d_expl_temp.MVScaledTarget, i);
  loop_ub = expl_temp.MVTarget->size[0] * expl_temp.MVTarget->size[1];
  for (i = 0; i < loop_ub; i++) {
    d_expl_temp.MVScaledTarget->data[i] = expl_temp.MVTarget->data[i];
  }
  for (i = 0; i < 70; i++) {
    d_expl_temp.MVRateMax[i] = rtInf;
    d_expl_temp.MVRateMin[i] = rtMinusInf;
    d_expl_temp.MVMax[i] = t2_f1[i];
    d_expl_temp.MVMin[i] = t1_f1[i];
  }
  for (i = 0; i < 105; i++) {
    d_expl_temp.StateMax[i] = rtInf;
    d_expl_temp.StateMin[i] = rtMinusInf;
    d_expl_temp.OutputMax[i] = rtInf;
    d_expl_temp.OutputMin[i] = rtMinusInf;
  }
  d_expl_temp.ECRWeight = 100000.0;
  for (i = 0; i < 70; i++) {
    d_expl_temp.MVRateWeights[i] = 0.1;
    d_expl_temp.MVWeights[i] = 0.0;
  }
  for (i = 0; i < 105; i++) {
    d_expl_temp.OutputWeights[i] = c_CostFcn_workspace_runtimedata[i];
  }
  i = d_expl_temp.ref->size[0] * d_expl_temp.ref->size[1];
  d_expl_temp.ref->size[0] = c_expl_temp.ref->size[0];
  d_expl_temp.ref->size[1] = c_expl_temp.ref->size[1];
  emxEnsureCapacity_real_T(d_expl_temp.ref, i);
  loop_ub = c_expl_temp.ref->size[0] * c_expl_temp.ref->size[1];
  for (i = 0; i < loop_ub; i++) {
    d_expl_temp.ref->data[i] = c_expl_temp.ref->data[i];
  }
  d_expl_temp.lastMV[0] = lastMV[0];
  d_expl_temp.lastMV[1] = lastMV[1];
  d_expl_temp.x[0] = x[0];
  d_expl_temp.x[1] = x[1];
  d_expl_temp.x[2] = x[2];
  expl_temp.MVIndex[0] = 1.0;
  expl_temp.MVIndex[1] = 2.0;
  expl_temp.NumOfStates = 3.0;
  expl_temp.PredictionHorizon = 35.0;
  i = expl_temp.References->size[0] * expl_temp.References->size[1];
  expl_temp.References->size[0] = b_expl_temp.References->size[0];
  expl_temp.References->size[1] = b_expl_temp.References->size[1];
  emxEnsureCapacity_real_T(expl_temp.References, i);
  loop_ub = b_expl_temp.References->size[0] * b_expl_temp.References->size[1];
  for (i = 0; i < loop_ub; i++) {
    expl_temp.References->data[i] = b_expl_temp.References->data[i];
  }
  expl_temp.LastMV[0] = lastMV[0];
  expl_temp.LastMV[1] = lastMV[1];
  expl_temp.CurrentStates[0] = x[0];
  expl_temp.CurrentStates[1] = x[1];
  expl_temp.CurrentStates[2] = x[2];
  for (i = 0; i < 105; i++) {
    b_dv1[i] = rtMinusInf;
  }
  for (i = 0; i < 70; i++) {
    b_dv1[i + 105] = rtMinusInf;
  }
  b_dv1[175] = 0.0;
  fmincon(SD, &c_expl_temp, &b_expl_temp, z0, ref, B, b_dv1, zUB, &d_expl_temp,
          &expl_temp, z, &info->Cost, &alpha1, &Out);
  emxFreeStruct_struct_T3(&expl_temp);
  emxFreeStruct_struct_T1(&d_expl_temp);
  emxFreeStruct_struct_T3(&b_expl_temp);
  emxFreeStruct_struct_T1(&c_expl_temp);
  emxFree_real_T(&ref);
  emxFree_real_T(&B);
  if ((alpha1 == 0.0) && (Out.constrviolation > 0.01)) {
    alpha1 = -2.0;
  }
  znlmpc_getXUe(z, x, info->Xopt, info->MVopt, &beta1);
  if (alpha1 > 0.0) {
    mv[0] = info->MVopt[0];
    mv[1] = info->MVopt[36];
  } else {
    mv[0] = lastMV[0];
    mv[1] = lastMV[1];
  }
  info->ExitFlag = alpha1;
  info->Iterations = Out.iterations;
  onlinedata->Slack0 = muDoubleScalarMax(0.0, beta1);
  memcpy(&info->Yopt[0], &info->Xopt[0], 108U * sizeof(real_T));
  for (i = 0; i < 36; i++) {
    info->Topt[i] = 0.25 * (real_T)i;
  }
  info->Slack = beta1;
  i = onlinedata->X0->size[0] * onlinedata->X0->size[1];
  onlinedata->X0->size[0] = 35;
  onlinedata->X0->size[1] = 3;
  emxEnsureCapacity_real_T(onlinedata->X0, i);
  for (i = 0; i < 3; i++) {
    for (i1 = 0; i1 < 35; i1++) {
      onlinedata->X0->data[i1 + onlinedata->X0->size[0] * i] =
          info->Xopt[iv[i1] + 36 * i];
    }
  }
  i = onlinedata->MV0->size[0] * onlinedata->MV0->size[1];
  onlinedata->MV0->size[0] = 35;
  onlinedata->MV0->size[1] = 2;
  emxEnsureCapacity_real_T(onlinedata->MV0, i);
  for (i = 0; i < 2; i++) {
    for (i1 = 0; i1 < 35; i1++) {
      onlinedata->MV0->data[i1 + onlinedata->MV0->size[0] * i] =
          info->MVopt[(i1 + 36 * i) + 1];
    }
  }
  emlrtHeapReferenceStackLeaveFcnR2012b(emlrtRootTLSGlobal);
}

/* End of code generation (nlmpcmoveCodeGeneration.c) */
