/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * axang2tform.c
 *
 * Code generation for function 'axang2tform'
 *
 */

/* Include files */
#include "axang2tform.h"
#include "rt_nonfinite.h"
#include "sumMatrixIncludeNaN.h"
#include "mwmathutil.h"
#include <string.h>

/* Function Definitions */
void axang2tform(const real_T axang[4], real_T H[16])
{
  real_T R[9];
  real_T tempR[9];
  real_T v[3];
  real_T b_tempR_tmp;
  real_T c_tempR_tmp;
  real_T cth;
  real_T d_tempR_tmp;
  real_T sth;
  real_T tempR_tmp;
  int32_T k;
  v[0] = axang[0] * axang[0];
  v[1] = axang[1] * axang[1];
  v[2] = axang[2] * axang[2];
  cth = 1.0 / muDoubleScalarSqrt(sumColumnB(v));
  v[0] = axang[0] * cth;
  v[1] = axang[1] * cth;
  v[2] = axang[2] * cth;
  cth = muDoubleScalarCos(axang[3]);
  sth = muDoubleScalarSin(axang[3]);
  tempR[0] = v[0] * v[0] * (1.0 - cth) + cth;
  tempR_tmp = v[0] * v[1] * (1.0 - cth);
  b_tempR_tmp = v[2] * sth;
  tempR[1] = tempR_tmp - b_tempR_tmp;
  c_tempR_tmp = v[0] * v[2] * (1.0 - cth);
  d_tempR_tmp = v[1] * sth;
  tempR[2] = c_tempR_tmp + d_tempR_tmp;
  tempR[3] = tempR_tmp + b_tempR_tmp;
  tempR[4] = v[1] * v[1] * (1.0 - cth) + cth;
  tempR_tmp = v[1] * v[2] * (1.0 - cth);
  b_tempR_tmp = v[0] * sth;
  tempR[5] = tempR_tmp - b_tempR_tmp;
  tempR[6] = c_tempR_tmp - d_tempR_tmp;
  tempR[7] = tempR_tmp + b_tempR_tmp;
  tempR[8] = v[2] * v[2] * (1.0 - cth) + cth;
  memcpy(&R[0], &tempR[0], 9U * sizeof(real_T));
  for (k = 0; k < 3; k++) {
    R[k] = tempR[3 * k];
    R[k + 3] = tempR[3 * k + 1];
    R[k + 6] = tempR[3 * k + 2];
  }
  memset(&H[0], 0, 16U * sizeof(real_T));
  for (k = 0; k < 3; k++) {
    int32_T H_tmp;
    H_tmp = k << 2;
    H[H_tmp] = R[3 * k];
    H[H_tmp + 1] = R[3 * k + 1];
    H[H_tmp + 2] = R[3 * k + 2];
  }
  H[15] = 1.0;
}

/* End of code generation (axang2tform.c) */
