 function [S1,sys_c] = OPTIFUNCIONv2(w,Tp_pm,Hs_pm,gamma_pm,dt)

 % ---------------------- JONSWAP Spectrum -------------------------------
nw=length(w);
f=w/(2.*pi);
A=0.3125*Hs_pm^2/Tp_pm^4;
B=1.25/Tp_pm^4;
fp=1./Tp_pm;
m0=0.;
m_1=0.;
Pwave=0.;
Hw=zeros(1,nw);
S1=zeros(1,nw);
for i=2:nw
    fc=0.5*(f(i)+f(i-1));
    df=f(i)-f(i-1);
    S1(i)=A/fc^5*exp(-B/fc^4);
    if (fc<fp)
        sigma=0.07;
    else
        sigma=0.09;
    end
    pa=exp(-(fc-fp)^2/(2.*sigma^2*fp^2));
    S1(i)=S1(i)*gamma_pm^pa;
    m0=m0+S1(i)*df;
    m_1=m_1+S1(i)/fc*df;
end
alpha=Hs_pm^2/(16.*m0);
Te=m_1/m0;
for i=2:nw
    df=f(i)-f(i-1);
    S1(i)=S1(i)*alpha;
    Hw(i)=sqrt(2.*S1(i)*df);
    Pwave=Pwave+0.25*1025.*9.81*9.81*Hw(i)*Hw(i)/w(i);
end
%%------------------------- LPF -----------------------------------------
digFilt=designfilt('lowpassiir','PassbandFrequency',0.95,'StopbandFrequency',2,'PassbandRipple',1,'StopbandAttenuation',60,'SampleRate',100);
S1 = filter(digFilt,S1); 
% -----------------------------------------------------------------------

% --------------------------- LS ----------------------------------------
ydata1 = S1;
x = w;

% Optimized variables
G1 = optimvar('G','LowerBound',0)
k1 = optimvar('k',2,'LowerBound',0)
c1 = optimvar('c',2,'LowerBound',0)

% JONSWAP Spectrum function

fun1 = ((G1).*x.^4)./(((x.^2-k1(1)).^2+(c1(1).*x).^2).*(((x.^2)-k1(2)).^2 ... 
    +(c1(2).*x).^2)); % Fouth order filter
obj1 = sum((ydata1 - fun1).^2); % Least-Squares

lsqproblem1 = optimproblem("Objective",obj1); % Solving LSQ function

% Initial valuables
x1.G = [6.183];
x1.k = [0.398 1.794];
x1.c = [0.085 2.709];

% x1.G = [rand];
% x1.k = [rand rand];
% x1.c = [rand rand];

% Solving the optimization problem
show(lsqproblem1) %Shows the LS optimization problem
[sol1,fval1] = solve(lsqproblem1,x1,'solver',"fmincon")
disp(sol1.G)
disp(sol1.k)
disp(sol1.c)

% Save the new coeffients 
x1.G = sol1.G
x1.k = sol1.k
x1.c = sol1.c

figure 
responsedata = evaluate(fun1,sol1);
plot(f,ydata1,'r--',f,responsedata,'b--'); hold on;
xlim([0 0.5])
legend('Target spectrum','Approximate Spectrum')
xlabel('Frequency ($$Hz$$)','Interpreter','latex','FontSize',17)
ylabel('SDF','Interpreter','latex','FontSize',17)
title(['SDF obtained from LS Hs =',num2str(Hs_pm),'  $$\gamma$$ =',num2str(gamma_pm),' Tp =',num2str(Tp_pm),' $$dt$$ =',num2str(dt)],'Interpreter','latex','FontSize',17)
hold on
grid on

%------------------------ State Space model ------------------------------

% Cascading Two second order filters

% First filter
A_1_a = [0 1; -x1.k(1) -x1.c(1)];
B_1_a = [0;1];
C_1_a = [0 1];
D_1_a = zeros(2,1);
% Second filter
A_2_a = [0 1; -x1.k(2) -x1.c(2)];
B_2_a = sqrt(x1.G).*[0;1];
C_2_a = [0 1];
D_2_a = zeros(2,1);
% ABCD state space form
A_a = [A_1_a zeros(2,2); B_2_a.*C_1_a A_2_a];
B_a = [B_1_a;D_1_a];
C_a = [zeros(1,2) C_2_a];
D_a = 0;

sys_c = ss(A_a,B_a,C_a,D_a); % State- Space Coninuous
end