clc
close all
clear
rng('shuffle')

%% Defining the frequency range for the Kalman

df = 1e-3;  % frequency step [Hz]

fc = 2; % cut-off frequency [Hz]

%-------------------------------------------------------------------------
Tsim = 1000; % Duration of the simulated signal [s]

Bandwidth = 0.95-0; % [Hz]

dt = 1/(2*Bandwidth); % Time step

fs = 1/dt; % Frequency Step

t = 0:dt:Tsim; % Time
%----------------------------------------------------------------------

f = (0:0.0001:1)*fc;

w = 2*pi*f; % frequency range [rad/s]


% gamma_pm = linspace(1.5,2.5,10); % To calculate error variance
% Hs_pm = linspace(0.7,2,10); % To calculate error variance
% Tp_pm = linspace(4,12,10); % To calculate error variance
% d = length(Hs_pm) % Change according to the value that must be needed to vary -To calculate error variance

% gamma = linspace(1.5,2.5,10); % To calculate error variance
% Hs = linspace(0.7,1.3,5); % To calculate error variance
% Tp = linspace(2,10,10); % To calculate error variance
% d = length(Tp_pm) % Change according to the value that must be needed to vary

% for i = 1:d % To implement any variation in Tp/Hs/gamma - To calculate error variance

%% ----------------------------Kalman SSM - NOMINAL-----------------------%
Hs = 1;     % significant wave height [m]

gamma = 2;  % peak enhancement factor [].Realistic values are between 1 and 6.

Tp = 10;    % peak wave period [s].

[S,sys_nom] = OPTIFUNCIONv2(w,Tp,Hs,gamma,dt); % Continous Nominal Model

sys_t = c2d(sys_nom,dt); 
A_nom = sys_t.A; % To insert in Kalman filter
B_nom = sys_t.B; % To insert in Kalman filter
C_nom = sys_t.C; % To insert in Kalman filter 
D_nom = sys_t.D; % To insert in Kalman filter

%% ------- External Spectrum - CAN BE CHANGE FOR ANY OTHER TYPE OF PLANT---
%% ----------------------- PLANT type--------------------------------%
Hs_pm = 1; % significant wave height [m]

gamma_pm = 2; % peak enhancement factor

Tp_pm = 10; % peak wave period [s].

R = 0.001; % Measurement noise covariance
[S1,sys_plant] = OPTIFUNCIONv2(w,Tp_pm,Hs_pm,gamma_pm,dt); % Continous Plan Model
sys_plantd = c2d(sys_plant,dt);
S_pm = sys_plantd; % Every plant must be called as S_pm - Plant type 3
 
%% ----------------------- Empty matrices to be filled--------------------%
x_estimate = zeros(4,length(t)); % Empty matrix to save estimated states  

x_predicted = zeros(4,length(t)); % Empty matrix to save actual states

g = 1*randn(size(t)).'; % White noise - **To set the below matrix sizes **

random_reali=lsim(sys_t,g,t); % To set the below matrix sizes

[SDP_es,f1] = periodogram(random_reali,[],[],fs); % To set the above matrix sizes

l = 1000; % Number of iterations to create time series of random realisations

moy_k = zeros(length(SDP_es),l);  %Empty matrix to insert all the values from the SDP_k

moy_p = zeros(length(SDP_es),l);  %Empty matrix to insert all the values from the SDP_p                                

%% To create random realisations
for a = 1:l 
%% ------------ White noise and input plant--------------------------------
% White noise and plant similation are applied inside de loop to obtain
% each time a different random realisation and then average them.
g = 1*randn(size(t)); % White noise  ************************sensor

 
[y,~,x_p] = lsim(S_pm,g,t); % Plant + noise (Process noise) - Kalman input 
v = sqrt(R)*randn(length(t),1);
x_p = x_p';
y_p = y+v;

%% ------------ (non-toolbox) Kalman Filter ------------------------------
Q = B_nom*B_nom.'; % Process noise covariance

y_estimated2 = zeros(length(t),1); % Empty matrix to save estimate values
yerror = zeros(length(t),1); % Empty matrix to save estimate values

L = zeros(4,length(t)); % Gain matrix

x = [0;0;0;0]; % Initial conditions for the states
x0 = [0;0;0;0]; % Initial conditions for the states


P = Q; % Process covariance matrix can be set as a non-zero value

%---------------- Jacobians (Linearization part)-------------------------
syms x1 x2 x3 x4

state = A_nom*[x1;x2;x3;x4];
response = C_nom*[x1;x2;x3;x4];

A_nom = jacobian(state,[x1,x2,x3,x4]); % Class = Sym
C_nom = jacobian(response,[x1,x2,x3,x4]); % Class = Sym

A_nom = double(A_nom); % Class = Double
C_nom = double(C_nom); % Class = Double

%% -------------------State Space - Kalman ------------------%
for k = 1:length(t)

% 1 Calculate the gain
K = P*C_nom'/(C_nom*P*C_nom'+R); % Kalman Gain

% 2 Calculate the current estimate
x = x + K*(y_p(k)-C_nom*x);  % Current state estimate  
x_estimate(:,k) = x; % To save state values
% y_predicted(k) = C_nom*x;

% 3 Calculate the new error estimate P (Process Covariance Matrix) 
P = (eye(4)-K*C_nom)*P;      % Process Covariance Matrix (Error estimate)
y_estimated2(k) = C_nom*x;   % Current response estimate
L(:,k) = K; % Save the gain


% Caculate the new error estimate
x = A_nom*x + B_nom*0; %Actual state at x_o conditions 
P = A_nom*P*A_nom' + Q; % Update the new error estimate P  

x_predicted(:,k) = x; % To save state values

end
[SDP_k,f_k] = periodogram(y_estimated2,[],[],fs); % SDF - Kalman
[SDP_es,f1] = periodogram(y_p,[],[],fs); % SDF - model input
moy_k(:,a) = SDP_k; % Send each value of SDF to this empty matrix
moy(:,a) = SDP_es; % Send each value of SDF to this empty matrix}
end
% mean_error = mean_error.^2;
% ECM(:,i) = mean(mean_error,2)
SDF_km = mean(moy_k,2); % Mean of several iteration of the SDP from the Kalman filter
SDF_m = mean(moy,2); % Mean of several iteration of the SDP from the Model input
yerror = sum((yerror).^2)/length(yerror);
 
% To Calculate MSE
% MSE(i)= sum((y_estimated2-y_p).^2)/length(y_p);

% end % This end belongs to the for cycle need to vay the of PM

%% To plot the MSE do not forget to uncomment MSE and alls its depend variables
% figure
% plot(Hs_pm,MSE)
% xlabel('Hs','Interpreter','latex','FontSize',12)
% ylabel('MSE','Interpreter','latex','FontSize',12)
% legend(['MSE - Hs = [0.7-1.3]'],'Interpreter','latex','FontSize',11)
% title(['MSE =',num2str(mean(MSE))],'Interpreter','latex','FontSize',17)
% hold on 

%% To plot kalman filter
figure
plot(t,L)
% Plot Target response vs Estimation Response
figure
subplot(3,1,1)
plot(t,y_p,'r',t,y_estimated2,'b--')
xlabel('Time ($$s$$)','Interpreter','latex','FontSize',12)
ylabel('Displacement($$m$$)','Interpreter','latex','FontSize',12)
title('Estate Space Response - Random Realisations','Interpreter','latex','FontSize',12)
legend('Target', 'Estimation')

%% To plot States and error states, response and error response

% dt_kalm = std(x_p(1,:));
% Plot State variable 1 vs Estimated state variable 1
subplot(4,1,1)
plot(t,x_p(1,:),'r',t,x_predicted(1,:),'b',t,(x_predicted(1,:)-x_p(1,:)),'g--')
% yline(-dt_kalm*2);yline(dt_kalm*2)
xlabel('time ($$s$$)','Interpreter','latex','FontSize',12)
ylabel('$$x_1$$','Interpreter','latex','FontSize',12) 
legend('Target', 'Estimation','$$error_{x_1}$$','Interpreter','latex','FontSize',9)
title(['Estate Space - State variables $$error_{x_1}$$ =',num2str(sum(abs(x_predicted(1,:)-x_p(1,:)))/length(x_p(1,:)))],'Interpreter','latex','FontSize',12)
% Plot State variable 2 vs Estimated state variable 2
subplot(4,1,2)
plot(t,x_p(2,:),'r',t,x_predicted(2,:),'b',t,(x_predicted(2,:)-x_p(2,:)),'g--')
xlabel('time (s)','Interpreter','latex','FontSize',12)
ylabel('$$\dot{x_1}$$','Interpreter','latex','FontSize',12) 
legend('Target', 'Estimation','$$error_{\dot{x_1}}$$','Interpreter','latex','FontSize',9)
title(['$$error_{\dot{x_1}}$$ =',num2str(sum(abs(x_predicted(2,:)-x_p(2,:)))/length(x_p(2,:)))],'Interpreter','latex','FontSize',12)
% Plot State variable 3 vs Estimated state variable 3
subplot(4,1,3)
plot(t,x_p(3,:),'r',t,x_predicted(3,:),'b',t,(x_predicted(3,:)-x_p(3,:)),'g--')
xlabel('time (s)','Interpreter','latex','FontSize',12)
ylabel('$$x_2$$','Interpreter','latex','FontSize',12) 
legend('Target', 'Estimation','$$error_{x_2}$$','Interpreter','latex','FontSize',9)
title(['$$error_{x_2}$$ =',num2str(sum(abs(x_predicted(3,:)-x_p(3,:)))/length(x_p(3,:)))],'Interpreter','latex','FontSize',12)
% Plot State variable 4 vs Estimated state variable 4
subplot(4,1,4)
plot(t,x_p(4,:),'r',t,x_predicted(4,:),'b',t,(x_predicted(4,:)-x_p(4,:)),'g--')
xlabel('time (s)','Interpreter','latex','FontSize',17)
ylabel('$$\dot{x_2}$$','Interpreter','latex','FontSize',17) 
dt_kalm = std(x_p(4,:));
CI = 1.96;
yline(-dt_kalm*CI);yline(dt_kalm*CI)
legend('Plan Model - Target', 'Kalman Filter - Estimated','$$error_{\dot{x_2}}$$','Interpreter','latex','FontSize',11)
title(['$$error_{\dot{x_2}}$$ =',num2str(sum(abs(x_predicted(4,:)-x_p(4,:)))/length(x_p(4,:)))],'Interpreter','latex','FontSize',17)



% Plot Spectrum
figure
subplot(2,1,1)
% plot(f1,SDF_m,'b--',f_k,SDF_km,'g',f,S1,'r-')
plot(f,S1,'r',f1,SDF_m,'b')
xlim([0 0.5])
xlabel('Frequency ($$Hz$$)','Interpreter','latex','FontSize',17)
ylabel('SDF','Interpreter','latex','FontSize',17)
title(['SDF obtained from the white noise realizations Hp =',num2str(Hs_pm),'  $$\gamma$$ =',num2str(gamma_pm),' Tp =',num2str(Tp_pm),' $$dt$$ =',num2str(dt)],'Interpreter','latex','FontSize',15)
% legend('Plant Model - Spectrum', 'Kalman Filter - Estimatimated Spectrum', 'Target Spectrum')
legend('Target Spectrum','Approximate Spectrum','Interpreter','latex','FontSize',11)

% Plot Target response vs Estimation Response
subplot(2,1,2)
plot(t,y_p,'r-',t,y_estimated2,'b--',t,(y_estimated2-y_p),'g--')
xlabel('Time ($$s$$)','Interpreter','latex','FontSize',17)
ylabel('$$\eta$$','Interpreter','latex','FontSize',17)
dt_kalm = std(y);
CI = 1.96;
yline(-dt_kalm*CI);yline(dt_kalm*CI)
title('Estate Space Response - Random Realizations',['Estimation Error =',num2str(sum(abs(y_estimated2-y_p))/length(y_p))],'Interpreter','latex','FontSize',17)
legend('Plan Model - Target', 'Kalman Filter - Estimated','$$error_y$$','Interpreter','latex','FontSize',11)


% Plot Spectrum noisy/without noise
figure
plot(t,y,'r',t,y_p,'b--')
xlabel('Time ($$s$$)','Interpreter','latex','FontSize',17)
ylabel('$$\eta$$','Interpreter','latex','FontSize',17)
title('Random realisation Noise free/Noisy ','Interpreter','latex','FontSize',17)
legend('Noise free', 'Noisy','Interpreter','latex','FontSize',11)


% Plot Tesis


%% This plot is to obtain SS response of the random realization, the SDF
% And \x_2 dot variable which correspond to the only controllable variable
% In the system

figure
subplot(3,1,1)
plot(t,y_p,'r-',t,y_estimated2,'b--',t,(y_estimated2-y_p),'g--')
xlabel('Time ($$s$$)','Interpreter','latex','FontSize',17)
ylabel('$$\eta$$','Interpreter','latex','FontSize',17)
dt_kalm = std(y);
CI = 1.96;
yline(-dt_kalm*CI);yline(dt_kalm*CI)
title('a) Estate Space Response - Random Realizations',['Estimation Error =',num2str(sum(abs(y_estimated2-y_p))/length(y_p))],'Interpreter','latex','FontSize',17)
legend('Plan Model - Target', 'Kalman Filter - Estimated','$$error_y$$','Interpreter','latex','FontSize',11)

subplot(3,1,2)
plot(f,S1,'r',f_k,SDF_km,'b--')
xlim([0 0.5])
xlabel('Frequency ($$Hz$$)','Interpreter','latex','FontSize',17)
ylabel('SDF','Interpreter','latex','FontSize',17)
title(['b) SDF obtained from the white noise realizations Hs =',num2str(Hs_pm),'  $$\gamma$$ =',num2str(gamma_pm),' Tp =',num2str(Tp_pm),' $$dt$$ =',num2str(dt)],'Interpreter','latex','FontSize',17)
% legend('Plant Model - Spectrum', 'Kalman Filter - Estimatimated Spectrum', 'Target Spectrum')
legend('Plant Model - Target Spectrum','Kalman Filter - Estimatimated Spectrum','JONSWAP ALGORIHM','Interpreter','latex','FontSize',11)

subplot(3,1,3)
plot(t,x_p(4,:),'r',t,x_predicted(4,:),'b',t,(x_predicted(4,:)-x_p(4,:)),'g--')
xlabel('time (s)','Interpreter','latex','FontSize',17)
ylabel('$$\dot{x_2}$$','Interpreter','latex','FontSize',17) 
dt_kalm = std(x_p(4,:));
CI = 1.96;
yline(-dt_kalm*CI);yline(dt_kalm*CI)
legend('Plan Model - Target', 'Kalman Filter - Estimated','$$error_{\dot{x_2}}$$','Interpreter','latex','FontSize',11)
title(['c) $$error_{\dot{x_2}}$$ =',num2str(sum(abs(x_predicted(4,:)-x_p(4,:)))/length(x_p(4,:)))],'Interpreter','latex','FontSize',17)



% % Plot error
% subplot(7,1,7)
% plot(t,y_p,'r',t,(y_estimated2-y_p),'b--')
% xlabel('Time ($$s$$)','Interpreter','latex','FontSize',12)
% ylabel('Error','Interpreter','latex','FontSize',12)
% title(['Estimation Error =',num2str(sum(abs(y_estimated2-y_p))/length(y_p))],'Interpreter','latex','FontSize',12)

