close all

%figure
% hold on
% grid on
% plot(t1, speed1, 'r-', 'LineWidth', 1)
% plot(t2(1:4000, 1), speed2(1:4000, 1), 'b-.', 'LineWidth', 1)
% plot(t2(4000:size(t2, 1), 1), speed2(4000:size(t2, 1), 1), 'b-', 'LineWidth', 1)
% plot(t3, speed3*3.6, 'Color', [0 0.5 0], 'LineWidth', 1)
% set(gca, 'fontsize', 14)
% title('SORT Cycles', 'FontSize', 22)
% xlabel('Time [s]', 'FontSize', 16)
% xlim([0 940])
% ylabel('Speed [km/h]', 'FontSize', 16)
% ylim([0 65])
% legend('SORT 1', '', 'SORT 2', 'SORT 3', 'FontSize', 16)

figure
hold on
grid on
plot(time1, RefSpeed1*3.6, 'k', 'LineWidth', 1)
set(gca, 'fontsize', 14)
title('RDC #1 Cycle', 'FontSize', 22)
xlabel('Time [s]', 'FontSize', 16)
xlim([0 2875])
ylabel('Speed [km/h]', 'FontSize', 16)
ylim([0 65])

yyaxis right
ylim([-10 22.5])
ylabel('Inclination [%]', 'FontSize', 16)
plot(time1, Inc1, 'Color', [1, 0.4, 0.2], 'LineWidth', 1)
