# -*- coding: utf-8 -*-
"""
Created on Thu Dec 22 16:26:17 2022

@author: agnes
"""

import numpy as np
import pandas as pd

# ACQUISITION OF INPUT DATA THROUGH CSV FILES
# (index, Coordinate-Left, Coordinate-Top, Coordinate-Right, Coordinate-Bottom, Value)
arr_pd = pd.read_csv("Population.csv").to_numpy()        # population density
arr_sun = pd.read_csv("SunGHI.csv").to_numpy()           # global horizontal irradiation
arr_wind = pd.read_csv("windCF.csv").to_numpy()          # wind capacity factor
arr_dist = pd.read_csv('GridDistance.csv').to_numpy()    # distance pf each spot from the grid
arr_slope = pd.read_csv('Slope.csv').to_numpy()          # terrain slope

# MAXIMUM AND MINIMUM VALUES FOR EACH DATASET
max_pd = np.max(arr_pd[:,3]);           # population density
min_pd = np.min(arr_pd[:,3]);
max_sun = np.max(arr_sun[:,3]);         # global horizontal irradiation
min_sun = np.min(arr_sun[:,3]);
max_wind = np.max(arr_wind[:,3]);       # wind capacity factor
min_wind = np.min(arr_wind[:,3]);
max_dist = np.max(arr_dist[:,3]);       # distance pf each spot from the grid
min_dist = np.min(arr_dist[:,3]);
max_slope = np.max(arr_slope[:,3]);     # terrain slope
min_slope = np.min(arr_slope[:,3]);

# ESTABLISHMENT OF THRESHOLD VALUES
mean_cf = np.mean(arr_wind[:,3]);
cf_thresh = 2*mean_cf;                  # threshold for wind capacity factor
dist_thresh = max_dist/4;               # threshold for grid distance (on-grid/off-grid)
slope_thresh = 20;                      # threshold for terrain slope for wid turbines

# VECTORS TO STORE THE SCORES OF EACH SPOT IN THE MAP
offgrid_score_hybrid = np.zeros([1,4]); # Hybrid plant off-grid
offgrid_score_sun = np.zeros([1,4]);    # PV plant off-grid
ongrid_score_hybrid = np.zeros([1,4]);  # Hybrid plant on-grid
ongrid_score_sun = np.zeros([1,4]);     # PV plant on-grid

newrow = np.zeros([1,4]);

ii = 0;
aa = 0;
bb = 0;
cc = 0;
dd = 0;

# LOOP FOR CALCULATION OF THE SCORES FOR EACH SPOT
for ii in range(0,len(arr_pd)):
    # Acquisition of values for population density, grid distance, GHI, wind and slope
    v_pd = arr_pd[ii,3];
    v_sun = arr_sun[ii,3];
    v_dist = arr_dist[ii,3];
    v_wind = arr_wind[ii,3];
    v_slope = arr_slope[ii,3];
    # Sun - score calculation
    score_sun = (v_sun - min_sun)/(max_sun - min_sun);
    # ON-GRID CASE (verification to be below the threshold distance)
    if v_dist <= dist_thresh:
        # Grid distance - score calculation
        score_dist = 1 - (v_dist - min_dist)/(dist_thresh - min_dist);
        # HYBRID ON-GRID CASE (Verification of parameters liked to wind resource)
        if v_wind > cf_thresh and v_slope <= slope_thresh:
            # Wind, slope, population density - score calculation
            score_wind = (v_wind - min_wind)/(max_wind - min_wind);
            score_slope = 1 - (v_slope - min_slope)/(slope_thresh - min_slope);
            score_pd = 1 - (v_pd - min_pd)/(max_pd - min_pd);
            # TOTAL SCORE (in percentage)
            totalscore_perc = (score_pd + score_sun + score_dist + score_wind + score_slope)/5*100
            # 
            ongrid_score_hybrid[aa,:] = [aa, arr_pd[ii,1], arr_pd[ii,2], totalscore_perc];
            ongrid_score_hybrid = np.vstack([ongrid_score_hybrid, newrow]);
            aa += 1;
        else:
        # PV ON-GRID CASE (if wind parameters are not satisfied)
            # TOTAL SCORE (in percentage)
            totalscore_perc = (score_sun + score_dist)/2*100
            #
            ongrid_score_sun[bb,:] = [bb, arr_pd[ii,1], arr_pd[ii,2], totalscore_perc]
            ongrid_score_sun = np.vstack([ongrid_score_sun, newrow]);
            bb += 1;
    else:
    # OFF-GRID CASE
        # HYBRID OFF-GRID CASE (Verification of parameters liked to wind resource)
        if v_wind > cf_thresh and v_slope <= slope_thresh:
            # Wind score calculation
            score_wind = (v_wind - min_wind)/(max_wind - min_wind);
            score_slope = (v_slope - min_slope)/(slope_thresh - min_slope);
            score_pd = 1 - (v_pd - min_pd)/(max_pd - min_pd);
            # TOTAL SCORE (in percentage)
            totalscore_perc = (score_pd + score_sun + score_wind + score_slope)/4*100
            #
            offgrid_score_hybrid[cc,:] = [cc, arr_pd[ii,1], arr_pd[ii,2], totalscore_perc];
            offgrid_score_hybrid = np.vstack([offgrid_score_hybrid, newrow]);
            cc += 1;
        else:
        # PV OFF-GRID CASE (if wind parameters are not satisfied)
            # TOTAL SCORE (in percentage)
            totalscore_perc = score_sun*100
            #
            offgrid_score_sun[dd,:] = [dd, arr_pd[ii,1], arr_pd[ii,2], totalscore_perc]
            offgrid_score_sun = np.vstack([offgrid_score_sun, newrow]);
            dd += 1;
    print(ii)
#
if ongrid_score_hybrid[len(ongrid_score_hybrid)-1,1] == 0:
    ongrid_score_hybrid = ongrid_score_hybrid[:-1, :]
if ongrid_score_sun[len(ongrid_score_sun)-1,1] == 0:
    ongrid_score_sun = ongrid_score_sun[:-1, :]
if offgrid_score_hybrid[len(offgrid_score_hybrid)-1,1] == 0:
    offgrid_score_hybrid = offgrid_score_hybrid[:-1, :]
if offgrid_score_sun[len(offgrid_score_sun)-1,1] == 0:
    offgrid_score_sun = offgrid_score_sun[:-1, :]

## CALCULATION OF ABSOLUTE MAXIMA AND LAST PERCENTILE
# PV OFF-GRID
if not np.all(offgrid_score_sun):     # Verification to have at least one suitable value
    # Find the maximum score and its location    
    ind_max_offgrid_sun = np.where(offgrid_score_sun[:,3] == np.max(offgrid_score_sun[:,3]));
    max_offgrid_sun = offgrid_score_sun[ind_max_offgrid_sun];
    # Store of the value
    np.savetxt("max_abs_offgrid_sun.csv", max_offgrid_sun, delimiter=",", header='ID,X,Y,Score [%]')
    ee = 0;
    sun_offgrid_max = np.zeros([1,4]);
    for ii in range(0,len(offgrid_score_sun)):
        # Last percentile calculated in order to have some tens of values
        if offgrid_score_sun[ii,3] > 0.90*max_offgrid_sun[0,3]:
            sun_offgrid_max[ee,:] = [ee, offgrid_score_sun[ii,1], offgrid_score_sun[ii,2], offgrid_score_sun[ii,3]];
            sun_offgrid_max = np.vstack([sun_offgrid_max, newrow]);
            ee += 1;
    if sun_offgrid_max[len(sun_offgrid_max)-1,1] == 0:
        sun_offgrid_max = sun_offgrid_max[:-1, :]
    # Store of the values
    np.savetxt("maxima_sun_offgrid.csv", sun_offgrid_max, delimiter=",", header='ID,X,Y,Score [%]')
   
# OFFGRID HYBRID
if not  np.all(offgrid_score_hybrid):   # Verification to have at least one suitable value
    # Find the maximum score and its location      
    ind_max_offgrid_hybrid =  np.where(offgrid_score_hybrid[:,3] == np.max(offgrid_score_hybrid[:,3]));
    max_offgrid_hybrid  = offgrid_score_hybrid[ind_max_offgrid_hybrid];
    # Store of the value
    np.savetxt("max_abs_offgrid_hybrid.csv", max_offgrid_hybrid, delimiter=",", header='ID,X,Y,Score [%]')
    #
    ff = 0;
    hybrid_offgrid_max = np.zeros([1,4]);
    for ii in range(0,len(offgrid_score_hybrid)):
        # Last percentile calculated in order to have some tens of values
        if offgrid_score_hybrid[ii,3] > 0.75*max_offgrid_hybrid[0,3]:
            hybrid_offgrid_max[ff,:] = [ff, offgrid_score_hybrid[ii,1], offgrid_score_hybrid[ii,2], offgrid_score_hybrid[ii,3]];
            hybrid_offgrid_max = np.vstack([hybrid_offgrid_max, newrow]);
            ff += 1;
    if hybrid_offgrid_max[len(hybrid_offgrid_max)-1,1] == 0:
        hybrid_offgrid_max = hybrid_offgrid_max[:-1, :]
    # Store of the values
    np.savetxt("maxima_hybrid_offgrid.csv", hybrid_offgrid_max, delimiter=",", header='ID,X,Y,Score [%]')

# ONGRID SUN ONLY
if not  np.all(ongrid_score_sun):       # Verification to have at least one suitable value
    # Find the maximum score and its location    
    ind_max_ongrid_sun =  np.where(ongrid_score_sun[:,3] == np.max(ongrid_score_sun[:,3]));
    max_ongrid_sun = ongrid_score_sun[ind_max_ongrid_sun];
    # Store of the value
    np.savetxt("max_abs_ongrid_sun.csv", max_ongrid_sun, delimiter=",", header='ID,X,Y,Score [%]')
    gg = 0;
    sun_ongrid_max = np.zeros([1,4]);
    for ii in range(0,len(ongrid_score_sun)):
        # Last percentile calculated in order to have some tens of values
        if ongrid_score_sun[ii,3] > 0.90*max_ongrid_sun[0,3]:
            sun_ongrid_max[gg,:] = [gg, ongrid_score_sun[ii,1], ongrid_score_sun[ii,2], ongrid_score_sun[ii,3]];
            sun_ongrid_max = np.vstack([sun_ongrid_max, newrow]);
            gg += 1;
    if sun_ongrid_max[len(sun_ongrid_max)-1,1] == 0:
        sun_ongrid_max = sun_ongrid_max[:-1, :]
    # Store of the values
    np.savetxt("maxima_sun_ongrid.csv", sun_ongrid_max, delimiter=",", header='ID,X,Y,Score [%]')
    
# ONGRID HYBRID
if not  np.all(ongrid_score_hybrid):    # Verification to have at least one suitable value
    # Find the maximum score and its location    
    ind_max_ongrid_hybrid =  np.where(ongrid_score_hybrid[:,3] == np.max(ongrid_score_hybrid[:,3]));
    max_ongrid_hybrid  = ongrid_score_hybrid[ind_max_ongrid_hybrid];
    # Store of the value
    np.savetxt("max_abs_ongrid_hybrid.csv", max_ongrid_hybrid, delimiter=",", header='ID,X,Y,Score [%]')
    hh = 0;
    hybrid_ongrid_max = np.zeros([1,4]);
    for ii in range(0,len(ongrid_score_hybrid)):
        # Last percentile calculated in order to have some tens of values
        if ongrid_score_hybrid[ii,3] > 0.85*max_ongrid_hybrid[0,3]:
            hybrid_ongrid_max[hh,:] = [hh, ongrid_score_hybrid[ii,1], ongrid_score_hybrid[ii,2], ongrid_score_hybrid[ii,3]];
            hybrid_ongrid_max = np.vstack([hybrid_ongrid_max, newrow]);
            hh += 1;
    if hybrid_ongrid_max[len(hybrid_ongrid_max)-1,1] == 0:
        hybrid_ongrid_max = hybrid_ongrid_max[:-1, :]
    # Store of the values
    np.savetxt("maxima_hybrid_ongrid.csv", hybrid_ongrid_max, delimiter=",", header='ID,X,Y,Score [%]')
    
# Store of all values
np.savetxt("score_ongrid_sun.csv", ongrid_score_sun, delimiter=",", header='ID,X,Y,Score [%]')
np.savetxt("score_ongrid_hybrid.csv", ongrid_score_hybrid, delimiter=",", header='ID,X,Y,Score [%]')
np.savetxt("score_offgrid_sun.csv", offgrid_score_sun, delimiter=",", header='ID,X,Y,Score [%]')
np.savetxt("score_offgrid_hybrid.csv", offgrid_score_hybrid, delimiter=",", header='ID,X,Y,Score [%]')
