function [PRV] = pulseratevariability(signal,c,ka,kb,fs)

signal_f = filtfilt(kb,ka,signal(((c-1)*250+1): c*250));

[pmin,indmin] = findpeaks(-signal_f);  % findpeaks to find all the minima relative and absolute 
% in the range of 250 samples 
mval = mean(signal_f);    % calculate the mean value of the 150 samples range    
t = 1;
j = 1;

for k= 1: length(pmin)
    if indmin(k) - 5 > 0
    if -pmin(k) < mval && signal_f(indmin(k)-5) > -pmin(k) 
 % 1st condition: if the minimun is < than the mean value is accepted
 % 2nd condition: if the value of the signal at five samples before the one
 % analyzed is higher than the minimum
 % then it can be an absolute minimum

 
        index(t) = indmin(k); % set in the vector "index" the index
        % of the minimum found + the samples shift
        
        if t == 1
            itsmin(j) = -pmin(k);     % acquire the first absolute minimum
            itsind(j) = indmin(k);
            j = j+1;
        end   
        
       if t > 1 && index(t)-index(t-1) > 15  % acquire the absolute minimum 
           % if the different of the index w.r.t
           % the previous minimum is > 20 samples ---> this means that is
           % an absolute minimum
           
            itsmin(j) = -pmin(k);
            itsind(j) = indmin(k) ;
            j = j+1;
       end
        
         t = t+1;
    end
  end
end

j = 0;
k = 0;
for z = 2 : length(itsind)
    
    IBI(z-1) = (itsind(z)-itsind(z-1));              % calculate the IBI between the first two minima
    
    if z >= 3
        j = j+1;
        val(j) = abs((IBI(z-1)-IBI(z-2))*1000/fs);     % *1000 to calculate the value in [ms] 
        
        if val(j) > 0
        k= k+1;
        prv(k) = val(j);
        end  
    else
         prv = 0;                             % if only two minima are detected set the value of prv to 0
    end
end

 PRV = round(sum(prv)/j);

end