function [pr] = pulserate_f(signal,c,ka,kb)

signal_f = filtfilt(kb,ka,signal(((c-1)*250+1): c*250));

[pmin,indmin] = findpeaks(-signal_f);  % findpeaks to find all the minima relative and absolute 
% in the range of 150 samples 
mval = mean(signal_f);    % calculate the mean value of the 250 samples range    
t = 1;
j = 1;

for k= 1: length(pmin)
    if indmin(k) - 5 > 0
    if -pmin(k) < mval && signal_f(indmin(k)-5) > -pmin(k) %&& signal_f(indmin(k)-5) > mval
        
 % 1st condition: if the minimun is < than the mean value is accepted
 % 2nd condition: if the value of the signal at five samples before the one
 % analyzed is higher than the minimum
 % then it can be an absolute minimum

 
        index(t) = indmin(k); % set in the vector "index" the index
        % of the minimum found 
        
        if t == 1
            itsmin(j) = -pmin(k);     % acquire the first absolute minimum
            itsind(j) = indmin(k);
            j = j+1;
        end   
        
       if t > 1 && index(t)-index(t-1) > 15  % acquire the absolute minimum 
           % if the difference of the index w.r.t
           % the previous minimum is > 15 samples ---> this means that is
           % an absolute minimum
           
            itsmin(j) = -pmin(k);
            itsind(j) = indmin(k) ;
            j = j+1;
       end
        
         t = t+1;
    end
  end
end


for z= 2 : length(itsind)
    
    val(z-1) = (3000/(itsind(z)-itsind(z-1))); % save in the vector "val" 
    % the values of bpm for each cardiac cycle
    
    
end
  
   pr = round(sum(val)/(length(itsind)-1)); % average value for heartrate in bpm
   

end
