function [SpO2] = arterialoxysat_rms(signal1,signal2,c,ka,kb)


signal1_f = filtfilt(kb,ka,signal1(((c-1)*250+1): c*250+5));
signal2_f = filtfilt(kb,ka,signal2(((c-1)*250+1): c*250+5));

RMS_R = rms(signal1_f);
RMS_IR = rms(signal2_f);

RoR = RMS_R/RMS_IR;

valsat = round(111.26 - 22.798*RoR);

if valsat >= 100
    SpO2 = 99;
else 
    SpO2 = valsat;
end


end